/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.transport;

import com.openexchange.exception.OXException;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailSessionCache;
import com.openexchange.mail.MailSessionParameterNames;
import com.openexchange.mail.Protocol;
import com.openexchange.mail.transport.TransportProvider;
import com.openexchange.mail.transport.config.TransportConfig;
import com.openexchange.mail.transport.config.TransportProperties;
import com.openexchange.mail.utils.ProviderUtility;
import com.openexchange.session.Session;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class TransportProviderRegistry {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(TransportProviderRegistry.class));
    private static final Map<Protocol, TransportProvider> providers = new ConcurrentHashMap<Protocol, TransportProvider>();

    private TransportProviderRegistry() {
    }

    public static TransportProvider getTransportProviderBySession(Session session, int accountId) throws OXException {
        String protocol;
        TransportProvider provider;
        MailSessionCache mailSessionCache = MailSessionCache.getInstance(session);
        String key = MailSessionParameterNames.getParamTransportProvider();
        try {
            provider = (TransportProvider)mailSessionCache.getParameter(accountId, key);
        }
        catch (ClassCastException e) {
            provider = null;
        }
        String transportServerURL = TransportConfig.getTransportServerURL(session, accountId);
        if (transportServerURL == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)new StringAllocator(128).append("Missing transport server URL. Transport server URL not set in account ").append(accountId).append(" for user ").append(session.getUserId()).append(" in context ").append(session.getContextId()).append(". Using fallback protocol ").append(TransportProperties.getInstance().getDefaultTransportProvider()));
            }
            protocol = TransportProperties.getInstance().getDefaultTransportProvider();
        } else {
            protocol = ProviderUtility.extractProtocol(transportServerURL, TransportProperties.getInstance().getDefaultTransportProvider());
        }
        if (null != provider && !provider.isDeprecated() && provider.supportsProtocol(protocol)) {
            return provider;
        }
        provider = TransportProviderRegistry.getTransportProvider(protocol);
        if (null == provider || !provider.supportsProtocol(protocol)) {
            throw MailExceptionCode.UNKNOWN_TRANSPORT_PROTOCOL.create(transportServerURL);
        }
        mailSessionCache.putParameter(accountId, key, provider);
        return provider;
    }

    public static TransportProvider getTransportProviderByURL(String serverUrl) {
        return TransportProviderRegistry.getTransportProvider(ProviderUtility.extractProtocol(serverUrl, TransportProperties.getInstance().getDefaultTransportProvider()));
    }

    public static TransportProvider getTransportProvider(String protocol) {
        if (null == protocol) {
            return null;
        }
        for (Map.Entry<Protocol, TransportProvider> entry : providers.entrySet()) {
            if (!entry.getKey().isSupported(protocol)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static boolean registerTransportProvider(String protocol, TransportProvider provider) throws OXException {
        Protocol p = Protocol.parseProtocol(protocol);
        if (providers.containsKey(p)) {
            return false;
        }
        try {
            provider.startUp();
            provider.setDeprecated(false);
            providers.put(p, provider);
            return true;
        }
        catch (OXException e) {
            throw e;
        }
        catch (RuntimeException t) {
            LOG.error((Object)t.getMessage(), (Throwable)t);
            return false;
        }
    }

    public static void unregisterAll() {
        for (TransportProvider provider : providers.values()) {
            try {
                provider.setDeprecated(true);
                provider.shutDown();
            }
            catch (OXException e) {
                LOG.error((Object)"Mail connection implementation could not be shut down", (Throwable)e);
            }
            catch (RuntimeException t) {
                LOG.error((Object)"Mail connection implementation could not be shut down", (Throwable)t);
            }
        }
        providers.clear();
    }

    public static TransportProvider unregisterTransportProvider(TransportProvider provider) throws OXException {
        if (!providers.containsKey(provider.getProtocol())) {
            return null;
        }
        TransportProvider removed = providers.remove(provider.getProtocol());
        if (null == removed) {
            return null;
        }
        try {
            removed.setDeprecated(true);
            removed.shutDown();
            return removed;
        }
        catch (OXException e) {
            throw e;
        }
        catch (RuntimeException t) {
            LOG.error((Object)t.getMessage(), (Throwable)t);
            return removed;
        }
    }

    public static TransportProvider unregisterTransportProviderByProtocol(String protocol) throws OXException {
        Iterator<Map.Entry<Protocol, TransportProvider>> iter = providers.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Protocol, TransportProvider> entry = iter.next();
            if (!entry.getKey().isSupported(protocol)) continue;
            iter.remove();
            entry.getValue().setDeprecated(true);
            entry.getValue().shutDown();
            return entry.getValue();
        }
        return null;
    }
}

