/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.search;

import com.openexchange.exception.OXException;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailField;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.search.ComparablePattern;
import com.openexchange.mail.search.ComparisonType;
import com.openexchange.mail.search.SearchTerm;
import com.openexchange.mail.search.SearchTermVisitor;
import java.util.Collection;
import java.util.Date;
import javax.mail.Message;
import javax.mail.MessagingException;

public final class ReceivedDateTerm
extends SearchTerm<ComparablePattern<Date>> {
    private static final long serialVersionUID = -3566780904070234005L;
    private final ComparablePattern<Date> pattern;

    public ReceivedDateTerm(final ComparisonType comparisonType, final Date receivedDate) {
        this.pattern = new ComparablePattern<Date>(){

            @Override
            public ComparisonType getComparisonType() {
                return comparisonType;
            }

            @Override
            public Date getPattern() {
                return receivedDate;
            }
        };
    }

    @Override
    public void accept(SearchTermVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ComparablePattern<Date> getPattern() {
        return this.pattern;
    }

    @Override
    public void addMailField(Collection<MailField> col) {
        col.add(MailField.RECEIVED_DATE);
    }

    @Override
    public boolean matches(MailMessage mailMessage) {
        Date receivedDate = mailMessage.getReceivedDate();
        if (null == receivedDate) {
            return false;
        }
        Object pattern = this.getPattern();
        ComparisonType comparisonType = pattern.getComparisonType();
        if (ComparisonType.EQUALS == comparisonType) {
            return ((Date)pattern.getPattern()).getTime() == receivedDate.getTime();
        }
        if (ComparisonType.LESS_THAN == comparisonType) {
            return ((Date)pattern.getPattern()).getTime() > receivedDate.getTime();
        }
        if (ComparisonType.GREATER_THAN == comparisonType) {
            return ((Date)pattern.getPattern()).getTime() < receivedDate.getTime();
        }
        return ((Date)pattern.getPattern()).getTime() == receivedDate.getTime();
    }

    @Override
    public boolean matches(Message msg) throws OXException {
        Date receivedDate;
        try {
            receivedDate = msg.getReceivedDate();
        }
        catch (MessagingException e) {
            Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(ReceivedDateTerm.class)).warn((Object)"Error during search.", (Throwable)e);
            return false;
        }
        if (null == receivedDate) {
            return false;
        }
        Object pattern = this.getPattern();
        ComparisonType comparisonType = pattern.getComparisonType();
        if (ComparisonType.EQUALS == comparisonType) {
            return ((Date)pattern.getPattern()).getTime() == receivedDate.getTime();
        }
        if (ComparisonType.LESS_THAN == comparisonType) {
            return ((Date)pattern.getPattern()).getTime() > receivedDate.getTime();
        }
        if (ComparisonType.GREATER_THAN == comparisonType) {
            return ((Date)pattern.getPattern()).getTime() < receivedDate.getTime();
        }
        return ((Date)pattern.getPattern()).getTime() == receivedDate.getTime();
    }

    @Override
    public javax.mail.search.SearchTerm getJavaMailSearchTerm() {
        Object pattern = this.getPattern();
        return new javax.mail.search.ReceivedDateTerm(pattern.getComparisonType().getType(), (Date)pattern.getPattern());
    }

    @Override
    public javax.mail.search.SearchTerm getNonWildcardJavaMailSearchTerm() {
        return this.getJavaMailSearchTerm();
    }
}

