/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.filler;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.contact.ContactService;
import com.openexchange.conversion.ConversionService;
import com.openexchange.conversion.Data;
import com.openexchange.conversion.DataProperties;
import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.ManagedFile;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.html.HtmlService;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.image.ImageDataSource;
import com.openexchange.image.ImageLocation;
import com.openexchange.image.ImageUtility;
import com.openexchange.java.Charsets;
import com.openexchange.java.HTMLDetector;
import com.openexchange.java.Streams;
import com.openexchange.java.StringAllocator;
import com.openexchange.java.Strings;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.log.LogProperties;
import com.openexchange.log.Props;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposeType;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.dataobjects.compose.ComposedMailPart;
import com.openexchange.mail.dataobjects.compose.ReferencedMailPart;
import com.openexchange.mail.dataobjects.compose.TextBodyMailPart;
import com.openexchange.mail.mime.ContentDisposition;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.datasource.MessageDataSource;
import com.openexchange.mail.mime.utils.ImageMatcher;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.mime.utils.sourcedimage.SourcedImage;
import com.openexchange.mail.mime.utils.sourcedimage.SourcedImageUtility;
import com.openexchange.mail.text.TextProcessing;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.regex.MatcherReplacer;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import com.openexchange.tools.versit.Versit;
import com.openexchange.tools.versit.VersitDefinition;
import com.openexchange.tools.versit.VersitObject;
import com.openexchange.tools.versit.converter.ConverterException;
import com.openexchange.tools.versit.converter.OXContainerConverter;
import com.openexchange.user.UserService;
import com.openexchange.version.Version;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MailDateFormat;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.idn.IDNA;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.net.QuotedPrintableCodec;

public class MimeMessageFiller {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(MimeMessageFiller.class));
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private static final String PREFIX_PART = "part";
    private static final String EXT_EML = ".eml";
    private static final int BUF_SIZE = 8192;
    private static final String VERSION_1_0 = "1.0";
    private static final String VCARD_ERROR = "Error while appending user VCard";
    private static final String MP_ALTERNATIVE = "alternative";
    private static final String MP_RELATED = "related";
    private static final String REPLACE_CS = "#CS#";
    private static final String PAT_TEXT_CT = "text/plain; charset=#CS#";
    private static final String PAT_HTML_CT = "text/html; charset=#CS#";
    protected final Session session;
    protected final Context ctx;
    protected final UserSettingMail usm;
    protected int accountId;
    private Set<String> uploadFileIDs;
    private Set<String> contentIds;
    private boolean discardReferencedInlinedImages = true;
    private final HtmlService htmlService = ServerServiceRegistry.getInstance().getService(HtmlService.class);
    private static final Set<String> LOCAL_ADDRS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("127.0.0.1", "localhost", "::1")));
    private static final String[] SUPPRESS_HEADERS = new String[]{"X-OX-VCard-Attached", "X-OXMsgref", "X-OX-Marker", "X-OX-Notification", "Importance", "X-Priority", "X-Mailer"};
    private static final String HTML_SPACE = "&#160;";
    private static final Pattern PATTERN_IMG = Pattern.compile("<img[^>]*/?>", 2);
    private static final Pattern PATTERN_IMG_ALT = Pattern.compile("alt=\"([^\"]+)\"", 2);
    private static final Pattern PATTERN_SRC = Pattern.compile("<img[^>]*?src=\"([^\"]+)\"[^>]*/?>", 2);
    private static final Pattern PATTERN_AMP = Pattern.compile(Pattern.quote("&amp;"));
    private static final String VERSION_NAME = "Open-Xchange";
    private static final Pattern PATTERN_CODE_POINT = Pattern.compile("%u00([a-fA-F0-9]{2})");
    private static final Pattern PATTERN_DASHES = Pattern.compile("-+");

    public MimeMessageFiller(Session session, Context ctx) {
        this(session, ctx, UserSettingMailStorage.getInstance().getUserSettingMail(session.getUserId(), ctx));
    }

    public MimeMessageFiller(Session session, Context ctx, UserSettingMail usm) {
        this.session = session;
        this.ctx = ctx;
        this.usm = usm;
    }

    public MimeMessageFiller setDiscardReferencedInlinedImages(boolean discardReferencedInlinedImages) {
        this.discardReferencedInlinedImages = discardReferencedInlinedImages;
        return this;
    }

    public MimeMessageFiller setAccountId(int accountId) {
        this.accountId = accountId;
        return this;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public void deleteReferencedUploadFiles() {
        if (this.uploadFileIDs != null) {
            int size = this.uploadFileIDs.size();
            Iterator<String> iter = this.uploadFileIDs.iterator();
            ManagedFileManagement mfm = ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class);
            if (mfm != null) {
                for (int i = 0; i < size; ++i) {
                    try {
                        mfm.removeByID(iter.next());
                        continue;
                    }
                    catch (OXException e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            this.uploadFileIDs.clear();
        }
    }

    public void setCommonHeaders(MimeMessage mimeMessage) throws MessagingException {
        mimeMessage.setHeader("X-Mailer", "Open-Xchange Mailer v" + Version.getInstance().getVersionString());
        if (this.accountId <= 0) {
            try {
                ContactService contactService = ServerServiceRegistry.getInstance().getService(ContactService.class);
                String organization = contactService.getOrganization(this.session);
                if (null != organization && 0 < organization.length()) {
                    String encoded = MimeUtility.fold((int)14, (String)MimeUtility.encodeText((String)organization, (String)MailProperties.getInstance().getDefaultMimeCharset(), null));
                    mimeMessage.setHeader("Organization", encoded);
                }
            }
            catch (Exception e) {
                if (DEBUG) {
                    LOG.warn((Object)"Header \"Organization\" could not be set", (Throwable)e);
                }
                LOG.warn((Object)"Header \"Organization\" could not be set.");
            }
        }
        if (MailProperties.getInstance().isAddClientIPAddress()) {
            MimeMessageFiller.addClientIPAddress(mimeMessage, this.session);
        }
    }

    public static void addClientIPAddress(MimeMessage mimeMessage, Session session) throws MessagingException {
        String localIp = session.getLocalIp();
        if (MimeMessageFiller.isLocalhost(localIp)) {
            Props logProperties;
            if (DEBUG) {
                LOG.debug((Object)("Session provides localhost as client IP address: " + localIp));
            }
            String clientIp = null == (logProperties = LogProperties.optLogProperties()) ? null : (String)logProperties.get(LogProperties.Name.AJP_REQUEST_IP);
            mimeMessage.setHeader("X-Originating-IP", clientIp == null ? localIp : clientIp);
        } else {
            mimeMessage.setHeader("X-Originating-IP", localIp);
        }
    }

    private static boolean isLocalhost(String localIp) {
        return LOCAL_ADDRS.contains(localIp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageHeaders(ComposedMailMessage mail, MimeMessage mimeMessage) throws MessagingException, OXException {
        String[] userFlags;
        Object sender;
        if (mail.containsFrom()) {
            MailAccountStorageService mass;
            InternetAddress from = mail.getFrom()[0];
            sender = null;
            mimeMessage.setFrom((Address)from);
            if (null == sender && null != (mass = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class))) {
                try {
                    String sendAddr;
                    int userId = this.session.getUserId();
                    int contextId = this.session.getContextId();
                    int id = mass.getByPrimaryAddress(from.getAddress(), userId, contextId);
                    if (id < 0 && (id = mass.getByPrimaryAddress(IDNA.toIDN((String)from.getAddress()), userId, contextId)) < 0 && (sendAddr = this.usm.getSendAddr()) != null && sendAddr.length() > 0) {
                        try {
                            sender = new QuotedInternetAddress(sendAddr, true);
                        }
                        catch (AddressException e) {
                            LOG.error((Object)"Default send address cannot be parsed", (Throwable)e);
                        }
                    }
                }
                catch (OXException e) {
                    LOG.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
            UserService userService = ServerServiceRegistry.getInstance().getService(UserService.class, true);
            User user = userService.getUser(this.session.getUserId(), this.ctx);
            ArrayList<QuotedInternetAddress> aliases = new ArrayList<QuotedInternetAddress>();
            for (String alias : user.getAliases()) {
                aliases.add(new QuotedInternetAddress(alias));
            }
            if (sender != null && !from.equals(sender) && !aliases.contains(from)) {
                mimeMessage.setSender((Address)sender);
            }
        }
        if (mail.containsTo()) {
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])mail.getTo());
        }
        if (mail.containsCc()) {
            mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])mail.getCc());
        }
        if (mail.containsBcc()) {
            mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])mail.getBcc());
        }
        this.setReplyTo(mail, mimeMessage);
        if (mail.containsSubject()) {
            mimeMessage.setSubject(mail.getSubject(), MailProperties.getInstance().getDefaultMimeCharset());
        }
        if (mail.containsSentDate()) {
            MailDateFormat mdf;
            sender = mdf = MimeMessageUtility.getMailDateFormat(this.session);
            synchronized (sender) {
                mimeMessage.setHeader("Date", mdf.format(mail.getSentDate()));
            }
        }
        Flags msgFlags = new Flags();
        if (mail.isAnswered()) {
            msgFlags.add(Flags.Flag.ANSWERED);
        }
        if (mail.isDeleted()) {
            msgFlags.add(Flags.Flag.DELETED);
        }
        if (mail.isDraft()) {
            msgFlags.add(Flags.Flag.DRAFT);
        }
        if (mail.isFlagged()) {
            msgFlags.add(Flags.Flag.FLAGGED);
        }
        if (mail.isRecent()) {
            msgFlags.add(Flags.Flag.RECENT);
        }
        if (mail.isSeen()) {
            msgFlags.add(Flags.Flag.SEEN);
        }
        if (mail.isUser()) {
            msgFlags.add(Flags.Flag.USER);
        }
        if (mail.isForwarded()) {
            msgFlags.add("$Forwarded");
        }
        if (mail.isReadAcknowledgment()) {
            msgFlags.add("$MDNSent");
        }
        if (mail.getColorLabel() != 0) {
            msgFlags.add(MailMessage.getColorLabelStringValue(mail.getColorLabel()));
        }
        if (null != (userFlags = mail.getUserFlags()) && userFlags.length > 0) {
            for (String userFlag : userFlags) {
                msgFlags.add(userFlag);
            }
        }
        mimeMessage.setFlags(msgFlags, true);
        if (mail.getDispositionNotification() != null) {
            if (mail.isDraft()) {
                mimeMessage.setHeader("X-OX-Notification", mail.getDispositionNotification().toString());
            } else {
                mimeMessage.setHeader("Disposition-Notification-To", mail.getDispositionNotification().toString());
            }
        }
        int priority = mail.getPriority();
        mimeMessage.setHeader("X-Priority", String.valueOf(priority));
        if (3 == priority) {
            mimeMessage.setHeader("Importance", "Medium");
        } else if (priority > 3) {
            mimeMessage.setHeader("Importance", "Low");
        } else {
            mimeMessage.setHeader("Importance", "High");
        }
        Iterator<Map.Entry<String, String>> iter = mail.getNonMatchingHeaders(SUPPRESS_HEADERS);
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            String name = entry.getKey();
            if (!name.toLowerCase(Locale.ENGLISH).startsWith("x-")) continue;
            mimeMessage.addHeader(name, entry.getValue());
        }
    }

    private void setReplyTo(ComposedMailMessage mail, MimeMessage mimeMessage) throws OXException, MessagingException {
        String hdrReplyTo = mail.getFirstHeader("Reply-To");
        if (null != hdrReplyTo) {
            InternetAddress[] replyTo = null;
            try {
                replyTo = QuotedInternetAddress.parse(hdrReplyTo, true);
            }
            catch (AddressException e) {
                LOG.error((Object)"Specified Reply-To address cannot be parsed", (Throwable)e);
            }
            if (null != replyTo) {
                mimeMessage.setReplyTo((Address[])replyTo);
            } else if (mail.containsFrom()) {
                mimeMessage.setReplyTo((Address[])mail.getFrom());
            }
        } else if (MimeMessageFiller.isEmpty(this.usm.getReplyToAddr())) {
            String sReplyTo;
            InternetAddress[] replyTo = null;
            MailAccountStorageService mass = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class);
            if (null != mass && null != (sReplyTo = mass.getMailAccount(mail.getAccountId(), this.session.getUserId(), this.session.getContextId()).getReplyTo())) {
                try {
                    replyTo = QuotedInternetAddress.parse(sReplyTo, true);
                }
                catch (AddressException e) {
                    LOG.error((Object)"Default Reply-To address cannot be parsed", (Throwable)e);
                }
            }
            if (null != replyTo) {
                mimeMessage.setReplyTo(replyTo);
            } else if (mail.containsFrom()) {
                mimeMessage.setReplyTo((Address[])mail.getFrom());
            }
        } else {
            try {
                mimeMessage.setReplyTo((Address[])QuotedInternetAddress.parse(this.usm.getReplyToAddr(), true));
            }
            catch (AddressException e) {
                LOG.error((Object)"Default Reply-To address cannot be parsed", (Throwable)e);
                try {
                    mimeMessage.setHeader("Reply-To", MimeUtility.encodeWord((String)this.usm.getReplyToAddr(), (String)MailProperties.getInstance().getDefaultMimeCharset(), (String)"Q"));
                }
                catch (UnsupportedEncodingException e1) {
                    LOG.error((Object)e1.getMessage(), (Throwable)e1);
                }
            }
        }
    }

    public static void setReplyHeaders(MailMessage referencedMail, MimeMessage mimeMessage) throws MessagingException {
        if (null == referencedMail) {
            return;
        }
        String pMsgId = referencedMail.getFirstHeader("Message-ID");
        if (pMsgId != null) {
            mimeMessage.setHeader("In-Reply-To", pMsgId);
        }
        String pReferences = referencedMail.getFirstHeader("References");
        String pInReplyTo = referencedMail.getFirstHeader("In-Reply-To");
        StringAllocator refBuilder = new StringAllocator();
        if (pReferences != null) {
            refBuilder.append(pReferences);
        } else if (pInReplyTo != null) {
            refBuilder.append(pInReplyTo);
        }
        if (pMsgId != null) {
            if (refBuilder.length() > 0) {
                refBuilder.append(' ');
            }
            refBuilder.append(pMsgId);
        }
        if (refBuilder.length() > 0) {
            mimeMessage.setHeader("References", refBuilder.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSendHeaders(ComposedMailMessage mail, MimeMessage mimeMessage) throws OXException {
        try {
            MailDateFormat mdf;
            this.setReplyTo(mail, mimeMessage);
            Date sentDate = mimeMessage.getSentDate();
            MailDateFormat mailDateFormat = mdf = MimeMessageUtility.getMailDateFormat(this.session);
            synchronized (mailDateFormat) {
                mimeMessage.setHeader("Date", mdf.format(sentDate == null ? new Date() : sentDate));
            }
            if (null == mimeMessage.getSubject()) {
                mimeMessage.setSubject(StringHelper.valueOf(UserStorage.getStorageUser(this.session.getUserId(), this.ctx).getLocale()).getString("[No Subject]"));
            }
        }
        catch (AddressException e) {
            throw MimeMailException.handleMessagingException((MessagingException)((Object)e));
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    public void fillMailBody(ComposedMailMessage mail, MimeMessage mimeMessage, ComposeType type) throws MessagingException, OXException, IOException {
        boolean embeddedImages;
        boolean sendMultipartAlternative;
        if (ComposeType.NEW_SMS.equals((Object)type)) {
            ContentType contentType = mail.getContentType();
            contentType.setPrimaryType("text").setSubType("plain");
        }
        boolean hasNestedMessages = false;
        int size = mail.getEnclosedCount();
        boolean hasAttachments = size > 0;
        boolean isAttachmentForward = ComposeType.FORWARD.equals((Object)type) && (this.usm.isForwardAsAttachment() || size > 1 && MimeMessageFiller.hasOnlyReferencedMailAttachments(mail, size));
        MimeMultipart primaryMultipart = null;
        if (hasAttachments || mail.isAppendVCard() || isAttachmentForward) {
            primaryMultipart = new MimeMultipart();
        }
        if (mail.isDraft()) {
            sendMultipartAlternative = false;
            if (mail.getContentType().startsWith("multipart/alternative")) {
                mail.setContentType("text/html");
            }
        } else {
            sendMultipartAlternative = mail.getContentType().startsWith("multipart/alternative");
        }
        TextBodyMailPart textBodyPart = mail.getBodyPart();
        StringBuilder sb = new StringBuilder((String)textBodyPart.getContent());
        Map<String, SourcedImage> images = SourcedImageUtility.hasSourcedImages(sb);
        String content = sb.toString();
        if (sendMultipartAlternative || mail.getContentType().startsWith("text/htm")) {
            embeddedImages = !images.isEmpty() || MimeMessageUtility.hasEmbeddedImages(content) || MimeMessageUtility.hasReferencedLocalImages(content);
        } else {
            content = MimeMessageFiller.dropImages(content, false);
            embeddedImages = false;
        }
        String charset = MailProperties.getInstance().getDefaultMimeCharset();
        if (hasAttachments || sendMultipartAlternative || isAttachmentForward || mail.isAppendVCard() || embeddedImages) {
            block62: {
                MimeBodyPart bodyPart;
                if (sendMultipartAlternative) {
                    Multipart alternativeMultipart = this.createMultipartAlternative(mail, content, embeddedImages, images, textBodyPart, type);
                    if (primaryMultipart == null) {
                        primaryMultipart = alternativeMultipart;
                    } else {
                        bodyPart = new MimeBodyPart();
                        bodyPart.setContent(alternativeMultipart);
                        primaryMultipart.addBodyPart((BodyPart)bodyPart);
                    }
                } else if (embeddedImages && !mail.getContentType().startsWith("text/plain")) {
                    Multipart relatedMultipart = this.createMultipartRelated(mail, content, images, new String[1]);
                    if (primaryMultipart == null) {
                        primaryMultipart = relatedMultipart;
                    } else {
                        bodyPart = new MimeBodyPart();
                        bodyPart.setContent(relatedMultipart);
                        primaryMultipart.addBodyPart((BodyPart)bodyPart);
                    }
                } else {
                    if (primaryMultipart == null) {
                        primaryMultipart = new MimeMultipart();
                    }
                    if (mail.getContentType().startsWith("text/plain")) {
                        String plainText = textBodyPart.getPlainText();
                        if (null == plainText) {
                            primaryMultipart.addBodyPart(this.createTextBodyPart(MimeMessageFiller.toArray(content, content), charset, false, true, type), 0);
                        } else {
                            primaryMultipart.addBodyPart(this.createTextBodyPart(MimeMessageFiller.toArray(plainText, plainText), charset, false, false, type), 0);
                        }
                    } else {
                        String wellFormedHTMLContent = this.htmlService.getConformHTML(content, charset);
                        primaryMultipart.addBodyPart(this.createHtmlBodyPart(wellFormedHTMLContent, charset));
                    }
                }
                int size2 = mail.getEnclosedCount();
                if (size2 > 0) {
                    if (isAttachmentForward) {
                        StringBuilder sb2 = new StringBuilder(32);
                        UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(8192);
                        byte[] bbuf = new byte[8192];
                        for (int i = 0; i < size2; ++i) {
                            MailPart enclosedMailPart = mail.getEnclosedMailPart(i);
                            if (enclosedMailPart.getContentType().startsWith("message/rfc822")) {
                                this.addNestedMessage(enclosedMailPart, (Multipart)primaryMultipart, sb2, (ByteArrayOutputStream)out, bbuf);
                                continue;
                            }
                            this.addMessageBodyPart((Multipart)primaryMultipart, enclosedMailPart, false);
                        }
                    } else {
                        List<String> cidList = null;
                        for (int i = 0; i < size2; ++i) {
                            String contentId;
                            boolean add;
                            MailPart mailPart;
                            if (null == this.contentIds) {
                                if (this.discardReferencedInlinedImages) {
                                    mailPart = mail.getEnclosedMailPart(i);
                                    add = false;
                                    if (embeddedImages && mailPart.getContentType().startsWith("image/")) {
                                        contentId = mailPart.getContentId();
                                        if (null != contentId) {
                                            if (null == cidList) {
                                                cidList = MimeMessageUtility.getContentIDs(content);
                                            }
                                            add = !MimeMessageUtility.containsContentId(contentId, cidList);
                                        } else {
                                            add = true;
                                        }
                                    } else {
                                        add = true;
                                    }
                                    if (!add) continue;
                                    this.addMessageBodyPart((Multipart)primaryMultipart, mailPart, false);
                                    continue;
                                }
                                this.addMessageBodyPart((Multipart)primaryMultipart, mail.getEnclosedMailPart(i), false);
                                continue;
                            }
                            mailPart = mail.getEnclosedMailPart(i);
                            add = true;
                            if (mailPart.getContentType().startsWith("image/") && null != (contentId = mailPart.getContentId())) {
                                boolean bl = add = !MimeMessageUtility.containsContentId(contentId, this.contentIds);
                            }
                            if (!add) continue;
                            this.addMessageBodyPart((Multipart)primaryMultipart, mailPart, false);
                        }
                    }
                }
                if (mail.isAppendVCard()) {
                    String fileName = MimeUtility.encodeText((String)new StringAllocator(UserStorage.getStorageUser(this.session.getUserId(), this.ctx).getDisplayName().replaceAll("\\s+", "")).append(".vcf").toString(), (String)charset, (String)"Q");
                    for (int i = 0; i < size2; ++i) {
                        MailPart part = mail.getEnclosedMailPart(i);
                        if (!fileName.equalsIgnoreCase(part.getFileName())) {
                            continue;
                        }
                        break block62;
                    }
                    if (primaryMultipart == null) {
                        primaryMultipart = new MimeMultipart();
                    }
                    try {
                        String userVCard = this.getUserVCard(charset);
                        MimeBodyPart vcardPart = new MimeBodyPart();
                        ContentType ct = new ContentType("text/vcard");
                        ct.setCharsetParameter(charset);
                        vcardPart.setDataHandler(new DataHandler((DataSource)new MessageDataSource(userVCard, ct)));
                        if (fileName != null && !ct.containsNameParameter()) {
                            ct.setNameParameter(fileName);
                        }
                        vcardPart.setHeader("Content-Type", MimeMessageUtility.foldContentType(ct.toString()));
                        vcardPart.setHeader("MIME-Version", VERSION_1_0);
                        if (fileName != null) {
                            ContentDisposition cd = new ContentDisposition("attachment");
                            cd.setFilenameParameter(fileName);
                            vcardPart.setHeader("Content-Disposition", MimeMessageUtility.foldContentDisposition(cd.toString()));
                        }
                        primaryMultipart.addBodyPart((BodyPart)vcardPart);
                        if (mail.isDraft()) {
                            mimeMessage.setHeader("X-OX-VCard-Attached", "true");
                        }
                    }
                    catch (OXException e) {
                        LOG.error((Object)VCARD_ERROR, (Throwable)e);
                    }
                }
            }
            if (primaryMultipart != null) {
                Object cto;
                if (1 == primaryMultipart.getCount() && (cto = primaryMultipart.getBodyPart(0).getContent()) instanceof Multipart) {
                    primaryMultipart = (Multipart)cto;
                }
                mimeMessage.setContent((Multipart)primaryMultipart);
            }
            return;
        }
        ContentType contentType = mail.getContentType();
        if (contentType.startsWith("text/")) {
            boolean isPlainText = contentType.startsWith("text/plain");
            if (contentType.getCharsetParameter() == null) {
                contentType.setCharsetParameter(charset);
            }
            if (primaryMultipart == null) {
                String mailText;
                if (isPlainText) {
                    String text;
                    boolean isHtml;
                    String plainText = textBodyPart.getPlainText();
                    if (null == plainText) {
                        if (HTMLDetector.containsHTMLTags((byte[])content.getBytes(Charsets.ISO_8859_1))) {
                            String wellFormedHTMLContent;
                            isHtml = true;
                            text = wellFormedHTMLContent = this.htmlService.getConformHTML(content, charset);
                        } else {
                            isHtml = false;
                            text = content;
                        }
                    } else {
                        isHtml = false;
                        text = plainText;
                    }
                    mailText = text == null || text.length() == 0 ? "" : (isHtml ? (ComposeType.NEW_SMS.equals((Object)type) ? content : TextProcessing.performLineFolding(this.htmlService.html2text(text, true), this.usm.getAutoLinebreak())) : (ComposeType.NEW_SMS.equals((Object)type) ? content : TextProcessing.performLineFolding(text, this.usm.getAutoLinebreak())));
                } else {
                    mailText = this.htmlService.getConformHTML(content, contentType.getCharsetParameter());
                }
                mimeMessage.setContent((Object)mailText, contentType.toString());
                mimeMessage.setHeader("MIME-Version", VERSION_1_0);
                mimeMessage.setHeader("Content-Type", MimeMessageUtility.foldContentType(contentType.toString()));
            } else {
                MimeBodyPart msgBodyPart = new MimeBodyPart();
                msgBodyPart.setContent(mail.getContent(), contentType.toString());
                msgBodyPart.setHeader("MIME-Version", VERSION_1_0);
                msgBodyPart.setHeader("Content-Type", MimeMessageUtility.foldContentType(contentType.toString()));
                primaryMultipart.addBodyPart((BodyPart)msgBodyPart);
            }
        } else {
            MimeMultipart mp = null;
            if (primaryMultipart == null) {
                primaryMultipart = mp = new MimeMultipart();
            } else {
                mp = primaryMultipart;
            }
            MimeBodyPart msgBodyPart = new MimeBodyPart();
            msgBodyPart.setText("", charset);
            String disposition = msgBodyPart.getHeader("Content-Disposition", null);
            if (disposition == null) {
                msgBodyPart.setHeader("Content-Disposition", "inline");
            } else {
                ContentDisposition contentDisposition = new ContentDisposition(disposition);
                contentDisposition.setDisposition("inline");
                msgBodyPart.setHeader("Content-Disposition", MimeMessageUtility.foldContentDisposition(contentDisposition.toString()));
            }
            mp.addBodyPart((BodyPart)msgBodyPart);
            this.addMessageBodyPart((Multipart)mp, mail, true);
        }
        if (primaryMultipart != null) {
            mimeMessage.setContent((Multipart)primaryMultipart);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String getUserVCard(String charset) throws OXException {
        ContactService contactService = ServerServiceRegistry.getInstance().getService(ContactService.class);
        Contact contact = contactService.getUser(this.session, this.session.getUserId());
        OXContainerConverter converter = new OXContainerConverter(this.session, this.ctx);
        try {
            VersitObject versitObj = converter.convertContact(contact, "3.0");
            UnsynchronizedByteArrayOutputStream os = new UnsynchronizedByteArrayOutputStream();
            VersitDefinition def = Versit.getDefinition("text/vcard");
            VersitDefinition.Writer w = def.getWriter((OutputStream)os, MailProperties.getInstance().getDefaultMimeCharset());
            def.write(w, versitObj);
            w.flush();
            os.flush();
            String string = new String(os.toByteArray(), Charsets.forName((String)charset));
            converter.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                converter.close();
                throw throwable;
            }
            catch (ConverterException e) {
                throw MailExceptionCode.VERSIT_ERROR.create(e, e.getMessage());
            }
            catch (IOException e) {
                if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                    throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
                }
                throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
            }
        }
    }

    protected final Multipart createMultipartAlternative(ComposedMailMessage mail, String mailBody, boolean embeddedImages, Map<String, SourcedImage> images, TextBodyMailPart textBodyPart) throws OXException, MessagingException {
        return this.createMultipartAlternative(mail, mailBody, embeddedImages, images, textBodyPart, null);
    }

    protected final Multipart createMultipartAlternative(ComposedMailMessage mail, String mailBody, boolean embeddedImages, Map<String, SourcedImage> images, TextBodyMailPart textBodyPart, ComposeType type) throws OXException, MessagingException {
        String htmlContent;
        MimeMultipart alternativeMultipart = new MimeMultipart(MP_ALTERNATIVE);
        String charset = MailProperties.getInstance().getDefaultMimeCharset();
        if (embeddedImages) {
            String[] arr = new String[1];
            Multipart relatedMultipart = this.createMultipartRelated(mail, mailBody, images, arr);
            htmlContent = arr[0];
            MimeBodyPart altBodyPart = new MimeBodyPart();
            altBodyPart.setContent(relatedMultipart);
            alternativeMultipart.addBodyPart((BodyPart)altBodyPart);
        } else {
            String wellFormedHTMLContent;
            htmlContent = wellFormedHTMLContent = this.htmlService.getConformHTML(mailBody, charset);
            BodyPart html = this.createHtmlBodyPart(wellFormedHTMLContent, charset);
            alternativeMultipart.addBodyPart(html);
        }
        String plainText = textBodyPart.getPlainText();
        if (null == plainText) {
            alternativeMultipart.addBodyPart(this.createTextBodyPart(MimeMessageFiller.toArray(htmlContent, mailBody), charset, true, true, type), 0);
        } else {
            alternativeMultipart.addBodyPart(this.createTextBodyPart(MimeMessageFiller.toArray(plainText, plainText), charset, true, false, type), 0);
        }
        return alternativeMultipart;
    }

    protected Multipart createMultipartRelated(ComposedMailMessage mail, String mailBody, Map<String, SourcedImage> images, String[] htmlContent) throws OXException, MessagingException {
        MimeMultipart relatedMultipart = new MimeMultipart(MP_RELATED);
        String charset = MailProperties.getInstance().getDefaultMimeCharset();
        String wellFormedHTMLContent = this.htmlService.getConformHTML(mailBody, charset);
        htmlContent[0] = MimeMessageFiller.processReferencedLocalImages(wellFormedHTMLContent, (Multipart)relatedMultipart, this);
        relatedMultipart.addBodyPart(this.createHtmlBodyPart(htmlContent[0], charset), 0);
        List<String> cidList = MimeMessageUtility.getContentIDs(wellFormedHTMLContent);
        StringBuilder tmp = new StringBuilder(32);
        for (String cid : cidList) {
            MimeBodyPart relatedImageBodyPart;
            SourcedImage image = images.get(cid);
            if (null == image) {
                MailPart imgPart = MimeMessageFiller.getAndRemoveImageAttachment(cid, mail);
                if (imgPart == null) continue;
                relatedImageBodyPart = new MimeBodyPart();
                relatedImageBodyPart.setDataHandler(imgPart.getDataHandler());
                Iterator<Map.Entry<String, String>> iter = imgPart.getHeadersIterator();
                while (iter.hasNext()) {
                    Map.Entry<String, String> e = iter.next();
                    relatedImageBodyPart.setHeader(e.getKey(), e.getValue());
                }
            } else {
                MessageDataSource dataSource;
                if ("base64".equalsIgnoreCase(image.getTransferEncoding())) {
                    dataSource = new MessageDataSource(Base64.decodeBase64((byte[])Charsets.toAsciiBytes((String)image.getData())), image.getContentType());
                } else {
                    try {
                        byte[] bs = QuotedPrintableCodec.decodeQuotedPrintable((byte[])image.getData().getBytes());
                        dataSource = new MessageDataSource(bs, image.getContentType());
                    }
                    catch (DecoderException e) {
                        LOG.warn((Object)("Couldn't decode " + image.getTransferEncoding() + " image data."), (Throwable)e);
                        continue;
                    }
                }
                MimeBodyPart imgBodyPart = new MimeBodyPart();
                imgBodyPart.setDataHandler(new DataHandler((DataSource)dataSource));
                tmp.setLength(0);
                imgBodyPart.setContentID(tmp.append('<').append(cid).append('>').toString());
                ContentDisposition contentDisposition = new ContentDisposition("inline");
                imgBodyPart.setHeader("Content-Disposition", MimeMessageUtility.foldContentDisposition(contentDisposition.toString()));
                ContentType ct = new ContentType(image.getContentType());
                imgBodyPart.setHeader("Content-Type", MimeMessageUtility.foldContentType(ct.toString()));
                relatedImageBodyPart = imgBodyPart;
            }
            relatedMultipart.addBodyPart((BodyPart)relatedImageBodyPart);
        }
        this.contentIds = new HashSet<String>(8);
        int count = relatedMultipart.getCount();
        for (int i = 0; i < count; ++i) {
            BodyPart bodyPart = relatedMultipart.getBodyPart(i);
            String[] header = bodyPart.getHeader("Content-Type");
            if (null == header || 0 >= header.length || !header[0].toLowerCase(Locale.US).startsWith("image/") || null == (header = bodyPart.getHeader("Content-ID")) || 0 >= header.length) continue;
            this.contentIds.add(header[0]);
        }
        return relatedMultipart;
    }

    protected final void addMessageBodyPart(Multipart mp, MailPart part, boolean inline) throws MessagingException, OXException, IOException {
        ContentDisposition cd;
        String disposition;
        if (part.getContentType().startsWith("message/rfc822")) {
            StringBuilder sb = new StringBuilder(32);
            UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(8192);
            byte[] bbuf = new byte[8192];
            this.addNestedMessage(part, mp, sb, (ByteArrayOutputStream)out, bbuf);
            return;
        }
        String fileName = part.getFileName();
        ContentType ct = part.getContentType();
        if (ct.startsWith("application/octet-stream") && fileName != null) {
            String ct2 = MimeType2ExtMap.getContentType(fileName);
            int pos = ct2.indexOf(47);
            ct.setPrimaryType(ct2.substring(0, pos));
            ct.setSubType(ct2.substring(pos + 1));
        }
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setDataHandler(part.getDataHandler());
        if (fileName != null && !ct.containsNameParameter()) {
            ct.setNameParameter(fileName);
        }
        messageBodyPart.setHeader("Content-Type", MimeMessageUtility.foldContentType(ct.toString()));
        if (!inline) {
            messageBodyPart.setHeader("Content-Transfer-Encoding", "base64");
        }
        if ((disposition = messageBodyPart.getHeader("Content-Disposition", null)) == null) {
            cd = new ContentDisposition(inline ? "inline" : "attachment");
        } else {
            cd = new ContentDisposition(disposition);
            cd.setDisposition(inline ? "inline" : "attachment");
        }
        if (fileName != null && !cd.containsFilenameParameter()) {
            cd.setFilenameParameter(fileName);
        }
        messageBodyPart.setHeader("Content-Disposition", MimeMessageUtility.foldContentDisposition(cd.toString()));
        if (part.getContentId() != null) {
            String cid = part.getContentId().charAt(0) == '<' ? part.getContentId() : new StringBuilder(part.getContentId().length() + 2).append('<').append(part.getContentId()).append('>').toString();
            messageBodyPart.setContentID(cid);
        }
        mp.addBodyPart((BodyPart)messageBodyPart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNestedMessage(MailPart mailPart, Multipart primaryMultipart, StringBuilder sb, ByteArrayOutputStream out, byte[] bbuf) throws OXException, IOException, MessagingException {
        String fn;
        InputStream in = mailPart.getInputStream();
        try {
            int len;
            while ((len = in.read(bbuf)) > 0) {
                out.write(bbuf, 0, len);
            }
        }
        finally {
            Streams.close((Closeable)in);
        }
        byte[] rfcBytes = out.toByteArray();
        out.reset();
        if (null == mailPart.getFileName()) {
            String subject = MimeMessageUtility.checkNonAscii(new InternetHeaders((InputStream)new UnsynchronizedByteArrayInputStream(rfcBytes)).getHeader("Subject", null));
            if (null == subject || subject.length() == 0) {
                fn = sb.append(PREFIX_PART).append(EXT_EML).toString();
            } else {
                subject = MimeMessageUtility.decodeMultiEncodedHeader(MimeMessageUtility.unfold(subject));
                fn = sb.append(subject.replaceAll("\\p{Blank}+", "_")).append(EXT_EML).toString();
                sb.setLength(0);
            }
        } else {
            fn = mailPart.getFileName();
        }
        this.addNestedMessage(primaryMultipart, new DataHandler((DataSource)new MessageDataSource(rfcBytes, "message/rfc822")), fn, "inline".equalsIgnoreCase(mailPart.getContentDisposition().getDisposition()));
    }

    private final void addNestedMessage(Multipart mp, DataHandler dataHandler, String filename, boolean inline) throws MessagingException, OXException {
        ContentDisposition cd;
        MimeBodyPart origMsgPart = new MimeBodyPart();
        origMsgPart.setDataHandler(dataHandler);
        ContentType ct = new ContentType("message/rfc822");
        if (null != filename) {
            ct.setNameParameter(filename);
        }
        origMsgPart.setHeader("Content-Type", MimeMessageUtility.foldContentType(ct.toString()));
        String disposition = origMsgPart.getHeader("Content-Disposition", null);
        if (disposition == null) {
            cd = new ContentDisposition(inline ? "inline" : "attachment");
        } else {
            cd = new ContentDisposition(disposition);
            cd.setDisposition(inline ? "inline" : "attachment");
        }
        if (null != filename && !cd.containsFilenameParameter()) {
            cd.setFilenameParameter(filename);
        }
        origMsgPart.setHeader("Content-Disposition", MimeMessageUtility.foldContentDisposition(cd.toString()));
        mp.addBodyPart((BodyPart)origMsgPart);
    }

    protected final BodyPart createTextBodyPart(String[] contents, String charset, boolean appendHref, boolean isHtml, ComposeType type) throws MessagingException {
        MimeBodyPart text = new MimeBodyPart();
        String content = contents[0];
        String textContent = content == null || content.length() == 0 ? "" : (isHtml ? (ComposeType.NEW_SMS.equals((Object)type) ? contents[1] : TextProcessing.performLineFolding(this.htmlService.html2text(content, appendHref), this.usm.getAutoLinebreak())) : (ComposeType.NEW_SMS.equals((Object)type) ? content : TextProcessing.performLineFolding(content, this.usm.getAutoLinebreak())));
        text.setText(textContent, charset);
        text.setHeader("MIME-Version", VERSION_1_0);
        text.setHeader("Content-Type", PAT_TEXT_CT.replaceFirst(REPLACE_CS, Strings.quoteReplacement((String)charset)));
        return text;
    }

    protected final BodyPart createHtmlBodyPart(String wellFormedHTMLContent, String charset) throws MessagingException {
        String contentType = PAT_HTML_CT.replaceFirst(REPLACE_CS, Strings.quoteReplacement((String)charset));
        MimeBodyPart html = new MimeBodyPart();
        if (wellFormedHTMLContent == null || wellFormedHTMLContent.length() == 0) {
            html.setContent((Object)this.htmlService.getConformHTML(HTML_SPACE, charset).replaceFirst(HTML_SPACE, ""), contentType);
        } else {
            html.setContent((Object)wellFormedHTMLContent, contentType);
        }
        html.setHeader("MIME-Version", VERSION_1_0);
        html.setHeader("Content-Type", contentType);
        return html;
    }

    protected static final String dropImages(String htmlContent, boolean considerAlt) {
        Matcher m = PATTERN_IMG.matcher(htmlContent);
        if (!m.find()) {
            return htmlContent;
        }
        MatcherReplacer mr = new MatcherReplacer(m, htmlContent);
        StringBuilder sb = new StringBuilder(htmlContent.length());
        if (considerAlt) {
            Matcher tmp = null;
            do {
                String alternative = (tmp = PATTERN_IMG_ALT.matcher(m.group())).find() ? tmp.group(1) : null;
                mr.appendLiteralReplacement(sb, null == alternative ? "" : " " + alternative + " ");
            } while (m.find());
        } else {
            do {
                mr.appendLiteralReplacement(sb, "");
            } while (m.find());
        }
        mr.appendTail(sb);
        return sb.toString();
    }

    private static String blankSrc(String imageTag) {
        if (MimeMessageFiller.isEmpty(imageTag)) {
            return imageTag;
        }
        Matcher srcMatcher = PATTERN_SRC.matcher(imageTag);
        if (!srcMatcher.find()) {
            return imageTag;
        }
        StringBuffer sb = new StringBuffer(imageTag.length());
        srcMatcher.appendReplacement(sb, "");
        srcMatcher.appendTail(sb);
        return sb.toString();
    }

    protected static final String processReferencedLocalImages(String htmlContent, Multipart mp, MimeMessageFiller msgFiller) throws MessagingException, OXException {
        if (MimeMessageFiller.isEmpty(htmlContent)) {
            return htmlContent;
        }
        ImageMatcher m = ImageMatcher.matcher(htmlContent);
        StringBuffer sb = new StringBuffer(htmlContent.length());
        if (m.find()) {
            msgFiller.uploadFileIDs = new HashSet<String>(4);
            HashSet<String> uploadFileIDs = msgFiller.uploadFileIDs;
            HashSet<String> trackedIds = new HashSet<String>(4);
            ManagedFileManagement mfm = ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class);
            ConversionService conversionService = ServerServiceRegistry.getInstance().getService(ConversionService.class);
            Session session = msgFiller.session;
            StringBuilder tmp = new StringBuilder(128);
            do {
                String imageTag;
                if (MimeMessageUtility.isValidImageUri(imageTag = m.group())) {
                    String iid;
                    ImageProvider imageProvider;
                    String id;
                    block23: {
                        ImageLocation imageLocation;
                        ImageLocation il;
                        id = m.getManagedFileId();
                        if (null != id && mfm.contains(id)) {
                            try {
                                imageProvider = new ManagedFileImageProvider(mfm.getByID(id));
                                break block23;
                            }
                            catch (OXException e) {
                                if (LOG.isWarnEnabled()) {
                                    tmp.setLength(0);
                                    LOG.warn((Object)tmp.append("Image with id \"").append(id).append("\" could not be loaded. Referenced image is skipped.").toString(), (Throwable)e);
                                }
                                tmp.setLength(0);
                                m.appendLiteralReplacement(sb, MimeMessageFiller.blankSrc(imageTag));
                                continue;
                            }
                        }
                        String blankImageTag = null;
                        Matcher srcMatcher = PATTERN_SRC.matcher(imageTag);
                        if (srcMatcher.find()) {
                            try {
                                il = ImageUtility.parseImageLocationFrom(PATTERN_AMP.matcher(srcMatcher.group(1)).replaceAll("&"));
                            }
                            catch (IllegalArgumentException e) {
                                StringBuffer bblankImageTag = new StringBuffer(imageTag.length());
                                srcMatcher.appendReplacement(bblankImageTag, "");
                                srcMatcher.appendTail(bblankImageTag);
                                blankImageTag = bblankImageTag.toString();
                                il = null;
                            }
                            imageLocation = il;
                        } else {
                            try {
                                il = ImageUtility.parseImageLocationFrom(imageTag);
                            }
                            catch (IllegalArgumentException e) {
                                il = null;
                            }
                            imageLocation = il;
                        }
                        if (null == imageLocation) {
                            if (LOG.isWarnEnabled()) {
                                tmp.setLength(0);
                                LOG.warn((Object)tmp.append("No image found with id \"").append(m.getImageId()).append("\". Referenced image is skipped.").toString());
                            }
                            tmp.setLength(0);
                            m.appendLiteralReplacement(sb, null == blankImageTag ? MimeMessageFiller.blankSrc(imageTag) : blankImageTag);
                            continue;
                        }
                        ImageDataSource dataSource = (ImageDataSource)conversionService.getDataSource(imageLocation.getRegistrationName());
                        if (null == dataSource) {
                            if (LOG.isWarnEnabled()) {
                                tmp.setLength(0);
                                LOG.warn((Object)tmp.append("No image data source found with id \"").append(imageLocation.getRegistrationName()).append("\". Referenced image is skipped.").toString());
                            }
                            tmp.setLength(0);
                            m.appendLiteralReplacement(sb, MimeMessageFiller.blankSrc(imageTag));
                            continue;
                        }
                        try {
                            imageProvider = new ImageDataImageProvider(dataSource, imageLocation, session);
                        }
                        catch (OXException e) {
                            if (MailExceptionCode.IMAGE_ATTACHMENT_NOT_FOUND.equals(e) || MailExceptionCode.MAIL_NOT_FOUND.equals(e)) {
                                tmp.setLength(0);
                                m.appendLiteralReplacement(sb, imageTag);
                                continue;
                            }
                            throw e;
                        }
                    }
                    if (null == id) {
                        iid = MimeMessageFiller.urlDecode(m.getImageId());
                    } else {
                        uploadFileIDs.add(id);
                        iid = id;
                    }
                    boolean appendBodyPart = trackedIds.add(iid);
                    String iTag = imageTag.replaceFirst("(?i)src=\"[^\"]*\"", Strings.quoteReplacement((String)("src=\"cid:" + MimeMessageFiller.processLocalImage(imageProvider, iid, appendBodyPart, tmp, mp) + "\"")));
                    iTag = iTag.replaceFirst("(?i)id=\"[^\"]*@Open-Xchange\"", "");
                    m.appendLiteralReplacement(sb, iTag);
                    continue;
                }
                m.appendLiteralReplacement(sb, imageTag);
            } while (m.find());
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static String urlDecode(String s) {
        try {
            return AJAXServlet.decodeUrl(MimeMessageFiller.replaceURLCodePoints(s), "ISO-8859-1");
        }
        catch (RuntimeException e) {
            return s;
        }
    }

    private static String replaceURLCodePoints(String s) {
        Matcher m = PATTERN_CODE_POINT.matcher(s);
        StringBuffer buffer = new StringBuffer(s.length());
        while (m.find()) {
            char[] chars = Character.toChars(Integer.parseInt(m.group(1), 16));
            m.appendReplacement(buffer, Strings.quoteReplacement((String)new String(chars)));
        }
        m.appendTail(buffer);
        return buffer.toString();
    }

    private static final String processLocalImage(ImageProvider imageProvider, String id, boolean appendBodyPart, StringBuilder tmp, Multipart mp) throws MessagingException, OXException {
        String fileName = imageProvider.getFileName();
        if (null == fileName) {
            List<String> exts = MimeType2ExtMap.getFileExtensions(imageProvider.getContentType().toLowerCase(Locale.ENGLISH));
            StringAllocator sb = new StringAllocator("image.");
            if (exts == null) {
                sb.append("dat");
            } else {
                sb.append(exts.get(0));
            }
            fileName = sb.toString();
        } else {
            try {
                fileName = MimeUtility.encodeText((String)fileName, (String)MailProperties.getInstance().getDefaultMimeCharset(), (String)"Q");
            }
            catch (UnsupportedEncodingException e) {
                fileName = imageProvider.getFileName();
            }
        }
        tmp.setLength(0);
        int atPos = id.indexOf(64);
        tmp.append(PATTERN_DASHES.matcher(atPos < 0 ? id : id.substring(0, atPos)).replaceAll(""));
        tmp.append('@').append(VERSION_NAME);
        String cid = tmp.toString();
        if (appendBodyPart) {
            boolean found = false;
            HashSet<String> set = new HashSet<String>(2);
            int count = mp.getCount();
            for (int i = 0; !found && i < count; ++i) {
                BodyPart bodyPart = mp.getBodyPart(i);
                String[] header = bodyPart.getHeader("Content-ID");
                if (null == header || 0 >= header.length) continue;
                set.clear();
                set.addAll(Arrays.asList(header));
                found = set.contains(cid);
            }
            if (!found) {
                MimeBodyPart imgBodyPart = new MimeBodyPart();
                imgBodyPart.setDataHandler(new DataHandler(imageProvider.getDataSource()));
                tmp.setLength(0);
                imgBodyPart.setContentID(tmp.append('<').append(cid).append('>').toString());
                ContentDisposition contentDisposition = new ContentDisposition("inline");
                if (fileName != null) {
                    contentDisposition.setFilenameParameter(fileName);
                }
                imgBodyPart.setHeader("Content-Disposition", MimeMessageUtility.foldContentDisposition(contentDisposition.toString()));
                ContentType ct = new ContentType(imageProvider.getContentType());
                if (fileName != null && !ct.containsNameParameter()) {
                    ct.setNameParameter(fileName);
                }
                imgBodyPart.setHeader("Content-Type", MimeMessageUtility.foldContentType(ct.toString()));
                mp.addBodyPart((BodyPart)imgBodyPart);
            }
        }
        return cid;
    }

    protected static final MailPart getAndRemoveImageAttachment(String cid, ComposedMailMessage mail) throws OXException {
        int size = mail.getEnclosedCount();
        for (int i = 0; i < size; ++i) {
            MailPart enclosedPart = mail.getEnclosedMailPart(i);
            if (!enclosedPart.containsContentId() || !MimeMessageUtility.equalsCID(cid, enclosedPart.getContentId())) continue;
            return mail.removeEnclosedPart(i);
        }
        return null;
    }

    private static final boolean hasOnlyReferencedMailAttachments(ComposedMailMessage mail, int size) throws OXException {
        for (int i = 0; i < size; ++i) {
            MailPart part = mail.getEnclosedMailPart(i);
            if (ComposedMailPart.ComposedPartType.REFERENCE.equals((Object)((ComposedMailPart)((Object)part)).getType()) && ((ReferencedMailPart)part).isMail()) continue;
            return false;
        }
        return true;
    }

    private static String[] toArray(String ... contents) {
        if (null == contents) {
            return new String[0];
        }
        int length = contents.length;
        if (0 == length) {
            return new String[0];
        }
        String[] ret = new String[length];
        System.arraycopy(contents, 0, ret, 0, length);
        return ret;
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Character.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }

    private static class ImageDataImageProvider
    implements ImageProvider {
        private final Data<InputStream> data;
        private final String contentType;
        private final String fileName;

        public ImageDataImageProvider(ImageDataSource imageData, ImageLocation imageLocation, Session session) throws OXException {
            this.data = imageData.getData(InputStream.class, imageData.generateDataArgumentsFrom(imageLocation), session);
            DataProperties dataProperties = this.data.getDataProperties();
            this.contentType = dataProperties.get("com.openexchange.conversion.content-type");
            this.fileName = dataProperties.get("com.openexchange.conversion.name");
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public DataSource getDataSource() throws OXException {
            try {
                return new MessageDataSource((InputStream)this.data.getData(), this.contentType);
            }
            catch (IOException e) {
                if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                    throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
                }
                throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
            }
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }
    }

    private static class ManagedFileImageProvider
    implements ImageProvider {
        private final ManagedFile managedFile;

        public ManagedFileImageProvider(ManagedFile managedFile) {
            this.managedFile = managedFile;
        }

        @Override
        public String getContentType() {
            return this.managedFile.getContentType();
        }

        @Override
        public DataSource getDataSource() throws OXException {
            return new FileDataSource(this.managedFile.getFile());
        }

        @Override
        public String getFileName() {
            return this.managedFile.getFileName();
        }
    }

    private static interface ImageProvider {
        public String getFileName();

        public DataSource getDataSource() throws OXException;

        public String getContentType();
    }
}

