/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import com.openexchange.exception.OXException;
import com.openexchange.java.CharsetDetector;
import com.openexchange.java.Charsets;
import com.openexchange.java.StringAllocator;
import com.openexchange.java.UnsynchronizedByteArrayInputStream;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.mime.HeaderName;
import com.openexchange.mail.mime.MessageHeaders;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Pattern;
import javax.mail.internet.MimeUtility;
import org.apache.commons.logging.Log;

public class HeaderCollection
implements Serializable {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(HeaderCollection.class));
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private static final String ERR_HEADER_NAME_IS_INVALID = "Header name is invalid";
    private static final long serialVersionUID = 6939560514144351286L;
    public static final HeaderCollection EMPTY_COLLECTION = new HeaderCollection(0).getReadOnlyCollection();
    private static final String CRLF = "\r\n";
    private static final int DEFAULT_CAPACITY = 4096;
    private static final HeaderName RETURN_PATH = MessageHeaders.RETURN_PATH;
    private static final HeaderName RECEIVED = MessageHeaders.RECEIVED;
    private static final HeaderName CONTENT_TYPE = MessageHeaders.CONTENT_TYPE;
    private static final Locale ENGLISH = Locale.ENGLISH;
    private static final Map<String, String> CASE_SENSITIVE_LOOKUP;
    private final Map<HeaderName, List<String>> map;
    private int count;
    private static final Pattern SPLIT;
    private static final transient Iterator<Map.Entry<String, String>> EMPTY_ITER;

    public static String caseSensitiveHeadreNameFor(String name) {
        String cshn = CASE_SENSITIVE_LOOKUP.get(name.toLowerCase(ENGLISH));
        return null == cshn ? name : cshn;
    }

    public HeaderCollection() {
        this(40);
    }

    public HeaderCollection(int initialCapacity) {
        this.map = new HashMap<HeaderName, List<String>>(initialCapacity);
    }

    public HeaderCollection(HeaderCollection headers) {
        this.map = new LinkedHashMap<HeaderName, List<String>>(headers.map.size());
        this.addHeaders(headers);
    }

    public HeaderCollection(String headerSrc) {
        this.map = new LinkedHashMap<HeaderName, List<String>>(40);
        this.load(headerSrc);
    }

    public HeaderCollection(InputStream inputStream) throws OXException {
        this.map = new LinkedHashMap<HeaderName, List<String>>(40);
        this.load(inputStream);
    }

    public HeaderCollection getReadOnlyCollection() {
        return new ReadOnlyHeaderCollection(this);
    }

    public void load(InputStream inputStream) throws OXException {
        UnsynchronizedByteArrayOutputStream buffer = new UnsynchronizedByteArrayOutputStream(4096);
        try {
            int i = -1;
            block2: while ((i = inputStream.read()) != -1) {
                int count = 0;
                while (13 == i || 10 == i) {
                    buffer.write(i);
                    if ((10 != i || ++count < 2) && -1 != (i = inputStream.read())) continue;
                    break block2;
                }
                buffer.write(i);
            }
            this.load(new String(buffer.toByteArray(), Charsets.ISO_8859_1));
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    public void load(String headerSrc) {
        String line;
        int length;
        if (null == headerSrc || 0 == headerSrc.length()) {
            return;
        }
        String[] lines = SPLIT.split(headerSrc, 0);
        StringBuilder lineBuffer = new StringBuilder(76);
        boolean emptyBuffer = true;
        String prevline = null;
        for (int i = 0; i < lines.length && (length = (line = lines[i]).length()) > 0; ++i) {
            if (length > 0 && HeaderCollection.isSpaceOrTab(line.charAt(0))) {
                if (prevline != null) {
                    lineBuffer.append(prevline);
                    prevline = null;
                }
                lineBuffer.append(CRLF);
                lineBuffer.append(line);
                emptyBuffer = false;
                continue;
            }
            if (prevline != null) {
                this.addHeaderLine(prevline);
            } else if (!emptyBuffer) {
                this.addHeaderLine(lineBuffer.toString());
                lineBuffer.setLength(0);
                emptyBuffer = true;
            }
            prevline = line;
        }
        if (prevline != null) {
            this.addHeaderLine(prevline);
        } else if (!emptyBuffer) {
            this.addHeaderLine(lineBuffer.toString());
        }
    }

    private static boolean isSpaceOrTab(char c) {
        return c == ' ' || c == '\t';
    }

    private final void addHeaderLine(String headerLine) {
        int pos = headerLine.indexOf(58);
        if (pos == -1) {
            throw new IllegalStateException("Invalid header line: " + headerLine);
        }
        String headerName = headerLine.substring(0, pos);
        int mlen = headerLine.length() - 1;
        if (pos < mlen && headerLine.charAt(pos + 1) == ' ') {
            ++pos;
        }
        this.addHeader(headerName, pos < mlen ? headerLine.substring(pos + 1) : "");
    }

    public void clear() {
        this.map.clear();
        this.count = 0;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.count;
    }

    public void addHeaders(HeaderCollection headers) {
        int size = headers.map.size();
        Iterator<Map.Entry<HeaderName, List<String>>> iter = headers.map.entrySet().iterator();
        for (int i = 0; i < size; ++i) {
            Map.Entry<HeaderName, List<String>> entry = iter.next();
            List<String> values = this.map.get(entry.getKey());
            if (values == null) {
                values = new ArrayList<String>(entry.getValue().size());
                this.map.put(entry.getKey(), values);
            }
            values.addAll((Collection<String>)entry.getValue());
            this.count += entry.getValue().size();
        }
    }

    public HeaderCollection addHeader(String name, String value) {
        this.putHeader(name, value, false);
        return this;
    }

    public HeaderCollection setHeader(String name, String value) {
        this.putHeader(name, value, true);
        return this;
    }

    private final void putHeader(String name, String value, boolean clear) {
        if (HeaderCollection.isInvalid(name, true)) {
            if (DEBUG) {
                IllegalArgumentException tmp = new IllegalArgumentException(new StringAllocator(ERR_HEADER_NAME_IS_INVALID).append(": ").append(name).toString());
                LOG.debug((Object)tmp.getMessage(), (Throwable)tmp);
            }
            return;
        }
        if (HeaderCollection.isInvalid(value, false)) {
            return;
        }
        HeaderName headerName = HeaderName.valueOf(HeaderCollection.caseSensitiveHeadreNameFor(name));
        List<String> values = this.map.get(headerName);
        if (values == null) {
            values = new ArrayList<String>(2);
            this.map.put(headerName, values);
        } else if (clear) {
            values.clear();
        }
        if (RECEIVED.equals(headerName) || RETURN_PATH.equals(headerName) || CONTENT_TYPE.equals(headerName)) {
            values.add(HeaderCollection.checkValue(value));
        } else {
            values.add(0, HeaderCollection.checkValue(value));
        }
        ++this.count;
    }

    public boolean containsHeader(String name) {
        if (HeaderCollection.isInvalid(name, true)) {
            throw new IllegalArgumentException(new StringAllocator(ERR_HEADER_NAME_IS_INVALID).append(": ").append(name).toString());
        }
        return this.map.containsKey(HeaderName.valueOf(name));
    }

    public String[] getHeader(String name) {
        if (HeaderCollection.isInvalid(name, true)) {
            throw new IllegalArgumentException(new StringAllocator(ERR_HEADER_NAME_IS_INVALID).append(": ").append(name).toString());
        }
        List<String> values = this.map.get(HeaderName.valueOf(name));
        if (values == null) {
            return null;
        }
        return values.toArray(new String[values.size()]);
    }

    public String getHeader(String name, String delimiter) {
        int size;
        if (HeaderCollection.isInvalid(name, true)) {
            throw new IllegalArgumentException(new StringAllocator(ERR_HEADER_NAME_IS_INVALID).append(": ").append(name).toString());
        }
        List<String> values = this.map.get(HeaderName.valueOf(name));
        if (values == null) {
            return null;
        }
        if (delimiter == null || (size = values.size()) == 1) {
            return values.get(0);
        }
        StringAllocator sb = new StringAllocator(values.get(0));
        for (int i = 1; i < size; ++i) {
            sb.append(delimiter).append(values.get(i));
        }
        return sb.toString();
    }

    public String getHeader(String name, char delimiter) {
        int size;
        if (HeaderCollection.isInvalid(name, true)) {
            throw new IllegalArgumentException(new StringAllocator(ERR_HEADER_NAME_IS_INVALID).append(": ").append(name).toString());
        }
        List<String> values = this.map.get(HeaderName.valueOf(name));
        if (values == null) {
            return null;
        }
        if (delimiter == '\u0000' || (size = values.size()) == 1) {
            return values.get(0);
        }
        StringAllocator sb = new StringAllocator(values.get(0));
        for (int i = 1; i < size; ++i) {
            sb.append(delimiter).append(values.get(i));
        }
        return sb.toString();
    }

    public HeaderCollection removeHeader(String name) {
        if (HeaderCollection.isInvalid(name, true)) {
            throw new IllegalArgumentException(new StringAllocator(ERR_HEADER_NAME_IS_INVALID).append(": ").append(name).toString());
        }
        List<String> removed = this.map.remove(HeaderName.valueOf(name));
        if (removed != null) {
            this.count -= removed.size();
        }
        return this;
    }

    public Iterator<String> getHeaderNames() {
        ArrayList<String> tmp = new ArrayList<String>(this.map.size());
        for (HeaderName headerName : this.map.keySet()) {
            tmp.add(headerName.toString());
        }
        return tmp.iterator();
    }

    public Iterator<Map.Entry<String, String>> getAllHeaders() {
        if (this.map.isEmpty()) {
            return EMPTY_ITER;
        }
        return new HeaderIterator(this.map.entrySet().iterator());
    }

    public Iterator<Map.Entry<String, String>> getMatchingHeaders(String[] matchingHeaders) {
        HashSet<HeaderName> set = new HashSet<HeaderName>(matchingHeaders.length);
        for (int i = 0; i < matchingHeaders.length; ++i) {
            set.add(HeaderName.valueOf(matchingHeaders[i]));
        }
        return new HeaderIterator(this.map.entrySet().iterator(), set, true);
    }

    public Iterator<Map.Entry<String, String>> getNonMatchingHeaders(String[] nonMatchingHeaders) {
        HashSet<HeaderName> set = new HashSet<HeaderName>(nonMatchingHeaders.length);
        for (int i = 0; i < nonMatchingHeaders.length; ++i) {
            set.add(HeaderName.valueOf(nonMatchingHeaders[i]));
        }
        return new HeaderIterator(this.map.entrySet().iterator(), set, false);
    }

    public String toString() {
        StringAllocator sb = new StringAllocator(4096);
        Iterator<Map.Entry<String, String>> iter = this.getAllHeaders();
        while (iter.hasNext()) {
            Map.Entry<String, String> e = iter.next();
            sb.append(e.getKey()).append(": ").append(e.getValue()).append(CRLF);
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HeaderCollection other = (HeaderCollection)obj;
        if (this.count != other.count) {
            return false;
        }
        if (this.map == null) {
            return other.map == null;
        }
        if (this.map.size() != other.map.size()) {
            return false;
        }
        Object[] names = this.map.keySet().toArray(new HeaderName[this.map.size()]);
        Arrays.sort(names);
        Object[] otherNames = other.map.keySet().toArray(new HeaderName[other.map.size()]);
        Arrays.sort(otherNames);
        if (!Arrays.equals(names, otherNames)) {
            return false;
        }
        for (int i = 0; i < names.length; ++i) {
            List<String> list = this.map.get(names[i]);
            List<String> otherList = other.map.get(names[i]);
            if (!(list == null ? otherList != null : !((Object)list).equals(otherList))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        Object[] names = this.map.keySet().toArray(new HeaderName[this.map.size()]);
        Arrays.sort(names);
        result = 31 * result + Arrays.hashCode(names);
        for (int i = 0; i < names.length; ++i) {
            List<String> list = this.map.get(names[i]);
            result = 31 * result + (list == null ? 0 : ((Object)list).hashCode());
        }
        return result;
    }

    private static final boolean isInvalid(String str, boolean isName) {
        if (str == null) {
            return true;
        }
        if (isName) {
            int length = str.length();
            if (length == 0) {
                return true;
            }
            for (int i = 0; i < length; ++i) {
                char c = str.charAt(i);
                if (!Character.isWhitespace(c) && c < '\u0080') continue;
                return true;
            }
            return false;
        }
        return HeaderCollection.isEmpty(str);
    }

    private static final boolean isAscii(String s) {
        int length = s.length();
        boolean isAscci = true;
        for (int i = 0; i < length && isAscci; isAscci &= s.charAt(i) < '\u0080', ++i) {
        }
        return isAscci;
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Character.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }

    private static String checkValue(String value) {
        if (HeaderCollection.isAscii(value)) {
            return value;
        }
        int length = value.length();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)value.charAt(i);
        }
        try {
            String detectCharset = CharsetDetector.detectCharset((ByteArrayInputStream)new UnsynchronizedByteArrayInputStream(bytes));
            String unicodeVal = MessageUtility.readStream((InputStream)new UnsynchronizedByteArrayInputStream(bytes), detectCharset);
            return MimeUtility.encodeWord((String)unicodeVal, (String)"UTF-8", (String)"Q");
        }
        catch (IOException e) {
            return value;
        }
    }

    public static final void test() {
        Log log2 = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(HeaderCollection.class));
        try {
            HeaderCollection hc = new HeaderCollection();
            hc.addHeader("From", "Jane Doe <jane.doe@somewhere.org>");
            hc.addHeader("To", "Jane Doe2 <jane.doe2@somewhere.org>, Jane Doe3 <jane.doe3@somewhere.org>");
            hc.addHeader("Received", "first from [212.227.126.201] (helo=mxintern.foobar.de) by mx.barfoo.de (node=mxeu24) with ESMTP (Nemesis), id 0MKtd6-1ICv9b3jPS-0001BJ for user2@host.de; Mon, 23 Jul 2007 12:28:42 +0200");
            hc.addHeader("Received", "second from [172.23.1.244] (helo=titan.foobar.de) by mxintern.barfoo.de with esmtp (Exim 4.50) id 1ICv9b-0004A2-Jn for user2@host.de; Mon, 23 Jul 2007 12:28:39 +0200");
            hc.addHeader("Subject", "The simple subject");
            hc.addHeader("Aaa", "dummy header here");
            Iterator<Map.Entry<String, String>> iter = hc.getAllHeaders();
            while (iter.hasNext()) {
                Map.Entry<String, String> e = iter.next();
                log2.info((Object)(e.getKey() + ": " + e.getValue()));
                if (!"Faust".equals(e.getKey())) continue;
                iter.remove();
            }
            log2.info((Object)"\n\nAfter removal through iterator");
            Iterator<Map.Entry<String, String>> iter2 = hc.getAllHeaders();
            while (iter2.hasNext()) {
                Map.Entry<String, String> e = iter2.next();
                log2.info((Object)(e.getKey() + ": " + e.getValue()));
            }
            log2.info((Object)"\n\nNon-Matching");
            Iterator<Map.Entry<String, String>> iter3 = hc.getNonMatchingHeaders(new String[]{"To", "From"});
            while (iter3.hasNext()) {
                Map.Entry<String, String> e = iter3.next();
                log2.info((Object)(e.getKey() + ": " + e.getValue()));
            }
            log2.info((Object)"\n\nMatching");
            Iterator<Map.Entry<String, String>> iter4 = hc.getMatchingHeaders(new String[]{"To", "From"});
            while (iter4.hasNext()) {
                Map.Entry<String, String> e = iter4.next();
                log2.info((Object)(e.getKey() + ": " + e.getValue()));
            }
            log2.info((Object)"\n\nEquals");
            HeaderCollection hc2 = new HeaderCollection();
            hc2.addHeader("From", "Jane Doe <jane.doe@somewhere.org>");
            hc2.addHeader("To", "Jane Doe2 <jane.doe2@somewhere.org>, Jane Doe3 <jane.doe3@somewhere.org>");
            hc2.addHeader("Received", "first from [212.227.126.201] (helo=mxintern.foobar.de) by mx.barfoo.de (node=mxeu24) with ESMTP (Nemesis), id 0MKtd6-1ICv9b3jPS-0001BJ for user2@host.de; Mon, 23 Jul 2007 12:28:42 +0200");
            hc2.addHeader("Received", "second from [172.23.1.244] (helo=titan.foobar.de) by mxintern.barfoo.de with esmtp (Exim 4.50) id 1ICv9b-0004A2-Jn for user2@host.de; Mon, 23 Jul 2007 12:28:39 +0200");
            hc2.addHeader("Subject", "The simple subject");
            hc2.addHeader("Aaa", "dummy header here");
            log2.info((Object)hc.equals(hc2));
        }
        catch (Exception e) {
            log2.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>(24);
        Locale l = ENGLISH;
        map.put("Date".toLowerCase(l), "Date");
        map.put("From".toLowerCase(l), "From");
        map.put("Sender".toLowerCase(l), "Sender");
        map.put("Reply-To".toLowerCase(l), "Reply-To");
        map.put("To".toLowerCase(l), "To");
        map.put("Cc".toLowerCase(l), "Cc");
        map.put("Bcc".toLowerCase(l), "Bcc");
        map.put("Message-ID".toLowerCase(l), "Message-ID");
        map.put("In-Reply-To".toLowerCase(l), "In-Reply-To");
        map.put("References".toLowerCase(l), "References");
        map.put("Subject".toLowerCase(l), "Subject");
        map.put("Comments".toLowerCase(l), "Comments");
        map.put("Keywords".toLowerCase(l), "Keywords");
        map.put("Resent-Date".toLowerCase(l), "Resent-Date");
        map.put("Resent-From".toLowerCase(l), "Resent-From");
        map.put("Resent-Sender".toLowerCase(l), "Resent-Sender");
        map.put("Resent-To".toLowerCase(l), "Resent-To");
        map.put("Resent-Cc".toLowerCase(l), "Resent-Cc");
        map.put("Resent-Bcc".toLowerCase(l), "Resent-Bcc");
        map.put("Resent-Message-ID".toLowerCase(l), "Resent-Message-ID");
        CASE_SENSITIVE_LOOKUP = Collections.unmodifiableMap(map);
        SPLIT = Pattern.compile("\r?\n");
        EMPTY_ITER = new Iterator<Map.Entry<String, String>>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Map.Entry<String, String> next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
            }
        };
    }

    private static final class ReadOnlyHeaderCollection
    extends HeaderCollection {
        private static final long serialVersionUID = 3272885948579962027L;

        public ReadOnlyHeaderCollection(HeaderCollection headers) {
            super(headers);
        }

        @Override
        public HeaderCollection addHeader(String name, String value) {
            throw new UnsupportedOperationException("ReadOnlyHeaderCollection.addHeader() is not supported");
        }

        @Override
        public HeaderCollection setHeader(String name, String value) {
            throw new UnsupportedOperationException("ReadOnlyHeaderCollection.setHeader() is not supported");
        }

        @Override
        public void load(String headersSrc) {
            throw new UnsupportedOperationException("ReadOnlyHeaderCollection.load() is not supported");
        }

        @Override
        public void load(InputStream inputStream) {
            throw new UnsupportedOperationException("ReadOnlyHeaderCollection.load() is not supported");
        }

        @Override
        public HeaderCollection removeHeader(String name) {
            throw new UnsupportedOperationException("ReadOnlyHeaderCollection.removeHeader() is not supported");
        }
    }

    private static final class HeaderEntry
    implements Map.Entry<String, String> {
        private final Map.Entry<HeaderName, List<String>> entry;
        private final int index;

        public HeaderEntry(Map.Entry<HeaderName, List<String>> entry, int index) {
            this.entry = entry;
            this.index = index;
        }

        @Override
        public String getKey() {
            return this.entry.getKey().toString();
        }

        @Override
        public String getValue() {
            return this.entry.getValue().get(this.index);
        }

        @Override
        public String setValue(String value) {
            return this.entry.getValue().set(this.index, value);
        }
    }

    private static final class HeaderIterator
    implements Iterator<Map.Entry<String, String>> {
        private final Iterator<Map.Entry<HeaderName, List<String>>> iter;
        private final Set<HeaderName> headers;
        private final boolean matches;
        private int size;
        private int index;
        private Map.Entry<HeaderName, List<String>> entry;

        public HeaderIterator(Iterator<Map.Entry<HeaderName, List<String>>> iter) {
            this.iter = iter;
            this.matches = false;
            this.headers = null;
        }

        public HeaderIterator(Iterator<Map.Entry<HeaderName, List<String>>> iter, Set<HeaderName> headers, boolean matches) {
            this.iter = iter;
            this.matches = matches;
            this.headers = headers;
        }

        @Override
        public boolean hasNext() {
            if (this.entry == null || this.index >= this.size) {
                while (this.iter.hasNext()) {
                    this.entry = this.iter.next();
                    if (this.headers != null && !(this.matches ? this.headers.contains(this.entry.getKey()) : !this.headers.contains(this.entry.getKey()))) continue;
                    this.size = this.entry.getValue().size();
                    this.index = 0;
                    return true;
                }
                this.entry = null;
                return false;
            }
            return this.index < this.size;
        }

        @Override
        public Map.Entry<String, String> next() {
            if (this.entry == null || this.index >= this.size) {
                while (this.iter.hasNext()) {
                    this.entry = this.iter.next();
                    if (this.headers != null && !(this.matches ? this.headers.contains(this.entry.getKey()) : !this.headers.contains(this.entry.getKey()))) continue;
                    this.size = this.entry.getValue().size();
                    this.index = 0;
                    return new HeaderEntry(this.entry, this.index++);
                }
                this.entry = null;
                throw new NoSuchElementException();
            }
            return new HeaderEntry(this.entry, this.index++);
        }

        @Override
        public void remove() {
            if (this.entry == null) {
                throw new IllegalStateException(new StringAllocator(64).append("next() method has not yet been called, or the remove()").append(" method has already been called after the last call to the next() method.").toString());
            }
            this.entry.getValue().remove(--this.index);
            if (this.entry.getValue().isEmpty()) {
                this.iter.remove();
                this.entry = null;
            }
        }
    }
}

