/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.container.ByteArrayFileHolder;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.ManagedFile;
import com.openexchange.java.Streams;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;

@Action(method=RequestMethod.GET, name="zip_messages", description="Get multiple mails as a ZIP file.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="folder", description="The folder identifier."), @Parameter(name="id", description="A comma-separated list of Object IDs of the requested mails.")}, responseDescription="The raw byte data of the ZIP file.")
public final class GetMultipleMessagesAction
extends AbstractMailAction {
    private static final Pattern SPLIT = Pattern.compile(" *, *");

    public GetMultipleMessagesAction(ServiceLookup services) {
        super(services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException, JSONException {
        AJAXRequestResult aJAXRequestResult;
        block16: {
            String[] ids;
            String folderPath = req.checkParameter("folder");
            String parameterId = "id";
            String sIds = req.getParameter("id");
            if (null == sIds) {
                JSONArray jArray = (JSONArray)req.getRequest().getData();
                int length = jArray.length();
                ids = new String[length];
                for (int i = 0; i < length; ++i) {
                    ids[i] = jArray.getJSONObject(i).getString("id");
                }
            } else {
                ids = SPLIT.split(sIds, 0);
            }
            MailServletInterface mailInterface = this.getMailInterface(req);
            ManagedFile mf = null;
            try {
                mf = mailInterface.getMessages(folderPath, ids);
                String fileName = "mails.zip";
                UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream();
                InputStream zipInputStream = mf.getInputStream();
                try {
                    int len;
                    byte[] buffer = new byte[65535];
                    while ((len = zipInputStream.read(buffer, 0, buffer.length)) > 0) {
                        out.write(buffer, 0, len);
                    }
                    out.flush();
                }
                finally {
                    Streams.close((Closeable)zipInputStream);
                }
                req.getRequest().setFormat("file");
                ByteArrayFileHolder fileHolder = new ByteArrayFileHolder(out.toByteArray());
                fileHolder.setName("mails.zip");
                fileHolder.setContentType("application/octet-stream");
                aJAXRequestResult = new AJAXRequestResult((Object)fileHolder, "file");
                if (null == mf) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (null != mf) {
                        mf.delete();
                        mf = null;
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                        throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
                    }
                    throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
                }
                catch (RuntimeException e) {
                    throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
                }
            }
            mf.delete();
            mf = null;
        }
        return aJAXRequestResult;
    }
}

