/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXActionServiceFactory;
import com.openexchange.ajax.requesthandler.AJAXState;
import com.openexchange.ajax.requesthandler.AJAXStateHandler;
import com.openexchange.documentation.annotations.Module;
import com.openexchange.exception.OXException;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.json.MailActionConstants;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.mail.json.actions.AllAction;
import com.openexchange.mail.json.actions.AutosaveAction;
import com.openexchange.mail.json.actions.ClearAction;
import com.openexchange.mail.json.actions.CopyAction;
import com.openexchange.mail.json.actions.DeleteAction;
import com.openexchange.mail.json.actions.EditAction;
import com.openexchange.mail.json.actions.ExpungeAction;
import com.openexchange.mail.json.actions.GetAction;
import com.openexchange.mail.json.actions.GetAttachmentAction;
import com.openexchange.mail.json.actions.GetForwardAction;
import com.openexchange.mail.json.actions.GetMailCountAction;
import com.openexchange.mail.json.actions.GetMultipleAttachmentAction;
import com.openexchange.mail.json.actions.GetMultipleMessagesAction;
import com.openexchange.mail.json.actions.GetReplyAction;
import com.openexchange.mail.json.actions.GetReplyAllAction;
import com.openexchange.mail.json.actions.GetStructureAction;
import com.openexchange.mail.json.actions.GetUpdatesAction;
import com.openexchange.mail.json.actions.GetVersitAction;
import com.openexchange.mail.json.actions.ImportAction;
import com.openexchange.mail.json.actions.ListAction;
import com.openexchange.mail.json.actions.NewAction;
import com.openexchange.mail.json.actions.ReceiptAckAction;
import com.openexchange.mail.json.actions.SearchAction;
import com.openexchange.mail.json.actions.SimpleThreadStructureAction;
import com.openexchange.mail.json.actions.TransportMailAction;
import com.openexchange.mail.json.actions.UpdateAction;
import com.openexchange.server.ServiceLookup;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Module(name="mail", description="Used to access mail data. When mails are stored on an IMAP server, some functionality is not available due to restrictions of the IMAP protocol. Such functionality is marked with \"not IMAP\".")
public class MailActionFactory
implements AJAXActionServiceFactory,
AJAXStateHandler,
MailActionConstants {
    private final Map<String, AbstractMailAction> actions = new ConcurrentHashMap<String, AbstractMailAction>(32);

    public MailActionFactory(ServiceLookup services) {
        this.actions.put("all", new AllAction(services));
        this.actions.put("threadedAll", new SimpleThreadStructureAction(services));
        this.actions.put("get", new GetAction(services));
        this.actions.put("get_structure", new GetStructureAction(services));
        this.actions.put("count", new GetMailCountAction(services));
        this.actions.put("copy", new CopyAction(services));
        this.actions.put("reply", new GetReplyAction(services));
        this.actions.put("replyall", new GetReplyAllAction(services));
        this.actions.put("updates", new GetUpdatesAction(services));
        this.actions.put("forward", new GetForwardAction(services));
        this.actions.put("attachment", new GetAttachmentAction(services));
        this.actions.put("zip_attachments", new GetMultipleAttachmentAction(services));
        this.actions.put("zip_messages", new GetMultipleMessagesAction(services));
        this.actions.put("saveVersit", new GetVersitAction(services));
        this.actions.put("list", new ListAction(services));
        this.actions.put("search", new SearchAction(services));
        this.actions.put("update", new UpdateAction(services));
        this.actions.put("delete", new DeleteAction(services));
        this.actions.put("transport", new TransportMailAction(services));
        this.actions.put("receipt_ack", new ReceiptAckAction(services));
        this.actions.put("clear", new ClearAction(services));
        this.actions.put("expunge", new ExpungeAction(services));
        this.actions.put("new", new NewAction(services));
        this.actions.put("import", new ImportAction(services));
        this.actions.put("edit", new EditAction(services));
        this.actions.put("autosave", new AutosaveAction(services));
    }

    public Collection<? extends AJAXActionService> getSupportedServices() {
        return Collections.unmodifiableCollection(this.actions.values());
    }

    @Override
    public AJAXActionService createActionService(String action) throws OXException {
        return this.actions.get(action);
    }

    @Override
    public void initialize(AJAXState state) throws OXException {
    }

    @Override
    public void cleanUp(AJAXState state) throws OXException {
        MailServletInterface mailInterface = (MailServletInterface)state.removeProperty("com.openexchange.mail.json.mailInterface");
        if (null != mailInterface) {
            mailInterface.close(true);
        }
    }
}

