/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.event;

import com.openexchange.concurrent.Blocker;
import com.openexchange.concurrent.ConcurrentBlocker;
import com.openexchange.exception.OXException;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.event.PooledEvent;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.timer.ScheduledTimerTask;
import com.openexchange.timer.TimerService;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public final class EventPool
implements Runnable {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(EventPool.class));
    static final long MSEC_DELAY = 10000L;
    private static final long MIN_TASK_DELAY = 5000L;
    private static final boolean DEBUG_ENABLED = LOG.isDebugEnabled();
    private static volatile EventPool instance;
    private final Blocker blocker;
    private volatile ScheduledTimerTask timerTask;
    private final ConcurrentMap<PooledEvent, PooledEvent> map = new ConcurrentHashMap<PooledEvent, PooledEvent>(1024);
    private final DelayQueue<PooledEvent> queue = new DelayQueue();
    private final EventAdmin eventAdmin;

    public static synchronized void initInstance() {
        if (null == instance) {
            try {
                instance = new EventPool();
                instance.startup();
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static synchronized void releaseInstance() {
        if (null != instance) {
            instance.shutdown();
            instance = null;
        }
    }

    public static EventPool getInstance() {
        return instance;
    }

    private EventPool() throws OXException {
        this.blocker = new ConcurrentBlocker();
        this.eventAdmin = ServerServiceRegistry.getInstance().getService(EventAdmin.class, true);
    }

    private void startup() {
        if (null == this.timerTask) {
            TimerService timer = ServerServiceRegistry.getInstance().getService(TimerService.class);
            if (null == timer) {
                this.timerTask = null;
            } else {
                long calDelay = 2000L;
                this.timerTask = timer.scheduleWithFixedDelay((Runnable)this, 1000L, 5000L);
            }
        }
    }

    private void shutdown() {
        if (null != this.timerTask) {
            this.timerTask.cancel(false);
            this.map.clear();
            this.queue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeByUser(int userId, int contextId) {
        this.blocker.acquire();
        try {
            Iterator<PooledEvent> queueIter = this.queue.iterator();
            while (queueIter.hasNext()) {
                PooledEvent pooledEvent = queueIter.next();
                if (!pooledEvent.equalsByUser(userId, contextId)) continue;
                this.map.remove(pooledEvent);
                queueIter.remove();
            }
        }
        finally {
            this.blocker.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(PooledEvent pooledEvent) {
        if (null == this.timerTask || 0L >= pooledEvent.getDelay(TimeUnit.MILLISECONDS)) {
            this.broadcastEvent(pooledEvent);
        } else {
            this.blocker.acquire();
            try {
                PooledEvent prev = this.map.putIfAbsent(pooledEvent, pooledEvent);
                if (null == prev) {
                    this.queue.offer(pooledEvent);
                } else {
                    prev.touch();
                }
            }
            finally {
                this.blocker.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.blocker.acquire();
        try {
            this.queue.clear();
            this.map.clear();
        }
        finally {
            this.blocker.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.blocker.block();
        try {
            PooledEvent pooledEvent = (PooledEvent)this.queue.poll();
            if (pooledEvent != null) {
                do {
                    this.map.remove(pooledEvent);
                    this.broadcastEvent(pooledEvent);
                } while ((pooledEvent = (PooledEvent)this.queue.poll()) != null);
            }
        }
        catch (Throwable t) {
            com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(EventPool.class)).error((Object)t.getMessage(), t);
        }
        finally {
            this.blocker.unblock();
        }
    }

    private void broadcastEvent(PooledEvent pooledEvent) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>(6);
        ((Dictionary)properties).put("com.openexchange.push.context", pooledEvent.getContextId());
        ((Dictionary)properties).put("com.openexchange.push.user", pooledEvent.getUserId());
        ((Dictionary)properties).put("com.openexchange.push.session", pooledEvent.getSession());
        ((Dictionary)properties).put("com.openexchange.push.folder", MailFolderUtility.prepareFullname(pooledEvent.getAccountId(), pooledEvent.getFullname()));
        ((Dictionary)properties).put("com.openexchange.push.content-related", pooledEvent.isContentRelated());
        String topic = pooledEvent.getTopic();
        Event event = new Event(null == topic ? "com/openexchange/push" : topic, properties);
        if (pooledEvent.isAsync()) {
            this.eventAdmin.postEvent(event);
        } else {
            this.eventAdmin.sendEvent(event);
        }
        if (DEBUG_ENABLED) {
            LOG.debug((Object)new StringAllocator(64).append("Notified ").append(pooledEvent.isContentRelated() ? "content-related" : "hierarchical").append("-wise changed folder \"").append(pooledEvent.getFullname()).append("\" in account ").append(pooledEvent.getAccountId()).append(" of user ").append(pooledEvent.getUserId()).append(" in context ").append(pooledEvent.getContextId()).toString());
        }
    }
}

