/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.i18n.tools;

import com.openexchange.i18n.tools.StringTemplate;
import com.openexchange.i18n.tools.Template;
import com.openexchange.java.Streams;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.Collections;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;

public abstract class TemplateListResourceBundle
extends ResourceBundle {
    private static File templatePath = new File("templates");
    protected static final Map<String, Template> templates = new HashMap<String, Template>();
    protected static final Properties properties = new Properties();
    protected static final List<String> keys = new ArrayList<String>();
    private static Lock INIT_LOCK = new ReentrantLock();
    protected static volatile boolean initialized;
    private static final Log LOG;

    public static final void setTemplatePath(File path) {
        templatePath = path;
    }

    @Override
    protected Object handleGetObject(String arg0) {
        if (!initialized) {
            this.init();
        }
        return templates.containsKey(arg0) ? templates.get(arg0) : properties.getProperty(arg0);
    }

    @Override
    public Enumeration<String> getKeys() {
        return Collections.iter2enum(keys.iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        INIT_LOCK.lock();
        try {
            if (initialized) {
                return;
            }
            initialized = true;
            InputStream is = null;
            try {
                File[] templateFiles;
                is = this.getPropertyStream();
                properties.load(is);
                is.close();
                is = null;
                for (File template : templateFiles = templatePath.listFiles(new StartsWithFilter(this.uniqueName()))) {
                    this.parseTemplate(template);
                }
            }
            catch (IOException e) {
                LOG.error((Object)e);
            }
            finally {
                Streams.close((Closeable)is);
            }
            for (Object object : properties.keySet()) {
                keys.add((String)object);
            }
            for (String string : templates.keySet()) {
                if (keys.contains(string)) continue;
                keys.add(string);
            }
        }
        finally {
            INIT_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseTemplate(File template) {
        BufferedReader r = null;
        try {
            r = new BufferedReader(new FileReader(template));
            String key = null;
            StringBuilder templateText = new StringBuilder();
            String line = null;
            while ((line = r.readLine()) != null) {
                if (key == null) {
                    key = line.trim();
                    continue;
                }
                templateText.append(line);
                templateText.append('\n');
            }
            templates.put(key, new StringTemplate(templateText.toString()));
        }
        catch (IOException x) {
            try {
                LOG.error((Object)x);
            }
            catch (Throwable throwable) {
                Streams.close(r);
                throw throwable;
            }
            Streams.close((Closeable)r);
        }
        Streams.close((Closeable)r);
    }

    protected InputStream getPropertyStream() throws IOException {
        return this.stream(this.uniqueName() + ".properties");
    }

    protected final InputStream stream(String fileName) throws IOException {
        return new BufferedInputStream(new FileInputStream(new File(templatePath, fileName)));
    }

    protected String uniqueName() {
        return this.getClass().getName();
    }

    static {
        LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(TemplateListResourceBundle.class));
    }

    private static final class StartsWithFilter
    implements FilenameFilter {
        private final String name;

        public StartsWithFilter(String name) {
            this.name = name;
        }

        @Override
        public boolean accept(File arg0, String arg1) {
            return arg1.startsWith(this.name);
        }
    }
}

