/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.userconfiguration;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.log.LogFactory;
import org.apache.commons.logging.Log;

public abstract class UserConfigurationStorage {
    private static final Log LOG = LogFactory.getLog(UserConfigurationStorage.class);
    private static volatile UserConfigurationStorage singleton;
    private boolean started;

    protected UserConfigurationStorage() {
    }

    static void setInstance(UserConfigurationStorage singleton) throws OXException {
        UserConfigurationStorage.singleton = singleton;
        singleton.start();
    }

    static void releaseInstance() throws OXException {
        singleton.stop();
        singleton = null;
    }

    public static final UserConfigurationStorage getInstance() {
        return singleton;
    }

    private final void start() throws OXException {
        if (this.started) {
            return;
        }
        this.startInternal();
        this.started = true;
    }

    private final void stop() throws OXException {
        if (!this.started) {
            return;
        }
        this.stopInternal();
        this.started = false;
    }

    public final UserConfiguration getUserConfigurationSafe(int userId, Context ctx) {
        return this.getUserConfigurationSafe(userId, null, ctx);
    }

    public final UserConfiguration getUserConfigurationSafe(int userId, int[] groups, Context ctx) {
        try {
            return UserConfigurationStorage.getInstance().getUserConfiguration(userId, groups, ctx);
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public final UserConfiguration getUserConfiguration(int userId, Context ctx) throws OXException {
        return this.getUserConfiguration(userId, null, ctx);
    }

    protected abstract void startInternal() throws OXException;

    protected abstract void stopInternal() throws OXException;

    public UserConfiguration getUserConfiguration(int userId, int[] groups, Context ctx) throws OXException {
        return this.getUserConfiguration(userId, groups, ctx, true);
    }

    public abstract UserConfiguration getUserConfiguration(int var1, int[] var2, Context var3, boolean var4) throws OXException;

    public abstract UserConfiguration[] getUserConfiguration(Context var1, User[] var2) throws OXException;

    public abstract void clearStorage() throws OXException;

    public abstract void removeUserConfiguration(int var1, Context var2) throws OXException;

    public final void saveUserConfiguration(UserConfiguration userConfiguration) throws OXException {
        this.saveUserConfiguration(userConfiguration.getPermissionBits(), userConfiguration.getUserId(), userConfiguration.getContext());
    }

    public abstract void saveUserConfiguration(int var1, int var2, Context var3) throws OXException;
}

