/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.userconfiguration;

import com.openexchange.cache.registry.CacheAvailabilityListener;
import com.openexchange.cache.registry.CacheAvailabilityRegistry;
import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheKey;
import com.openexchange.caching.CacheService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.RdbUserConfigurationStorage;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationCodes;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;

public class CachingUserConfigurationStorage
extends UserConfigurationStorage {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(CachingUserConfigurationStorage.class));
    private static final String CACHE_REGION_NAME = "UserConfiguration";
    private final CacheAvailabilityListener cacheAvailabilityListener;
    private final transient UserConfigurationStorage delegateStorage;
    private final Lock cacheWriteLock = new ReentrantLock();
    private volatile Cache cache;
    private volatile UserConfigurationStorage fallback;

    public CachingUserConfigurationStorage() throws OXException {
        this.delegateStorage = new RdbUserConfigurationStorage();
        this.cacheAvailabilityListener = new CacheAvailabilityListener(){

            @Override
            public void handleAbsence() throws OXException {
                CachingUserConfigurationStorage.this.releaseCache();
            }

            @Override
            public void handleAvailability() throws OXException {
                CachingUserConfigurationStorage.this.initCache();
            }
        };
        this.initCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserConfigurationStorage getFallback() {
        UserConfigurationStorage fallback = this.fallback;
        if (null == fallback) {
            CachingUserConfigurationStorage cachingUserConfigurationStorage = this;
            synchronized (cachingUserConfigurationStorage) {
                fallback = this.fallback;
                if (null == fallback) {
                    this.fallback = fallback = new RdbUserConfigurationStorage();
                }
            }
        }
        return fallback;
    }

    @Override
    protected void startInternal() throws OXException {
        CacheAvailabilityRegistry reg = CacheAvailabilityRegistry.getInstance();
        if (null != reg && !reg.registerListener(this.cacheAvailabilityListener)) {
            LOG.error((Object)"Cache availability listener could not be registered", new Throwable());
        }
    }

    @Override
    protected void stopInternal() throws OXException {
        CacheAvailabilityRegistry reg = CacheAvailabilityRegistry.getInstance();
        if (null != reg) {
            reg.unregisterListener(this.cacheAvailabilityListener);
        }
        this.releaseCache();
    }

    private final CacheKey getKey(int userId, Context ctx, Cache cache) {
        return cache.newCacheKey(ctx.getContextId(), userId);
    }

    void initCache() throws OXException {
        if (this.cache != null) {
            return;
        }
        try {
            this.cache = ServerServiceRegistry.getInstance().getService(CacheService.class).getCache(CACHE_REGION_NAME);
        }
        catch (RuntimeException e) {
            throw UserConfigurationCodes.CACHE_INITIALIZATION_FAILED.create(e, CACHE_REGION_NAME);
        }
    }

    void releaseCache() throws OXException {
        Cache cache = this.cache;
        if (cache == null) {
            return;
        }
        try {
            cache.clear();
            CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
            if (null != cacheService) {
                cacheService.freeCache(CACHE_REGION_NAME);
            }
        }
        catch (RuntimeException e) {
            throw UserConfigurationCodes.CACHE_INITIALIZATION_FAILED.create(e, CACHE_REGION_NAME);
        }
        finally {
            this.cache = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserConfiguration getUserConfiguration(int userId, int[] groups, Context ctx, boolean initExtendedPermissions) throws OXException {
        Cache cache = this.cache;
        if (cache == null) {
            return this.getFallback().getUserConfiguration(userId, groups, ctx, initExtendedPermissions);
        }
        CacheKey key = this.getKey(userId, ctx, cache);
        UserConfiguration userConfig = (UserConfiguration)cache.get((Serializable)key);
        if (null == userConfig) {
            this.cacheWriteLock.lock();
            try {
                userConfig = (UserConfiguration)cache.get((Serializable)key);
                if (null == userConfig) {
                    userConfig = this.delegateStorage.getUserConfiguration(userId, groups, ctx, initExtendedPermissions);
                    if (initExtendedPermissions) {
                        cache.put((Serializable)key, (Serializable)userConfig, false);
                    }
                }
            }
            catch (RuntimeException rte) {
                UserConfiguration userConfiguration = this.getFallback().getUserConfiguration(userId, groups, ctx, initExtendedPermissions);
                return userConfiguration;
            }
            finally {
                this.cacheWriteLock.unlock();
            }
        }
        return (UserConfiguration)userConfig.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserConfiguration[] getUserConfiguration(Context ctx, User[] users) throws OXException {
        UserConfiguration[] userConfigs;
        Cache cache = this.cache;
        if (cache == null) {
            return this.getFallback().getUserConfiguration(ctx, users);
        }
        ArrayList<User> toLoad = new ArrayList<User>(users.length);
        ArrayList<UserConfiguration> retval = new ArrayList<UserConfiguration>(users.length);
        for (User user : users) {
            UserConfiguration userConfig = (UserConfiguration)cache.get((Serializable)this.getKey(user.getId(), ctx, cache));
            if (null == userConfig) {
                toLoad.add(user);
                continue;
            }
            retval.add((UserConfiguration)userConfig.clone());
        }
        for (UserConfiguration userConfig : userConfigs = this.delegateStorage.getUserConfiguration(ctx, toLoad.toArray(new User[toLoad.size()]))) {
            this.cacheWriteLock.lock();
            try {
                cache.put((Serializable)this.getKey(userConfig.getUserId(), ctx, cache), (Serializable)userConfig, false);
            }
            catch (RuntimeException rte) {
                UserConfiguration[] userConfigurationArray = this.getFallback().getUserConfiguration(ctx, users);
                return userConfigurationArray;
            }
            finally {
                this.cacheWriteLock.unlock();
            }
            retval.add((UserConfiguration)userConfig.clone());
        }
        return retval.toArray(new UserConfiguration[retval.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearStorage() throws OXException {
        Cache cache = this.cache;
        if (cache == null) {
            return;
        }
        this.cacheWriteLock.lock();
        try {
            cache.clear();
        }
        catch (RuntimeException rte) {
            LOG.warn((Object)"A runtime error occurred.", (Throwable)rte);
        }
        finally {
            this.cacheWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUserConfiguration(int userId, Context ctx) throws OXException {
        Cache cache = this.cache;
        if (cache == null) {
            return;
        }
        this.cacheWriteLock.lock();
        try {
            cache.remove((Serializable)this.getKey(userId, ctx, cache));
        }
        catch (RuntimeException rte) {
            LOG.warn((Object)"A runtime error occurred.", (Throwable)rte);
        }
        finally {
            this.cacheWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveUserConfiguration(int permissionBits, int userId, Context ctx) throws OXException {
        this.delegateStorage.saveUserConfiguration(permissionBits, userId, ctx);
        Cache cache = this.cache;
        if (null != cache) {
            this.cacheWriteLock.lock();
            try {
                cache.remove((Serializable)this.getKey(userId, ctx, cache));
            }
            catch (RuntimeException rte) {
                LOG.warn((Object)"A runtime error occurred.", (Throwable)rte);
            }
            finally {
                this.cacheWriteLock.unlock();
            }
        }
    }
}

