/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.SortedSet;
import java.util.TreeSet;

public final class NewInfostoreFolderTreeUpdateTask
implements UpdateTask {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(NewInfostoreFolderTreeUpdateTask.class));
    private OCLPermission systemPermission;
    private static final String SQL_01 = "SELECT cid FROM oxfolder_tree WHERE fuid = 9 GROUP BY cid";
    private static final String SQL_UPDATE = "UPDATE oxfolder_permissions SET fp = ?, orp = ?, owp = ?, odp = ?, admin_flag = ? WHERE cid = ? AND fuid = 9 AND permission_id = 0";
    private static final String SQL_UPDATE2 = "UPDATE oxfolder_tree SET changing_date = ?, changed_from = ? WHERE cid = ? AND fuid = 9";
    private static final String SQL_02 = "SELECT fuid FROM oxfolder_tree WHERE cid = ? AND fuid = ?";
    private static final String SQL_SELECT_ADMIN = "SELECT user FROM user_setting_admin WHERE cid = ?";
    private static final String SQL_MOVE1 = "UPDATE oxfolder_tree SET parent = 10 WHERE cid = ? AND parent = 9 AND module = 8 AND default_flag = 1 AND fuid NOT IN (9, 10, 15)";
    private static final String SQL_MOVE2 = "UPDATE oxfolder_tree SET parent = 15 WHERE cid = ? AND parent = 9 AND module = 8 AND default_flag = 0 AND fuid NOT IN (9, 10, 15)";
    private static final String SQL_INSERT_SYSTEM_FOLDER = "INSERT INTO oxfolder_tree (fuid, cid, parent, fname, module, type, creating_date, created_from, changing_date, changed_from, permission_flag, subfolder_flag) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String SQL_INSERT_SYSTEM_PERMISSION = "INSERT INTO oxfolder_permissions (cid, fuid, permission_id, fp, orp, owp, odp, admin_flag, group_flag) VALUES (?,?,?,?,?,?,?,?,?)";
    private static final String SQL_INSERT_SPECIAL_FOLDER = "INSERT INTO oxfolder_specialfolders (tag, cid, fuid) VALUES (?,?,?)";

    private OCLPermission getSystemPermission() {
        if (this.systemPermission == null) {
            this.systemPermission = new OCLPermission();
            this.systemPermission.setEntity(0);
            this.systemPermission.setGroupPermission(true);
        }
        return this.systemPermission;
    }

    @Override
    public int addedWithVersion() {
        return 32;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.HIGHEST.priority;
    }

    @Override
    public void perform(Schema schema, int cid) throws OXException {
        TreeSet<Integer> contextIds = new TreeSet<Integer>();
        this.gatherContextIDs(cid, contextIds);
        long creatingTime = System.currentTimeMillis();
        for (Integer contextId : contextIds) {
            this.processContext(contextId, creatingTime);
        }
    }

    private void gatherContextIDs(int cid, SortedSet<Integer> contextIds) throws OXException {
        Connection writeCon = Database.getNoTimeout(cid, true);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = writeCon.prepareStatement(SQL_01);
            rs = stmt.executeQuery();
            while (rs.next()) {
                contextIds.add(rs.getInt(1));
            }
        }
        catch (SQLException e) {
            try {
                throw NewInfostoreFolderTreeUpdateTask.err(e);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                Database.backNoTimeout(cid, true, writeCon);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        Database.backNoTimeout(cid, true, writeCon);
    }

    private void processContext(int cid, long creatingTime) throws OXException {
        LOG.info((Object)("Performing 'NewInfostoreFolderTreeUpdateTask' on context " + cid));
        Connection writeCon = Database.getNoTimeout(cid, true);
        try {
            int admin = this.getContextAdmin(cid, writeCon);
            writeCon.setAutoCommit(false);
            if (!this.checkExists(10, cid, writeCon)) {
                this.createUserStoreFolder(cid, writeCon, creatingTime, admin);
            }
            this.move2UserStore(cid, writeCon);
            if (!this.checkExists(15, cid, writeCon)) {
                this.createPublicInfostoreFolder(cid, writeCon, creatingTime, admin);
            }
            this.move2PublicInfoStore(cid, writeCon);
            this.updateInfostorePermissions(cid, writeCon, creatingTime, admin);
            writeCon.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(writeCon);
            LOG.info((Object)("Roll-back done in update task 'NewInfostoreFolderTreeUpdateTask' for context " + cid));
            throw NewInfostoreFolderTreeUpdateTask.err(e);
        }
        catch (OXException e) {
            DBUtils.rollback(writeCon);
            LOG.info((Object)("Roll-back done in update task 'NewInfostoreFolderTreeUpdateTask' for context " + cid));
            throw e;
        }
        finally {
            DBUtils.autocommit(writeCon);
            Database.backNoTimeout(cid, true, writeCon);
        }
    }

    private void updateInfostorePermissions(int cid, Connection writeCon, long lastModified, int admin) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = writeCon.prepareStatement(SQL_UPDATE);
            int pos = 1;
            stmt.setInt(pos++, 2);
            stmt.setInt(pos++, 0);
            stmt.setInt(pos++, 0);
            stmt.setInt(pos++, 0);
            stmt.setInt(pos++, 0);
            stmt.setInt(pos++, cid);
            stmt.executeUpdate();
            stmt.close();
            stmt = writeCon.prepareStatement(SQL_UPDATE2);
            pos = 1;
            stmt.setLong(pos++, lastModified);
            stmt.setInt(pos++, admin);
            stmt.setInt(pos++, cid);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw NewInfostoreFolderTreeUpdateTask.err(e);
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
        }
    }

    private void createUserStoreFolder(int cid, Connection writeCon, long creatingTime, int admin) throws SQLException {
        OCLPermission systemPermission = this.getSystemPermission();
        systemPermission.setAllPermission(2, 0, 0, 0);
        systemPermission.setFolderAdmin(false);
        this.createSystemFolder(10, "userstore", systemPermission, 9, 8, true, creatingTime, admin, cid, writeCon);
    }

    private void createPublicInfostoreFolder(int cid, Connection writeCon, long creatingTime, int admin) throws SQLException {
        OCLPermission systemPermission = this.getSystemPermission();
        systemPermission.setAllPermission(8, 0, 0, 0);
        systemPermission.setFolderAdmin(false);
        this.createSystemFolder(15, "public_infostore", systemPermission, 9, 8, true, creatingTime, admin, cid, writeCon);
    }

    private boolean checkExists(int folderId, int cid, Connection con) throws OXException {
        PreparedStatement stmt;
        try {
            stmt = con.prepareStatement(SQL_02);
        }
        catch (SQLException e) {
            throw NewInfostoreFolderTreeUpdateTask.err(e);
        }
        try {
            stmt.setInt(1, cid);
            stmt.setInt(2, folderId);
            boolean e = stmt.executeQuery().next();
            return e;
        }
        catch (SQLException e) {
            throw NewInfostoreFolderTreeUpdateTask.err(e);
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
        }
    }

    private int getContextAdmin(int cid, Connection con) throws OXException {
        int n;
        ResultSet rs;
        PreparedStatement stmt;
        block5: {
            stmt = null;
            rs = null;
            stmt = con.prepareStatement(SQL_SELECT_ADMIN);
            stmt.setInt(1, cid);
            rs = stmt.executeQuery();
            if (rs.next()) break block5;
            int n2 = -1;
            DBUtils.closeSQLStuff(rs, stmt);
            return n2;
        }
        try {
            n = rs.getInt(1);
        }
        catch (SQLException e) {
            try {
                throw NewInfostoreFolderTreeUpdateTask.err(e);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return n;
    }

    private void move2UserStore(int cid, Connection writeCon) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = writeCon.prepareStatement(SQL_MOVE1);
            stmt.setInt(1, cid);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw NewInfostoreFolderTreeUpdateTask.err(e);
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
        }
    }

    private void move2PublicInfoStore(int cid, Connection writeCon) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = writeCon.prepareStatement(SQL_MOVE2);
            stmt.setInt(1, cid);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw NewInfostoreFolderTreeUpdateTask.err(e);
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSystemFolder(int systemFolderId, String systemFolderName, OCLPermission systemPermission, int parentId, int module, boolean insertIntoSpecialFolders, long creatingTime, int mailAdminId, int cid, Connection writeCon) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = writeCon.prepareStatement(SQL_INSERT_SYSTEM_FOLDER);
            stmt.setInt(1, systemFolderId);
            stmt.setInt(2, cid);
            stmt.setInt(3, parentId);
            stmt.setString(4, systemFolderName);
            stmt.setInt(5, module);
            stmt.setInt(6, 5);
            stmt.setLong(7, creatingTime);
            stmt.setInt(8, mailAdminId);
            stmt.setLong(9, creatingTime);
            stmt.setInt(10, mailAdminId);
            stmt.setInt(11, 2);
            stmt.setInt(12, 1);
            stmt.executeUpdate();
            stmt.close();
            stmt = writeCon.prepareStatement(SQL_INSERT_SYSTEM_PERMISSION);
            stmt.setInt(1, cid);
            stmt.setInt(2, systemFolderId);
            stmt.setInt(3, systemPermission.getEntity());
            stmt.setInt(4, systemPermission.getFolderPermission());
            stmt.setInt(5, systemPermission.getReadPermission());
            stmt.setInt(6, systemPermission.getWritePermission());
            stmt.setInt(7, systemPermission.getDeletePermission());
            stmt.setInt(8, systemPermission.isFolderAdmin() ? 1 : 0);
            stmt.setInt(9, systemPermission.isGroupPermission() ? 1 : 0);
            stmt.executeUpdate();
            stmt.close();
            stmt = null;
            if (insertIntoSpecialFolders) {
                stmt = writeCon.prepareStatement(SQL_INSERT_SPECIAL_FOLDER);
                stmt.setString(1, systemFolderName);
                stmt.setInt(2, cid);
                stmt.setInt(3, systemFolderId);
                stmt.executeUpdate();
                stmt.close();
                stmt = null;
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
                stmt = null;
            }
        }
    }

    private static OXException err(SQLException e) {
        return UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
    }
}

