/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact.helpers;

import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import java.util.LinkedList;
import java.util.List;

public class ContactMerger {
    private boolean overwrite = false;

    public ContactMerger(boolean overwrite) {
        this.setOverwrite(overwrite);
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public Contact merge(Contact c1, Contact c2) {
        Contact clone = c1.clone();
        for (ContactField field : ContactField.values()) {
            int number;
            if (field.isVirtual() || !c2.contains(number = field.getNumber()) || !this.overwrite && c1.contains(number)) continue;
            clone.set(number, c2.get(number));
        }
        return clone;
    }

    public List<Contact> merge(List<Contact> list1, List<Contact> list2) {
        if (list1.size() != list2.size()) {
            throw new IllegalArgumentException("Both lists to be merged must be same length, but are: " + list1.size() + "/" + list2.size());
        }
        LinkedList<Contact> merged = new LinkedList<Contact>();
        int length = list1.size();
        for (int i = 0; i < length; ++i) {
            merged.add(this.merge(list1.get(i), list2.get(i)));
        }
        return merged;
    }
}

