/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach.impl;

import com.openexchange.database.tx.AbstractDBAction;
import com.openexchange.groupware.attach.AttachmentField;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.attach.impl.AttachmentQueryCatalog;
import com.openexchange.groupware.attach.util.GetSwitch;
import com.openexchange.tx.UndoableAction;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;

public abstract class AbstractAttachmentAction
extends AbstractDBAction
implements UndoableAction {
    private AttachmentQueryCatalog queryCatalog = null;

    protected int fillFields(AttachmentMetadata attachment, PreparedStatement stmt) throws SQLException {
        GetSwitch get = new GetSwitch(attachment);
        int i = 1;
        for (AttachmentField field : this.queryCatalog.getFields()) {
            Object value = field.doSwitch(get);
            if (this.isDateField(field)) {
                value = ((Date)value).getTime();
            }
            if (field.equals(AttachmentField.RTF_FLAG_LITERAL)) {
                value = attachment.getRtfFlag() ? 1 : 0;
            }
            stmt.setObject(i++, value);
        }
        stmt.setInt(i++, this.getContext().getContextId());
        return i;
    }

    private final boolean isDateField(AttachmentField field) {
        return field.equals(AttachmentField.CREATION_DATE_LITERAL);
    }

    public void setQueryCatalog(AttachmentQueryCatalog queryCatalog) {
        this.queryCatalog = queryCatalog;
    }

    public AttachmentQueryCatalog getQueryCatalog() {
        return this.queryCatalog;
    }
}

