/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.group.internal;

import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserExceptionCode;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.i18n.LocaleTools;
import com.openexchange.i18n.tools.StringHelper;
import java.util.Date;

public final class GroupTools {
    static final Group GROUP_ZERO = new Group();

    private GroupTools() {
    }

    public static Group getGroupZero(Context ctx) throws OXException {
        Group retval;
        try {
            retval = (Group)GROUP_ZERO.clone();
        }
        catch (CloneNotSupportedException e) {
            throw UserExceptionCode.NOT_CLONEABLE.create(e, Group.class.getName());
        }
        UserStorage ustor = UserStorage.getInstance();
        retval.setMember(ustor.listAllUser(ctx));
        retval.setLastModified(new Date());
        User admin = ustor.getUser(ctx.getMailadmin(), ctx);
        StringHelper helper = StringHelper.valueOf(LocaleTools.getLocale((String)admin.getPreferredLanguage()));
        retval.setDisplayName(helper.getString("All users"));
        return retval;
    }

    static {
        GROUP_ZERO.setIdentifier(0);
    }
}

