/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.database.internal;

import com.openexchange.config.ConfigurationService;
import com.openexchange.database.ConfigDatabaseService;
import com.openexchange.database.DBPoolingExceptionCodes;
import com.openexchange.exception.OXException;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class Server {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(Server.class));
    private static final String PROPERTY_NAME = "SERVER_NAME";
    private static final String SELECT = "SELECT server_id FROM server WHERE name=?";
    private static volatile String serverName;
    private static volatile ConfigDatabaseService configDatabaseService;
    private static int serverId;

    private Server() {
    }

    static void setConfigDatabaseService(ConfigDatabaseService configDatabaseService) {
        Server.configDatabaseService = configDatabaseService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int getServerId() throws OXException {
        Class<Server> clazz = Server.class;
        synchronized (Server.class) {
            if (-1 == serverId) {
                serverId = Server.loadServerId(Server.getServerName());
                if (-1 == serverId) {
                    throw DBPoolingExceptionCodes.NOT_RESOLVED_SERVER.create(new Object[]{Server.getServerName()});
                }
                LOG.trace((Object)("Got server id: " + serverId));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return serverId;
        }
    }

    public static final void start(ConfigurationService service) throws OXException {
        String serverName = service.getProperty(PROPERTY_NAME);
        if (null == serverName || serverName.length() == 0) {
            throw DBPoolingExceptionCodes.NO_SERVER_NAME.create();
        }
        Server.serverName = serverName;
    }

    public static String getServerName() throws OXException {
        String serverName = Server.serverName;
        if (null == serverName) {
            throw DBPoolingExceptionCodes.NOT_INITIALIZED.create(new Object[]{Server.class.getName()});
        }
        return serverName;
    }

    private static int loadServerId(String name) throws OXException {
        ConfigDatabaseService configDatabaseService;
        ResultSet result;
        PreparedStatement stmt;
        Connection con;
        int retval;
        block6: {
            retval = -1;
            con = null;
            stmt = null;
            result = null;
            configDatabaseService = Server.configDatabaseService;
            try {
                con = configDatabaseService.getReadOnly();
                stmt = con.prepareStatement(SELECT);
                stmt.setString(1, name);
                result = stmt.executeQuery();
                if (!result.next()) break block6;
                retval = result.getInt(1);
            }
            catch (SQLException e) {
                try {
                    throw DBPoolingExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(result, stmt);
                    if (null != con) {
                        configDatabaseService.backReadOnly(con);
                    }
                    throw throwable;
                }
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        if (null != con) {
            configDatabaseService.backReadOnly(con);
        }
        return retval;
    }

    static {
        serverId = -1;
    }
}

