/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.contact.storage;

import com.openexchange.contact.ContactFieldOperand;
import com.openexchange.contact.SortOptions;
import com.openexchange.contact.storage.ContactStorage;
import com.openexchange.contact.storage.internal.SearchAdapter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactExceptionCodes;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.search.ContactSearchObject;
import com.openexchange.search.CompositeSearchTerm;
import com.openexchange.search.SearchTerm;
import com.openexchange.search.SingleSearchTerm;
import com.openexchange.search.internal.operands.ConstantOperand;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.FilteringSearchIterator;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorAdapter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.logging.Log;

public abstract class DefaultContactStorage
implements ContactStorage {
    protected static final Log LOG = com.openexchange.log.Log.loggerFor(DefaultContactStorage.class);

    @Override
    public SearchIterator<Contact> all(Session session, String folderId, ContactField[] fields) throws OXException {
        return this.all(session, folderId, fields, SortOptions.EMPTY);
    }

    @Override
    public SearchIterator<Contact> list(Session session, String folderId, String[] ids, ContactField[] fields) throws OXException {
        return this.list(session, folderId, ids, fields, SortOptions.EMPTY);
    }

    @Override
    public <O> SearchIterator<Contact> search(Session session, SearchTerm<O> term, ContactField[] fields) throws OXException {
        return this.search(session, term, fields, SortOptions.EMPTY);
    }

    @Override
    public SearchIterator<Contact> search(Session session, ContactSearchObject contactSearch, ContactField[] fields) throws OXException {
        return this.search(session, contactSearch, fields, SortOptions.EMPTY);
    }

    @Override
    public SearchIterator<Contact> deleted(Session session, String folderId, Date since, ContactField[] fields) throws OXException {
        return this.deleted(session, folderId, since, fields, SortOptions.EMPTY);
    }

    @Override
    public SearchIterator<Contact> modified(Session session, String folderId, Date since, ContactField[] fields) throws OXException {
        return this.modified(session, folderId, since, fields, SortOptions.EMPTY);
    }

    @Override
    public SearchIterator<Contact> search(Session session, ContactSearchObject contactSearch, ContactField[] fields, SortOptions sortOptions) throws OXException {
        return this.search(session, DefaultContactStorage.getSearchTerm(contactSearch), fields, sortOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Session session, String folderId) throws OXException {
        Date simulatedLastRead = new Date(Long.MAX_VALUE);
        SearchIterator<Contact> searchIterator = null;
        try {
            searchIterator = this.all(session, folderId, new ContactField[]{ContactField.OBJECT_ID});
            if (null != searchIterator) {
                while (searchIterator.hasNext()) {
                    this.delete(session, folderId, String.valueOf(((Contact)searchIterator.next()).getObjectID()), simulatedLastRead);
                }
            }
        }
        finally {
            DefaultContactStorage.close(searchIterator);
        }
    }

    @Override
    public void delete(Session session, String folderId, String[] ids, Date lastRead) throws OXException {
        for (String id : ids) {
            this.delete(session, folderId, id, lastRead);
        }
    }

    @Override
    public SearchIterator<Contact> searchByBirthday(Session session, List<String> folderIDs, Date from, Date until, ContactField[] fields, SortOptions sortOptions) throws OXException {
        SearchIterator<Contact> searchIterator = this.search(session, DefaultContactStorage.getAnnualDateTerm(folderIDs, ContactField.BIRTHDAY), DefaultContactStorage.addUniquely(fields, ContactField.BIRTHDAY), sortOptions);
        return DefaultContactStorage.filterByAnnualDate(searchIterator, from, until, ContactField.BIRTHDAY);
    }

    @Override
    public SearchIterator<Contact> searchByAnniversary(Session session, List<String> folderIDs, Date from, Date until, ContactField[] fields, SortOptions sortOptions) throws OXException {
        SearchIterator<Contact> searchIterator = this.search(session, DefaultContactStorage.getAnnualDateTerm(folderIDs, ContactField.ANNIVERSARY), DefaultContactStorage.addUniquely(fields, ContactField.ANNIVERSARY), sortOptions);
        return DefaultContactStorage.filterByAnnualDate(searchIterator, from, until, ContactField.ANNIVERSARY);
    }

    private static SearchTerm<?> getAnnualDateTerm(List<String> folderIDs, ContactField dateField) {
        CompositeSearchTerm hasDateTerm = new CompositeSearchTerm(CompositeSearchTerm.CompositeOperation.NOT);
        SingleSearchTerm isNullTerm = new SingleSearchTerm(SingleSearchTerm.SingleOperation.ISNULL);
        isNullTerm.addOperand(new ContactFieldOperand(dateField));
        hasDateTerm.addSearchTerm(isNullTerm);
        if (null != folderIDs && 0 < folderIDs.size()) {
            CompositeSearchTerm andTerm = new CompositeSearchTerm(CompositeSearchTerm.CompositeOperation.AND);
            if (1 == folderIDs.size()) {
                SingleSearchTerm folderIDTerm = new SingleSearchTerm(SingleSearchTerm.SingleOperation.EQUALS);
                folderIDTerm.addOperand(new ContactFieldOperand(ContactField.FOLDER_ID));
                folderIDTerm.addOperand(new ConstantOperand<String>(folderIDs.get(0)));
                andTerm.addSearchTerm(folderIDTerm);
            } else {
                CompositeSearchTerm folderIDsTerm = new CompositeSearchTerm(CompositeSearchTerm.CompositeOperation.OR);
                for (String parentFolderID : folderIDs) {
                    SingleSearchTerm folderIDTerm = new SingleSearchTerm(SingleSearchTerm.SingleOperation.EQUALS);
                    folderIDTerm.addOperand(new ContactFieldOperand(ContactField.FOLDER_ID));
                    folderIDTerm.addOperand(new ConstantOperand<String>(parentFolderID));
                    folderIDsTerm.addSearchTerm(folderIDTerm);
                }
                andTerm.addSearchTerm(folderIDsTerm);
            }
            andTerm.addSearchTerm(hasDateTerm);
            return andTerm;
        }
        return hasDateTerm;
    }

    private static SearchIterator<Contact> filterByAnnualDate(SearchIterator<Contact> searchIterator, final Date from, final Date until, final ContactField dateField) throws OXException {
        if (from.after(until)) {
            throw new IllegalArgumentException("from must not be after until");
        }
        final Calendar calendar2 = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar2.setTime(from);
        final int fromYear = calendar2.get(1);
        calendar2.setTime(until);
        final int untilYear = calendar2.get(1);
        return new FilteringSearchIterator<Contact>(searchIterator){

            public boolean accept(Contact thing) throws OXException {
                Date date;
                Date date2 = ContactField.ANNIVERSARY.equals((Object)dateField) ? thing.getAnniversary() : (date = ContactField.BIRTHDAY.equals((Object)dateField) ? thing.getBirthday() : null);
                if (null != date) {
                    calendar2.setTime(date);
                    for (int y = fromYear; y <= untilYear; ++y) {
                        calendar2.set(1, y);
                        if (!calendar2.getTime().before(until) || calendar2.getTime().before(from)) continue;
                        return true;
                    }
                }
                return false;
            }
        };
    }

    protected static ContactField[] addUniquely(ContactField[] fields, ContactField ... fieldsToAdd) {
        if (null == fields || 0 == fields.length) {
            return fieldsToAdd;
        }
        if (null == fieldsToAdd || 0 == fieldsToAdd.length) {
            return fields;
        }
        HashSet<ContactField> contactFields = new HashSet<ContactField>(fields.length + fieldsToAdd.length);
        contactFields.addAll(Arrays.asList(fields));
        contactFields.addAll(Arrays.asList(fieldsToAdd));
        return contactFields.toArray(new ContactField[contactFields.size()]);
    }

    protected static ContactField[] allFields() {
        return ContactField.values();
    }

    protected static <T> void close(SearchIterator<T> searchIterator) {
        if (null != searchIterator) {
            try {
                searchIterator.close();
            }
            catch (OXException e) {
                LOG.warn((Object)"error closing search iterator", (Throwable)e);
            }
        }
    }

    protected static SearchIterator<Contact> getSearchIterator(Collection<Contact> contacts2) {
        if (null == contacts2) {
            List emptyList = Collections.emptyList();
            return new SearchIteratorAdapter(emptyList.iterator(), 0);
        }
        return new SearchIteratorAdapter(contacts2.iterator(), contacts2.size());
    }

    protected static int parse(String id) throws OXException {
        try {
            return Integer.parseInt(id);
        }
        catch (NumberFormatException e) {
            throw ContactExceptionCodes.ID_PARSING_FAILED.create(e, id);
        }
    }

    protected static int[] parse(String[] ids) throws OXException {
        if (null == ids) {
            return new int[0];
        }
        try {
            int[] intIDs = new int[ids.length];
            for (int i = 0; i < intIDs.length; ++i) {
                intIDs[i] = Integer.parseInt(ids[i]);
            }
            return intIDs;
        }
        catch (NumberFormatException e) {
            throw ContactExceptionCodes.ID_PARSING_FAILED.create(e, Arrays.toString(ids));
        }
    }

    protected static SearchTerm<?> getSearchTerm(ContactSearchObject contactSearch) throws OXException {
        return new SearchAdapter(contactSearch).getSearchTerm();
    }
}

