/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.contact.internal;

import com.openexchange.groupware.contact.helpers.ContactField;
import java.util.EnumSet;

public class QueryFields {
    private static final EnumSet<ContactField> PERMISSION_FIELDS = EnumSet.of(ContactField.CREATED_BY, ContactField.PRIVATE_FLAG, ContactField.FOLDER_ID, ContactField.OBJECT_ID, ContactField.CONTEXTID);
    private boolean needsAttachmentInfo;
    private final ContactField[] queriedFields;

    public QueryFields() {
        this(null);
    }

    public QueryFields(ContactField[] fields) {
        this(fields, null);
    }

    public QueryFields(ContactField[] fields, ContactField[] allowedFields) {
        if (null == fields) {
            if (null == allowedFields) {
                this.queriedFields = ContactField.values();
                this.needsAttachmentInfo = true;
            } else {
                this.needsAttachmentInfo = false;
                EnumSet<ContactField> preparedFields = EnumSet.copyOf(PERMISSION_FIELDS);
                for (ContactField allowedField : allowedFields) {
                    preparedFields.add(allowedField);
                    if (!ContactField.LAST_MODIFIED_OF_NEWEST_ATTACHMENT.equals((Object)allowedField)) continue;
                    this.needsAttachmentInfo = true;
                    preparedFields.add(ContactField.NUMBER_OF_ATTACHMENTS);
                }
                this.queriedFields = preparedFields.toArray(new ContactField[preparedFields.size()]);
            }
        } else {
            this.needsAttachmentInfo = false;
            EnumSet<ContactField> preparedFields = EnumSet.copyOf(PERMISSION_FIELDS);
            if (null == allowedFields) {
                for (ContactField field : fields) {
                    preparedFields.add(field);
                    if (!ContactField.LAST_MODIFIED_OF_NEWEST_ATTACHMENT.equals((Object)field)) continue;
                    this.needsAttachmentInfo = true;
                    preparedFields.add(ContactField.NUMBER_OF_ATTACHMENTS);
                }
            } else {
                for (ContactField field : fields) {
                    if (!QueryFields.contains(allowedFields, field)) continue;
                    preparedFields.add(field);
                    if (!ContactField.LAST_MODIFIED_OF_NEWEST_ATTACHMENT.equals((Object)field)) continue;
                    this.needsAttachmentInfo = true;
                    preparedFields.add(ContactField.NUMBER_OF_ATTACHMENTS);
                }
            }
            this.queriedFields = preparedFields.toArray(new ContactField[preparedFields.size()]);
        }
    }

    private static boolean contains(ContactField[] fields, ContactField field) {
        for (ContactField presentField : fields) {
            if (!presentField.equals((Object)field)) continue;
            return true;
        }
        return false;
    }

    public boolean needsAttachmentInfo() {
        return this.needsAttachmentInfo;
    }

    public ContactField[] getFields() {
        return this.queriedFields;
    }
}

