/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.PermissionServlet;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.helper.DownloadUtility;
import com.openexchange.ajax.parser.InfostoreParser;
import com.openexchange.ajax.request.InfostoreRequest;
import com.openexchange.ajax.request.ServletRequestAdapter;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreFacade;
import com.openexchange.groupware.infostore.InfostoreSearchEngine;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import com.openexchange.groupware.infostore.facade.impl.InfostoreFacadeImpl;
import com.openexchange.groupware.infostore.facade.impl.VirtualFolderInfostoreFacade;
import com.openexchange.groupware.infostore.search.impl.SearchEngineImpl;
import com.openexchange.groupware.infostore.utils.GetSwitch;
import com.openexchange.groupware.infostore.utils.InfostoreConfigUtils;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.groupware.infostore.utils.SetSwitch;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.upload.UploadFile;
import com.openexchange.groupware.upload.impl.UploadEvent;
import com.openexchange.groupware.upload.impl.UploadException;
import com.openexchange.groupware.upload.impl.UploadSizeExceededException;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.java.AllocatingStringWriter;
import com.openexchange.java.Streams;
import com.openexchange.java.StringAllocator;
import com.openexchange.json.OXJSONWriter;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.ThreadLocalSessionHolder;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.UploadServletException;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Infostore
extends PermissionServlet {
    private static final String STR_JSON = "json";
    private static final String STR_ERROR = "error";
    private static final String STR_ACTION = "action";
    private static final String MIME_TEXT_HTML = "text/html";
    private static final long serialVersionUID = 2674990072903834660L;
    private static final InfostoreParser PARSER = new InfostoreParser();
    public static final InfostoreFacade VIRTUAL_FACADE = new VirtualFolderInfostoreFacade();
    public static final InfostoreFacade FACADE = new InfostoreFacadeImpl(new DBPoolProvider());
    public static final InfostoreSearchEngine SEARCH_ENGINE;
    private static final Log LOG;
    private final long maxUploadSize = -1L;
    private static final Set<Long> VIRTUAL_FOLDERS;

    @Override
    protected boolean hasModulePermission(ServerSession session) {
        return InfostoreRequest.hasPermission(session.getUserConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ServerSession session = Infostore.getSessionObject((ServletRequest)req);
        ThreadLocalSessionHolder.getInstance().setSession(session);
        Context ctx = session.getContext();
        User user = session.getUser();
        UserConfiguration userConfig = session.getUserConfiguration();
        String action = req.getParameter(STR_ACTION);
        if (action == null) {
            this.missingParameter(STR_ACTION, res, false, null);
            return;
        }
        if (action.equals("document")) {
            int id;
            if (req.getParameter("id") == null) {
                Response resp = new Response(session);
                resp.setException(AjaxExceptionCodes.UNEXPECTED_ERROR.create("You must provide a value for id"));
                AllocatingStringWriter w = new AllocatingStringWriter();
                try {
                    ResponseWriter.write(resp, (Writer)w, Infostore.localeFrom(session));
                }
                catch (JSONException e) {
                    ServletException se = new ServletException((Throwable)e);
                    se.initCause((Throwable)e);
                    throw se;
                }
                res.setContentType(MIME_TEXT_HTML);
                res.getWriter().write(Infostore.substituteJS(w.toString(), STR_ERROR));
            }
            try {
                id = Integer.parseInt(req.getParameter("id"));
            }
            catch (NumberFormatException x) {
                this.handleOXException(res, AjaxExceptionCodes.IMVALID_PARAMETER.create("id"), STR_ERROR, true, session);
                return;
            }
            String versionS = req.getParameter("version");
            int version2 = versionS == null ? -1 : Integer.parseInt(versionS);
            String contentType = req.getParameter("content_type");
            this.document(res, req.getHeader("user-agent"), id, version2, contentType, ctx, user, userConfig, session);
            return;
        }
        OXJSONWriter writer = new OXJSONWriter();
        InfostoreRequest request = new InfostoreRequest(session, writer);
        try {
            if (!request.action(action, new ServletRequestAdapter(req, res))) {
                this.unknownAction("GET", action, res, false);
                return;
            }
            ((JSONObject)writer.getObject()).write((Writer)res.getWriter());
        }
        catch (JSONException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (OXException e) {
            LOG.error((Object)("Not possible, obviously: " + e.getMessage()), (Throwable)e);
        }
        finally {
            ThreadLocalSessionHolder.getInstance().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ServerSession session = Infostore.getSessionObject((ServletRequest)req);
        ThreadLocalSessionHolder.getInstance().setSession(session);
        String action = req.getParameter(STR_ACTION);
        if (action == null) {
            this.missingParameter(STR_ACTION, res, false, null);
            return;
        }
        OXJSONWriter writer = new OXJSONWriter();
        InfostoreRequest request = new InfostoreRequest(session, writer);
        try {
            if (!request.action(action, new ServletRequestAdapter(req, res))) {
                this.unknownAction("PUT", action, res, false);
                return;
            }
            if (writer.isJSONObject()) {
                ((JSONObject)writer.getObject()).write((Writer)res.getWriter());
            } else if (writer.isJSONArray()) {
                res.getWriter().print(writer.getObject().toString());
            }
        }
        catch (JSONException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (OXException e) {
            LOG.error((Object)("Not possible, obviously: " + e.getMessage()), (Throwable)e);
        }
        catch (Throwable t) {
            LOG.error((Object)t.getMessage(), t);
        }
        finally {
            ThreadLocalSessionHolder.getInstance().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Response resp;
        ServerSession session = Infostore.getSessionObject((ServletRequest)req);
        ThreadLocalSessionHolder.getInstance().setSession(session);
        Context ctx = session.getContext();
        User user = session.getUser();
        UserConfiguration userConfig = session.getUserConfiguration();
        String action = req.getParameter(STR_ACTION);
        if (action == null) {
            this.missingParameter(STR_ACTION, res, true, "new");
            return;
        }
        try {
            this.checkSize(req.getContentLength(), UserSettingMailStorage.getInstance().getUserSettingMail(session.getUserId(), session.getContext()));
            if (!action.equals("new") && !action.equals("update")) {
                if (!action.equals("copy")) return;
            }
            UploadEvent upload = null;
            try {
                String obj;
                upload = this.processUpload(req);
                UploadFile uploadFile = upload.getUploadFileByFieldName("file");
                if (null != uploadFile) {
                    this.checkSize(uploadFile.getSize(), UserSettingMailStorage.getInstance().getUserSettingMail(session.getUserId(), session.getContext()));
                }
                if ((obj = upload.getFormField(STR_JSON)) == null) {
                    this.missingParameter(STR_JSON, res, true, action);
                    return;
                }
                DocumentMetadata metadata = PARSER.getDocumentMetadata(obj);
                if (action.equals("new")) {
                    this.newDocument(metadata, res, uploadFile, ctx, user, userConfig, session);
                    return;
                }
                if (!this.checkRequired(req, res, true, action, "id", "timestamp")) {
                    return;
                }
                int id = Integer.parseInt(req.getParameter("id"));
                long timestamp = Long.parseLong(req.getParameter("timestamp"));
                metadata.setId(id);
                Metadata[] presentFields = null;
                try {
                    presentFields = PARSER.findPresentFields(obj);
                }
                catch (InfostoreParser.UnknownMetadataException x) {
                    this.unknownColumn(res, "BODY", x.getColumnId(), true, action);
                    if (upload != null) {
                        upload.cleanUp();
                    }
                    ThreadLocalSessionHolder.getInstance().clear();
                    return;
                }
                if (action.equals("update")) {
                    this.update(res, id, metadata, timestamp, presentFields, uploadFile, ctx, user, userConfig, session);
                    return;
                }
                this.copy(res, id, metadata, timestamp, presentFields, uploadFile, ctx, user, userConfig, session);
                return;
            }
            finally {
                if (upload != null) {
                    upload.cleanUp();
                }
            }
        }
        catch (UploadException x) {
            resp = new Response(session);
            resp.setException(x);
            try {
                res.setContentType("text/html; charset=UTF-8");
                throw new UploadServletException(res, Infostore.substituteJS(ResponseWriter.getJSON(resp).toString(), action), x.getMessage(), (Throwable)((Object)x));
            }
            catch (JSONException e) {
                LOG.error((Object)"Giving up", (Throwable)e);
                return;
            }
        }
        catch (OXException x) {
            this.handleOXException(res, x, action, true, session);
            return;
        }
        catch (Throwable t) {
            resp = new Response(session);
            resp.setException(AjaxExceptionCodes.UNEXPECTED_ERROR.create(t, t.getMessage()));
            try {
                res.setContentType("text/html; charset=UTF-8");
                throw new UploadServletException(res, Infostore.substituteJS(ResponseWriter.getJSON(resp).toString(), action), t.getMessage(), t);
            }
            catch (JSONException e) {
                LOG.error((Object)"Giving up", (Throwable)e);
                LOG.error((Object)t.getMessage(), t);
                return;
            }
        }
        finally {
            ThreadLocalSessionHolder.getInstance().clear();
        }
    }

    private void checkSize(long size, UserSettingMail userSettingMail) throws OXException {
        long maxSize = InfostoreConfigUtils.determineRelevantUploadSize();
        if (maxSize == 0L) {
            return;
        }
        if (size > maxSize) {
            throw UploadSizeExceededException.create(size, maxSize, true);
        }
    }

    /*
     * Exception decompiling
     */
    protected void newDocument(DocumentMetadata newDocument, HttpServletResponse res, UploadFile upload, Context ctx, User user, UserConfiguration userConfig, ServerSession session) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean looksLikeFileUpload(UploadFile upload, DocumentMetadata newDocument) {
        return upload != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(HttpServletResponse res, int id, DocumentMetadata updated, long timestamp, Metadata[] presentFields, UploadFile upload, Context ctx, User user, UserConfiguration userConfig, ServerSession session) {
        boolean version2 = false;
        for (Metadata m : presentFields) {
            if (!m.equals(Metadata.VERSION_LITERAL)) continue;
            version2 = true;
            break;
        }
        if (!version2) {
            updated.setVersion(-1);
        }
        res.setContentType(MIME_TEXT_HTML);
        InfostoreFacade infostore = Infostore.getInfostore(updated.getFolderId());
        InfostoreSearchEngine searchEngine = this.getSearchEngine();
        try {
            infostore.startTransaction();
            searchEngine.startTransaction();
            if (!this.looksLikeFileUpload(upload, updated)) {
                infostore.saveDocumentMetadata(updated, timestamp, presentFields, session);
            } else {
                this.initMetadata(updated, upload);
                infostore.saveDocument(updated, new FileInputStream(upload.getTmpFile()), timestamp, presentFields, session);
            }
            infostore.commit();
            searchEngine.commit();
        }
        catch (OXException t) {
            this.rollback(infostore, null, res, t, "update", true, session);
            return;
        }
        catch (FileNotFoundException e) {
            this.rollback(infostore, null, res, e, "update", true, session);
            return;
        }
        catch (RuntimeException e) {
            this.rollback(infostore, null, res, e, "update", true, session);
            return;
        }
        finally {
            try {
                infostore.finish();
                searchEngine.finish();
            }
            catch (OXException e) {
                LOG.debug((Object)"", (Throwable)e);
            }
        }
        PrintWriter w = null;
        try {
            w = res.getWriter();
            w.write(Infostore.substituteJS("{}", "update"));
            Infostore.close(w);
        }
        catch (IOException e) {
            LOG.warn((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copy(HttpServletResponse res, int id, DocumentMetadata updated, long timestamp, Metadata[] presentFields, UploadFile upload, Context ctx, User user, UserConfiguration userConfig, ServerSession session) {
        res.setContentType(MIME_TEXT_HTML);
        InfostoreFacade infostore = this.getInfostore();
        InfostoreSearchEngine searchEngine = this.getSearchEngine();
        DocumentMetadataImpl metadata = null;
        try {
            infostore.startTransaction();
            searchEngine.startTransaction();
            metadata = new DocumentMetadataImpl(infostore.getDocumentMetadata(id, -1, ctx, user, userConfig));
            SetSwitch set = new SetSwitch(metadata);
            GetSwitch get = new GetSwitch(updated);
            for (Metadata field : presentFields) {
                Object value = field.doSwitch(get);
                set.setValue(value);
                field.doSwitch(set);
            }
            metadata.setVersion(0);
            metadata.setId(-1);
            if (upload == null) {
                if (metadata.getFileName() != null && !"".equals(metadata.getFileName())) {
                    infostore.saveDocument(metadata, infostore.getDocument(id, -1, ctx, user, userConfig), metadata.getSequenceNumber(), session);
                } else {
                    infostore.saveDocumentMetadata(metadata, timestamp, session);
                }
            } else {
                this.initMetadata(metadata, upload);
                infostore.saveDocument(metadata, new FileInputStream(upload.getTmpFile()), timestamp, session);
            }
            searchEngine.index(metadata, ctx, user, userConfig);
            infostore.commit();
            searchEngine.commit();
        }
        catch (OXException t) {
            this.rollback(infostore, searchEngine, res, t, "copy", true, session);
            return;
        }
        catch (FileNotFoundException e) {
            this.rollback(infostore, searchEngine, res, e, "copy", true, session);
            return;
        }
        catch (RuntimeException e) {
            this.rollback(infostore, searchEngine, res, e, "copy", true, session);
            return;
        }
        finally {
            try {
                infostore.finish();
                searchEngine.finish();
            }
            catch (OXException e) {
                LOG.debug((Object)"", (Throwable)e);
            }
        }
        PrintWriter w = null;
        try {
            w = res.getWriter();
            JSONObject obj = new JSONObject();
            obj.put("data", metadata.getId());
            w.print(Infostore.substituteJS(obj.toString(), "new"));
            w.flush();
        }
        catch (IOException e) {
            LOG.debug((Object)"", (Throwable)e);
        }
        catch (JSONException e) {
            LOG.debug((Object)"", (Throwable)e);
        }
        finally {
            Infostore.close(w);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void document(HttpServletResponse res, String userAgent, int id, int version2, String contentType, Context ctx, User user, UserConfiguration userConfig, Session session) throws IOException {
        InfostoreFacade infostore = this.getInfostore();
        ServletOutputStream os = null;
        InputStream documentData = null;
        try {
            DocumentMetadata metadata = infostore.getDocumentMetadata(id, version2, ctx, user, userConfig);
            documentData = infostore.getDocument(id, version2, ctx, user, userConfig);
            os = res.getOutputStream();
            res.setContentLength((int)metadata.getFileSize());
            if ("application/octet-stream".equals(contentType)) {
                StringAllocator sb;
                String contentDisposition = null;
                if (null == contentDisposition) {
                    sb = new StringAllocator(32).append("attachment");
                    DownloadUtility.appendFilenameParameter(metadata.getFileName(), null, userAgent, sb);
                    res.setHeader("Content-Disposition", sb.toString());
                } else {
                    sb = new StringAllocator(32).append(contentDisposition);
                    DownloadUtility.appendFilenameParameter(metadata.getFileName(), null, userAgent, sb);
                    res.setHeader("Content-Disposition", sb.toString());
                }
                res.setContentType(contentType);
            } else {
                DownloadUtility.CheckedDownload checkedDownload = DownloadUtility.checkInlineDownload(documentData, metadata.getFileName(), metadata.getFileMIMEType(), userAgent);
                res.setHeader("Content-Disposition", checkedDownload.getContentDisposition());
                res.setContentType(checkedDownload.getContentType());
                documentData = checkedDownload.getInputStream();
            }
            Tools.removeCachingHeader(res);
            byte[] buffer = new byte[65535];
            int bytesRead = 0;
            while ((bytesRead = documentData.read(buffer)) > 0) {
                os.write(buffer, 0, bytesRead);
            }
            os.flush();
            os = null;
        }
        catch (OXException x) {
            try {
                LOG.debug((Object)x.getMessage(), (Throwable)x);
                this.handleOXException(res, x, STR_ERROR, true, session);
            }
            catch (Throwable throwable) {
                Streams.flush(os);
                Streams.close(os);
                Streams.close(documentData);
                throw throwable;
            }
            Streams.flush(os);
            Streams.close((Closeable)os);
            Streams.close((Closeable)documentData);
            return;
        }
        Streams.flush((Flushable)os);
        Streams.close((Closeable)os);
        Streams.close((Closeable)documentData);
    }

    private final boolean handleOXException(HttpServletResponse res, Throwable t, String action, boolean post, Session session) {
        res.setContentType("text/html; charset=UTF-8");
        OXException e = t instanceof OXException ? (OXException)t : new OXException(t);
        Response resp = new Response();
        resp.setException(e);
        PrintWriter writer = null;
        try {
            writer = post ? new AllocatingStringWriter() : res.getWriter();
            ResponseWriter.write(resp, writer, Infostore.localeFrom(session));
            if (post) {
                res.getWriter().write(Infostore.substituteJS(writer.toString(), action));
            }
        }
        catch (JSONException e1) {
            LOG.error((Object)"", t);
        }
        catch (IOException e1) {
            LOG.error((Object)"", (Throwable)e);
        }
        ((OXException)t).log(LOG);
        return true;
    }

    protected void sendErrorAsJS(PrintWriter w, String error, String ... errorParams) {
        StringBuilder commaSeperatedErrorParams = new StringBuilder();
        for (String param : errorParams) {
            commaSeperatedErrorParams.append('\"');
            commaSeperatedErrorParams.append(param);
            commaSeperatedErrorParams.append('\"');
            commaSeperatedErrorParams.append(',');
        }
        commaSeperatedErrorParams.setLength(commaSeperatedErrorParams.length() - 1);
        w.print("{ \"");
        w.print(STR_ERROR);
        w.print("\" : \"");
        w.print(error);
        w.print("\", \"");
        w.print("error_params");
        w.print("\" : [");
        w.print(commaSeperatedErrorParams.toString());
        w.print('}');
        w.flush();
    }

    protected int[] parseIDList(JSONArray array) throws JSONException {
        int[] ids = new int[array.length()];
        for (int i = 0; i < array.length(); ++i) {
            JSONObject tuple = array.getJSONObject(i);
            try {
                ids[i] = tuple.getInt("id");
                continue;
            }
            catch (JSONException x) {
                ids[i] = Integer.parseInt(tuple.getString("id"));
            }
        }
        return ids;
    }

    protected void initMetadata(DocumentMetadata metadata, UploadFile upload) {
        if (metadata.getFileName() == null || "".equals(metadata.getFileName())) {
            metadata.setFileName(upload.getPreparedFileName());
        }
        if (metadata.getFileSize() <= 0L) {
            metadata.setFileSize(upload.getSize());
        }
        if (metadata.getFileMIMEType() == null || "application/octet-stream".equals(metadata.getFileMIMEType())) {
            String contentType = MimeType2ExtMap.getContentType(metadata.getFileName());
            if ("application/octet-stream".equals(contentType)) {
                contentType = upload.getContentType();
            }
            metadata.setFileMIMEType(contentType);
        }
    }

    protected void rollback(InfostoreFacade infostore, InfostoreSearchEngine searchEngine, HttpServletResponse res, Throwable t, String action, boolean post, Session session) {
        if (infostore != null) {
            try {
                infostore.rollback();
            }
            catch (OXException e) {
                LOG.error((Object)"", (Throwable)e);
            }
        }
        if (searchEngine != null) {
            try {
                searchEngine.rollback();
            }
            catch (OXException e) {
                LOG.error((Object)"", (Throwable)e);
            }
        }
        if (!this.handleOXException(res, t, action, post, session)) {
            try {
                Infostore.sendErrorAsJSHTML(res, t.toString(), action);
                LOG.error((Object)"Got non OXException", t);
            }
            catch (IOException e) {
                LOG.error((Object)e);
            }
        }
    }

    protected InfostoreFacade getInfostore() {
        return FACADE;
    }

    public static InfostoreFacade getInfostore(long folderId) {
        if (VIRTUAL_FOLDERS.contains(folderId)) {
            return VIRTUAL_FACADE;
        }
        return FACADE;
    }

    protected InfostoreSearchEngine getSearchEngine() {
        return SEARCH_ENGINE;
    }

    static {
        FACADE.setTransactional(true);
        FACADE.setSessionHolder(ThreadLocalSessionHolder.getInstance());
        SEARCH_ENGINE = new SearchEngineImpl(new DBPoolProvider());
        SEARCH_ENGINE.setTransactional(true);
        LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(Infostore.class));
        VIRTUAL_FOLDERS = new HashSet<Long>(){
            {
                this.add(14L);
                this.add(9L);
                this.add(15L);
                this.add(10L);
            }
        };
    }
}

