/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.messaging.generic.secret;

import com.openexchange.exception.OXException;
import com.openexchange.messaging.MessagingAccountManager;
import com.openexchange.messaging.MessagingService;
import com.openexchange.secret.recovery.EncryptedItemCleanUpService;
import com.openexchange.secret.recovery.EncryptedItemDetectorService;
import com.openexchange.secret.recovery.SecretMigrator;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import java.util.Collection;
import java.util.Collections;

public class MessagingSecretHandling
implements EncryptedItemDetectorService,
SecretMigrator,
EncryptedItemCleanUpService {
    public void migrate(String oldSecret, String newSecret, ServerSession session) throws OXException {
        Collection<MessagingService> messagingServices = this.getMessagingServices();
        for (MessagingService messagingService : messagingServices) {
            MessagingAccountManager accountManager = messagingService.getAccountManager();
            accountManager.migrateToNewSecret(oldSecret, newSecret, (Session)session);
        }
    }

    protected Collection<MessagingService> getMessagingServices() {
        return Collections.emptyList();
    }

    public boolean hasEncryptedItems(ServerSession session) throws OXException {
        Collection<MessagingService> messagingServices = this.getMessagingServices();
        for (MessagingService messagingService : messagingServices) {
            if (!messagingService.getAccountManager().hasAccount((Session)session)) continue;
            return true;
        }
        return false;
    }

    public void cleanUpEncryptedItems(String secret, ServerSession session) throws OXException {
        Collection<MessagingService> messagingServices = this.getMessagingServices();
        for (MessagingService messagingService : messagingServices) {
            MessagingAccountManager accountManager = messagingService.getAccountManager();
            accountManager.cleanUp(secret, (Session)session);
        }
    }
}

