/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.sessiond;

import java.util.concurrent.CountDownLatch;

public final class SessiondRequest<V> {
    private final V value;
    private volatile CountDownLatch latch;

    public SessiondRequest(V value) {
        this.value = value;
    }

    public SessiondRequest(V value, CountDownLatch latch) {
        this.value = value;
        this.latch = latch;
    }

    public SessiondRequest<V> setLatch(CountDownLatch latch) {
        if (null != this.latch) {
            throw new IllegalStateException("Latch already set.");
        }
        this.latch = latch;
        return this;
    }

    public void awaitCompletion() throws InterruptedException {
        CountDownLatch latch = this.latch;
        if (null != latch) {
            latch.await();
        }
    }

    public V getValue() {
        return this.value;
    }
}

