/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.task;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.webdav.xml.TaskTest;
import java.util.Date;
import java.util.Locale;

public class DeleteTest
extends TaskTest {
    public DeleteTest(String name) {
        super(name);
    }

    public void testDelete() throws Exception {
        Task taskObj = this.createTask("testDelete");
        int objectId1 = DeleteTest.insertTask(this.webCon, taskObj, "http://" + this.hostName, this.login, this.password, this.context);
        int objectId2 = DeleteTest.insertTask(this.webCon, taskObj, "http://" + this.hostName, this.login, this.password, this.context);
        int[][] objectIdAndFolderId = new int[][]{{objectId1, this.taskFolderId}, {objectId2, this.taskFolderId}};
        DeleteTest.deleteTask(this.webCon, objectIdAndFolderId, "http://" + this.hostName, this.login, this.password, this.context);
    }

    public void testDeleteConcurentConflict() throws Exception {
        Task appointmentObj = this.createTask("testUpdateTaskConcurentConflict");
        int objectId = DeleteTest.insertTask(this.webCon, appointmentObj, "http://" + this.hostName, this.login, this.password, this.context);
        try {
            DeleteTest.deleteTask(this.webCon, objectId, this.taskFolderId, new Date(0L), "http://" + this.hostName, this.login, this.password, this.context);
            DeleteTest.fail((String)"expected concurent modification exception!");
        }
        catch (OXException exc) {
            DeleteTest.assertExceptionMessage(exc.getDisplayMessage(Locale.ENGLISH), 1000);
        }
        DeleteTest.deleteTask(this.webCon, objectId, this.taskFolderId, "http://" + this.hostName, this.login, this.password, this.context);
    }

    public void testDeleteNotFound() throws Exception {
        Task appointmentObj = this.createTask("testUpdateTaskNotFound");
        int objectId = DeleteTest.insertTask(this.webCon, appointmentObj, "http://" + this.hostName, this.login, this.password, this.context);
        try {
            DeleteTest.deleteTask(this.webCon, objectId + 1000, this.taskFolderId, "http://" + this.hostName, this.login, this.password, this.context);
            DeleteTest.fail((String)"expected object not found exception!");
        }
        catch (OXException exc) {
            DeleteTest.assertExceptionMessage(exc.getDisplayMessage(Locale.ENGLISH), 1001);
        }
        DeleteTest.deleteTask(this.webCon, objectId, this.taskFolderId, "http://" + this.hostName, this.login, this.password, this.context);
    }
}

