/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.exception.OXException;
import com.openexchange.webdav.action.ActionTestCase;
import com.openexchange.webdav.action.MockAction;
import com.openexchange.webdav.action.MockWebdavRequest;
import com.openexchange.webdav.action.MockWebdavResponse;
import com.openexchange.webdav.action.WebdavAction;
import com.openexchange.webdav.action.WebdavExistsAction;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.WebdavResponse;
import com.openexchange.webdav.protocol.WebdavLock;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProtocolException;

public class NotExistTest
extends ActionTestCase {
    private MockAction mockAction;

    public void testNotExists() throws Exception {
        WebdavPath NOT_EXIST_URL = new WebdavPath((CharSequence)"notExists.txt");
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(NOT_EXIST_URL);
        WebdavExistsAction action = new WebdavExistsAction();
        action.setNext((WebdavAction)this.mockAction);
        try {
            action.perform((WebdavRequest)req, (WebdavResponse)res);
            NotExistTest.fail((String)"Expected 404 Not Found");
        }
        catch (WebdavProtocolException x) {
            NotExistTest.assertEquals((int)404, (int)x.getStatus());
            NotExistTest.assertFalse((boolean)this.mockAction.wasActivated());
        }
    }

    public void testExists() throws Exception {
        WebdavPath INDEX_HTML_URL = this.testCollection.dup().append(new String[]{"index.html"});
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(INDEX_HTML_URL);
        WebdavExistsAction action = new WebdavExistsAction();
        action.setNext((WebdavAction)this.mockAction);
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        NotExistTest.assertTrue((boolean)this.mockAction.wasActivated());
    }

    public void testLockNullExist() throws Exception {
        WebdavPath LOCK_NULL = this.createLockNull();
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(LOCK_NULL);
        WebdavExistsAction action = new WebdavExistsAction();
        action.setTolerateLockNull(true);
        action.setNext((WebdavAction)this.mockAction);
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        NotExistTest.assertTrue((boolean)this.mockAction.wasActivated());
    }

    public void testLockNullDontExist() throws Exception {
        WebdavPath LOCK_NULL = this.createLockNull();
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(LOCK_NULL);
        WebdavExistsAction action = new WebdavExistsAction();
        action.setNext((WebdavAction)this.mockAction);
        try {
            action.perform((WebdavRequest)req, (WebdavResponse)res);
            NotExistTest.fail((String)"Expected 404 Not Found");
        }
        catch (WebdavProtocolException x) {
            NotExistTest.assertEquals((int)404, (int)x.getStatus());
            NotExistTest.assertFalse((boolean)this.mockAction.wasActivated());
        }
    }

    public void testNotFoundShouldIncludePayload() throws OXException {
        WebdavPath NOT_EXIST_URL = new WebdavPath((CharSequence)"notExists.txt");
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(NOT_EXIST_URL);
        WebdavExistsAction action = new WebdavExistsAction();
        action.setNext((WebdavAction)this.mockAction);
        try {
            action.perform((WebdavRequest)req, (WebdavResponse)res);
            NotExistTest.fail((String)"Expected 404 Not Found");
        }
        catch (WebdavProtocolException x) {
            NotExistTest.assertNotNull((Object)res.getResponseBytes());
            NotExistTest.assertFalse((0 == res.getResponseBytes().length ? 1 : 0) != 0);
        }
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.mockAction = new MockAction();
    }

    private WebdavPath createLockNull() throws OXException {
        WebdavPath LOCK_NULL = this.testCollection.dup().append(new String[]{"lock.txt"});
        WebdavLock lock = new WebdavLock();
        lock.setDepth(0);
        lock.setOwner("me");
        lock.setScope(WebdavLock.Scope.EXCLUSIVE_LITERAL);
        lock.setTimeout(-1L);
        lock.setType(WebdavLock.Type.WRITE_LITERAL);
        this.factory.resolveResource(LOCK_NULL).lock(lock);
        return LOCK_NULL;
    }
}

