/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.java.Charsets;
import com.openexchange.webdav.action.WebdavResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class MockWebdavResponse
implements WebdavResponse {
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private final Map<String, String> headers = new HashMap<String, String>();
    private int status;

    public String getResponseBodyAsString() {
        try {
            return new String(this.out.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return e.toString();
        }
    }

    public String getHeader(String headerName) {
        return this.headers.get(headerName.toUpperCase());
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void setHeader(String header, String value) {
        this.headers.put(header.toUpperCase(), value);
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public byte[] getResponseBytes() {
        return this.out.toByteArray();
    }

    public void setContentType(String s) {
        this.setHeader("Content-Type", s);
    }

    public void sendString(String notFound) throws IOException {
        byte[] bytes = notFound.getBytes(Charsets.UTF_8);
        this.setHeader("Content-Length", String.valueOf(bytes.length));
        this.getOutputStream().write(bytes);
    }
}

