/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.update;

import com.openexchange.groupware.Init;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.server.impl.DBPool;
import com.openexchange.tools.update.Index;
import com.openexchange.tools.update.IndexNotFoundException;
import java.sql.Connection;
import java.sql.Statement;
import java.util.List;
import junit.framework.TestCase;

public class IndexTest
extends TestCase {
    private Context ctx = null;
    private Connection con = null;

    public void setUp() throws Exception {
        Init.startServer();
        ContextStorage ctxstor = ContextStorage.getInstance();
        int contextId = ctxstor.getContextId("defaultcontext");
        this.ctx = ctxstor.getContext(contextId);
        this.con = DBPool.pickupWriteable((Context)this.ctx);
        this._sql_update("CREATE TABLE test_index (id int, field01 varchar(10), field02 varchar(10), fid int, PRIMARY KEY (id, field01), INDEX named_index (fid), INDEX (fid, field01), INDEX (fid, id))");
    }

    public void tearDown() throws Exception {
        this._sql_update("DROP TABLE test_index");
        DBPool.closeWriterSilent((Context)this.ctx, (Connection)this.con);
        Init.stopServer();
    }

    public void testFindAllIndexes() throws Exception {
        List indexes = Index.findAllIndexes((Connection)this.con, (String)"test_index");
        IndexTest.assertEquals((int)4, (int)indexes.size());
        IndexTest.assertNamedIndex(indexes, "PRIMARY", "id", "field01");
        IndexTest.assertNamedIndex(indexes, "named_index", "fid");
        IndexTest.assertIndex(indexes, "fid", "field01");
        IndexTest.assertIndex(indexes, "fid", "id");
    }

    public void testFindIndexByName() throws Exception {
        Index id = Index.findByName((Connection)this.con, (String)"test_index", (String)"PRIMARY");
        IndexTest.assertNamedIndex(id, "PRIMARY", "id", "field01");
        id = Index.findByName((Connection)this.con, (String)"test_index", (String)"named_index");
        IndexTest.assertNamedIndex(id, "named_index", "fid");
    }

    public void testFindIndexContainingColumns() throws Exception {
        List indexes = Index.findContainingColumns((Connection)this.con, (String)"test_index", (String[])new String[]{"fid"});
        IndexTest.assertEquals((int)3, (int)indexes.size());
        IndexTest.assertNamedIndex(indexes, "named_index", "fid");
        IndexTest.assertIndex(indexes, "fid", "field01");
        IndexTest.assertIndex(indexes, "fid", "id");
        indexes = Index.findContainingColumns((Connection)this.con, (String)"test_index", (String[])new String[]{"fid", "id"});
        IndexTest.assertEquals((int)1, (int)indexes.size());
        IndexTest.assertIndex(indexes, "fid", "id");
    }

    public void testFindIndexWithColumns() throws Exception {
        List indexes = Index.findWithColumns((Connection)this.con, (String)"test_index", (String[])new String[]{"fid"});
        IndexTest.assertEquals((int)1, (int)indexes.size());
        IndexTest.assertNamedIndex(indexes, "named_index", "fid");
    }

    public void testDropIndex() throws Exception {
        Index id = Index.findByName((Connection)this.con, (String)"test_index", (String)"named_index");
        id.drop(this.con);
        try {
            Index.findByName((Connection)this.con, (String)"test_index", (String)"named_index");
            IndexTest.fail((String)"Didn't remove index `named_index`");
        }
        catch (IndexNotFoundException x) {
            IndexTest.assertTrue((boolean)true);
        }
    }

    public void testCreateIndex() throws Exception {
        Index id = new Index();
        id.setTable("test_index");
        id.setName("new index");
        id.setColumns(new String[]{"fid", "id", "field01"});
        id.create(this.con);
        id = Index.findByName((Connection)this.con, (String)"test_index", (String)"new index");
        IndexTest.assertNamedIndex(id, "new index", "fid", "id", "field01");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _sql_update(String sql) throws Exception {
        Statement stmt = null;
        try {
            stmt = this.con.createStatement();
            stmt.executeUpdate(sql);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public static void assertNamedIndex(List<Index> indexes, String name, String ... columns) {
        for (Index id : indexes) {
            if (!IndexTest._isNamedIndex(id, name, columns)) continue;
            return;
        }
        IndexTest.fail((String)("Index " + name + " with columns (" + IndexTest._join(columns) + ") not found in list"));
    }

    public static void assertIndex(List<Index> indexes, String ... columns) {
        for (Index id : indexes) {
            if (!IndexTest._isIndex(id, columns)) continue;
            return;
        }
        IndexTest.fail((String)("Index with columns (" + IndexTest._join(columns) + ") not found in list"));
    }

    public static void assertNamedIndex(Index id, String name, String ... columns) {
        IndexTest.assertTrue((String)("Index " + name + " with columns (" + IndexTest._join(columns) + ") expected but got " + id.toString()), (boolean)IndexTest._isNamedIndex(id, name, columns));
    }

    public static void assertIndex(Index id, String ... columns) {
        IndexTest.assertTrue((String)("Index with columns (" + IndexTest._join(columns) + ") expected but got " + id.toString()), (boolean)IndexTest._isIndex(id, columns));
    }

    public static String _join(String ... strings) {
        StringBuffer b = new StringBuffer();
        for (String s : strings) {
            b.append(s).append(',');
        }
        b.setLength(b.length() - 1);
        return b.toString();
    }

    public static boolean _isNamedIndex(Index id, String name, String ... columns) {
        if (!id.getName().equals(name)) {
            return false;
        }
        return IndexTest._isIndex(id, columns);
    }

    public static boolean _isIndex(Index id, String ... columns) {
        List cols = id.getColumns();
        if (cols.size() != columns.length) {
            return false;
        }
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].equals(cols.get(i))) continue;
            return false;
        }
        return true;
    }
}

