/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.pubsub;

import com.openexchange.config.ConfigurationService;
import com.openexchange.datatypes.genericonf.DynamicFormDescription;
import com.openexchange.datatypes.genericonf.FormElement;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.container.Contact;
import com.openexchange.publish.microformats.tools.ContactTemplateUtils;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.subscribe.SubscribeService;
import com.openexchange.subscribe.SubscriptionSource;
import com.openexchange.subscribe.microformats.MicroformatSubscribeService;
import com.openexchange.subscribe.microformats.OXMFParserFactoryService;
import com.openexchange.subscribe.microformats.datasources.HTTPOXMFDataSource;
import com.openexchange.subscribe.microformats.datasources.OXMFDataSource;
import com.openexchange.subscribe.microformats.objectparser.OXHCardParser;
import com.openexchange.subscribe.microformats.parser.HTMLMicroformatParserFactory;
import com.openexchange.subscribe.microformats.parser.ObjectParser;
import com.openexchange.subscribe.microformats.transformers.MapToContactObjectTransformer;
import com.openexchange.subscribe.microformats.transformers.MapToObjectTransformer;
import com.openexchange.templating.OXTemplate;
import com.openexchange.templating.OXTemplateImpl;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;

public abstract class AbstractContactTemplateTest
extends TestCase {
    public AbstractContactTemplateTest() {
    }

    public AbstractContactTemplateTest(String name) {
        super(name);
    }

    public Contact generateContact(String identifier) {
        Contact contact = new Contact();
        contact.setGivenName("givenname" + identifier);
        contact.setSurName("surname" + identifier);
        contact.setMiddleName("middlename" + identifier);
        contact.setSuffix("suffix" + identifier);
        contact.setEmail1("email1" + identifier + "@ox.invalid");
        contact.setEmail2("email2" + identifier + "@ox.invalid");
        contact.setEmail3("email3" + identifier + "@ox.invalid");
        contact.setDisplayName("displayname" + identifier);
        contact.setPosition("position" + identifier);
        contact.setTitle("title" + identifier);
        contact.setCompany("company" + identifier);
        contact.setStateBusiness("state_business" + identifier);
        contact.setCountryBusiness("country_business" + identifier);
        contact.setStreetBusiness("street_business" + identifier);
        contact.setPostalCodeBusiness("postal_code_business" + identifier);
        contact.setCityBusiness("city_business" + identifier);
        contact.setTelephoneBusiness1("telephone_business1" + identifier);
        contact.setTelephoneHome1("telephone_home1" + identifier);
        contact.setTelephoneBusiness2("telephone_business2" + identifier);
        contact.setTelephoneHome2("telephone_home2" + identifier);
        return contact;
    }

    protected SubscriptionSource getSubscriptionSource() {
        SubscriptionSource contactSubscriptionSource = new SubscriptionSource();
        contactSubscriptionSource.setDisplayName("OXMF Contacts");
        contactSubscriptionSource.setId("com.openexchange.subscribe.microformats.contacts.http");
        contactSubscriptionSource.setFolderModule(3);
        DynamicFormDescription form = new DynamicFormDescription();
        form.add(FormElement.input((String)"url", (String)"URL", (boolean)true, null));
        contactSubscriptionSource.setFormDescription(form);
        return contactSubscriptionSource;
    }

    protected MicroformatSubscribeService getSubscribeService() {
        HTTPOXMFDataSource dataSource = new HTTPOXMFDataSource();
        HTMLMicroformatParserFactory parserFactory = new HTMLMicroformatParserFactory();
        MapToContactObjectTransformer mapToContactObject = new MapToContactObjectTransformer();
        MicroformatSubscribeService subscribeService = new MicroformatSubscribeService();
        subscribeService.setOXMFParserFactory((OXMFParserFactoryService)parserFactory);
        subscribeService.setOXMFSource((OXMFDataSource)dataSource);
        subscribeService.setTransformer((MapToObjectTransformer)mapToContactObject);
        subscribeService.addContainerElement("ox_contact");
        subscribeService.addPrefix("ox_");
        subscribeService.addObjectParser((ObjectParser)new OXHCardParser());
        return subscribeService;
    }

    protected void introduceToEachOther(MicroformatSubscribeService service, SubscriptionSource source) {
        source.setSubscribeService((SubscribeService)service);
        service.setSource(source);
    }

    protected OXTemplate getTemplate(String templateName) throws Exception {
        Init.startServer();
        ConfigurationService conf = (ConfigurationService)ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        File path = new File(conf.getProperty("com.openexchange.templating.path"));
        FileTemplateLoader templateLoader = new FileTemplateLoader(path);
        Configuration config = new Configuration();
        config.setTemplateLoader((TemplateLoader)templateLoader);
        OXTemplateImpl oxTempl = new OXTemplateImpl();
        oxTempl.setTemplate(config.getTemplate(templateName));
        return oxTempl;
    }

    protected Map<String, Object> getVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("dateFormat", new SimpleDateFormat("yyyy-MM-dd"));
        variables.put("timeFormat", new SimpleDateFormat("yyyy-MM-dd H:m:s.S z"));
        variables.put("privacy", "");
        variables.put("userContact", "");
        variables.put("utils", new ContactTemplateUtils());
        return variables;
    }

    protected List<Contact> getContacts() {
        LinkedList<Contact> contacts = new LinkedList<Contact>();
        for (int i = 0; i < 20; ++i) {
            contacts.add(this.generateContact("_" + i));
        }
        return contacts;
    }
}

