/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.messagestorage;

import com.openexchange.exception.OXException;
import com.openexchange.mail.MailField;
import com.openexchange.mail.dataobjects.MailFolder;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.messagestorage.MessageStorageTest;
import java.io.IOException;
import javax.mail.MessagingException;

public final class MailMoveTest
extends MessageStorageTest {
    private static final MailField[] FIELDS_ID = new MailField[]{MailField.ID};
    private static final MailField[] FIELDS_MORE = new MailField[]{MailField.ID, MailField.CONTENT_TYPE, MailField.FLAGS, MailField.BODY};
    private static final MailField[] FIELDS_EVEN_MORE = new MailField[]{MailField.ID, MailField.CONTENT_TYPE, MailField.FLAGS, MailField.FROM, MailField.TO, MailField.DISPOSITION_NOTIFICATION_TO, MailField.COLOR_LABEL, MailField.HEADERS, MailField.SUBJECT, MailField.THREAD_LEVEL, MailField.SIZE, MailField.PRIORITY, MailField.SENT_DATE, MailField.RECEIVED_DATE, MailField.CC, MailField.BCC, MailField.FOLDER_ID};
    private static final MailField[] FIELDS_FULL = new MailField[]{MailField.FULL};

    public MailMoveTest() {
    }

    public MailMoveTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailMoveNotExistingMails() throws OXException, MessagingException, IOException {
        String[] uids = this.mailAccess.getMessageStorage().appendMessages("INBOX", this.testmessages);
        try {
            String fullname = this.createTemporaryFolder(this.getSession(), this.mailAccess);
            try {
                String[] tmpCopy = null;
                try {
                    long currentTimeMillis = System.currentTimeMillis();
                    tmpCopy = this.mailAccess.getMessageStorage().moveMessages("INBOX", fullname, new String[]{String.valueOf(currentTimeMillis), String.valueOf(currentTimeMillis + 1L)}, false);
                }
                catch (Exception e) {
                    MailMoveTest.fail((String)"No exception should be thrown here");
                }
                MailMoveTest.assertNotNull((String)"Move returned no IDs", tmpCopy);
                MailMoveTest.assertTrue((String)("Method moveMessages returned wrong id at pos 0. Must be null, but was " + (String)tmpCopy[0]), (tmpCopy[0] == null ? 1 : 0) != 0);
                MailMoveTest.assertTrue((String)("Method moveMessages returned wrong id at pos 1. Must be null, but was " + tmpCopy[1]), (tmpCopy[1] == null ? 1 : 0) != 0);
            }
            finally {
                this.mailAccess.getFolderStorage().deleteFolder(fullname, true);
            }
        }
        finally {
            this.mailAccess.getMessageStorage().deleteMessages("INBOX", uids, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailMoveNotExistingMailsMixed() throws OXException, MessagingException, IOException {
        String[] uids = this.mailAccess.getMessageStorage().appendMessages("INBOX", this.testmessages);
        try {
            String fullname = this.createTemporaryFolder(this.getSession(), this.mailAccess);
            try {
                String[] tmpCopy = null;
                try {
                    tmpCopy = this.mailAccess.getMessageStorage().moveMessages("INBOX", fullname, new String[]{String.valueOf(System.currentTimeMillis()), uids[0]}, false);
                }
                catch (Exception e) {
                    MailMoveTest.fail((String)"No exception should be thrown here");
                }
                MailMoveTest.assertNotNull((String)"Move returned no IDs", tmpCopy);
                MailMoveTest.assertTrue((String)("Method moveMessages returned wrong id at pos 0. Must be null, but was " + (String)tmpCopy[0]), (tmpCopy[0] == null ? 1 : 0) != 0);
                MailMoveTest.assertTrue((String)("Method moveMessages returned wrong id at pos 1. Must be != null, but was " + tmpCopy[1]), (tmpCopy[1] != null ? 1 : 0) != 0);
            }
            finally {
                this.mailAccess.getFolderStorage().deleteFolder(fullname, true);
            }
        }
        finally {
            this.mailAccess.getMessageStorage().deleteMessages("INBOX", uids, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailMoveToNotExistingFolder() throws OXException, MessagingException, IOException {
        String[] uids = this.mailAccess.getMessageStorage().appendMessages("INBOX", this.testmessages);
        try {
            MailFolder inbox = this.mailAccess.getFolderStorage().getFolder("INBOX");
            String tmpFolderName = inbox.getFullname() + inbox.getSeparator() + "MichGibtEsNicht";
            try {
                MailMoveTest.assertNull((String)"No ids should be returned", (Object)this.mailAccess.getMessageStorage().moveMessages("INBOX", tmpFolderName, uids, false));
            }
            catch (OXException e) {
                MailMoveTest.assertTrue((String)"Wrong Exception is thrown.", (boolean)e.getErrorCode().endsWith("-1002"));
            }
        }
        finally {
            this.mailAccess.getMessageStorage().deleteMessages("INBOX", uids, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailMoveFromNotExistingFolder() throws OXException, MessagingException, IOException {
        String[] uids = this.mailAccess.getMessageStorage().appendMessages("INBOX", this.testmessages);
        try {
            String fullname = this.createTemporaryFolder(this.getSession(), this.mailAccess);
            try {
                try {
                    MailMoveTest.assertNull((String)"No ids should be returned", (Object)this.mailAccess.getMessageStorage().moveMessages("MichGibtEsHoffentlichNicht", fullname, uids, false));
                }
                catch (OXException e) {
                    MailMoveTest.assertTrue((String)"Wrong Exception is thrown.", (boolean)e.getErrorCode().endsWith("-1002"));
                }
            }
            finally {
                this.mailAccess.getFolderStorage().deleteFolder(fullname, true);
            }
        }
        finally {
            this.mailAccess.getMessageStorage().deleteMessages("INBOX", uids, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailMoveAllOk() throws OXException, MessagingException, IOException {
        String[] uids = this.mailAccess.getMessageStorage().appendMessages("INBOX", this.testmessages);
        try {
            String fullname = this.createTemporaryFolder(this.getSession(), this.mailAccess);
            try {
                int i;
                String[] copied = this.mailAccess.getMessageStorage().moveMessages("INBOX", fullname, uids, false);
                MailMoveTest.assertTrue((String)"Missing copied mail IDs", (copied != null ? 1 : 0) != 0);
                MailMoveTest.assertTrue((String)"Number of copied messages does not match", (copied.length == uids.length ? 1 : 0) != 0);
                for (int i2 = 0; i2 < copied.length; ++i2) {
                    MailMoveTest.assertTrue((String)"Invalid mail ID", (copied[i2] != null ? 1 : 0) != 0);
                }
                MailMessage[] fetchedMails = this.mailAccess.getMessageStorage().getMessages(fullname, copied, FIELDS_ID);
                for (i = 0; i < fetchedMails.length; ++i) {
                    MailMoveTest.assertFalse((String)"Mail ID is -1", (fetchedMails[i].getMailId() == null ? 1 : 0) != 0);
                }
                fetchedMails = this.mailAccess.getMessageStorage().getMessages(fullname, copied, FIELDS_MORE);
                for (i = 0; i < fetchedMails.length; ++i) {
                    MailMoveTest.assertFalse((String)"Missing mail ID", (fetchedMails[i].getMailId() == null ? 1 : 0) != 0);
                    MailMoveTest.assertTrue((String)"Missing content type", (boolean)fetchedMails[i].containsContentType());
                    MailMoveTest.assertTrue((String)"Missing flags", (boolean)fetchedMails[i].containsFlags());
                    if (fetchedMails[i].getContentType().isMimeType("multipart/*")) {
                        MailMoveTest.assertFalse((String)"Enclosed count returned -1", (fetchedMails[i].getEnclosedCount() == -1 ? 1 : 0) != 0);
                        continue;
                    }
                    MailMoveTest.assertFalse((String)"Content is null", (fetchedMails[i].getContent() == null ? 1 : 0) != 0);
                }
                fetchedMails = this.mailAccess.getMessageStorage().getMessages(fullname, copied, FIELDS_EVEN_MORE);
                for (i = 0; i < fetchedMails.length; ++i) {
                    MailMoveTest.assertFalse((String)"Missing mail ID", (fetchedMails[i].getMailId() == null ? 1 : 0) != 0);
                    MailMoveTest.assertTrue((String)"Missing content type", (boolean)fetchedMails[i].containsContentType());
                    MailMoveTest.assertTrue((String)"Missing flags", (boolean)fetchedMails[i].containsFlags());
                    MailMoveTest.assertTrue((String)"Missing From", (boolean)fetchedMails[i].containsFrom());
                    MailMoveTest.assertTrue((String)"Missing To", (boolean)fetchedMails[i].containsTo());
                    MailMoveTest.assertTrue((String)"Missing Disposition-Notification-To", (boolean)fetchedMails[i].containsDispositionNotification());
                    MailMoveTest.assertTrue((String)"Missing color label", (boolean)fetchedMails[i].containsColorLabel());
                    MailMoveTest.assertTrue((String)"Missing headers", (boolean)fetchedMails[i].containsHeaders());
                    MailMoveTest.assertTrue((String)"Missing subject", (boolean)fetchedMails[i].containsSubject());
                    MailMoveTest.assertTrue((String)"Missing thread level", (boolean)fetchedMails[i].containsThreadLevel());
                    MailMoveTest.assertTrue((String)"Missing size", (boolean)fetchedMails[i].containsSize());
                    MailMoveTest.assertTrue((String)"Missing priority", (boolean)fetchedMails[i].containsPriority());
                    MailMoveTest.assertTrue((String)"Missing sent date", (boolean)fetchedMails[i].containsSentDate());
                    MailMoveTest.assertTrue((String)"Missing received date", (boolean)fetchedMails[i].containsReceivedDate());
                    MailMoveTest.assertTrue((String)"Missing Cc", (boolean)fetchedMails[i].containsCc());
                    MailMoveTest.assertTrue((String)"Missing Bcc", (boolean)fetchedMails[i].containsBcc());
                    MailMoveTest.assertTrue((String)"Missing folder fullname", (boolean)fetchedMails[i].containsFolder());
                }
                fetchedMails = this.mailAccess.getMessageStorage().getMessages(fullname, copied, FIELDS_FULL);
                for (i = 0; i < fetchedMails.length; ++i) {
                    MailMoveTest.assertFalse((String)"Missing mail ID", (fetchedMails[i].getMailId() == null ? 1 : 0) != 0);
                    MailMoveTest.assertTrue((String)"Missing content type", (boolean)fetchedMails[i].containsContentType());
                    MailMoveTest.assertTrue((String)"Missing flags", (boolean)fetchedMails[i].containsFlags());
                    MailMoveTest.assertTrue((String)"Missing From", (boolean)fetchedMails[i].containsFrom());
                    MailMoveTest.assertTrue((String)"Missing To", (boolean)fetchedMails[i].containsTo());
                    MailMoveTest.assertTrue((String)"Missing Disposition-Notification-To", (boolean)fetchedMails[i].containsDispositionNotification());
                    MailMoveTest.assertTrue((String)"Missing color label", (boolean)fetchedMails[i].containsColorLabel());
                    MailMoveTest.assertTrue((String)"Missing headers", (boolean)fetchedMails[i].containsHeaders());
                    MailMoveTest.assertTrue((String)"Missing subject", (boolean)fetchedMails[i].containsSubject());
                    MailMoveTest.assertTrue((String)"Missing thread level", (boolean)fetchedMails[i].containsThreadLevel());
                    MailMoveTest.assertTrue((String)"Missing size", (boolean)fetchedMails[i].containsSize());
                    MailMoveTest.assertTrue((String)"Missing priority", (boolean)fetchedMails[i].containsPriority());
                    MailMoveTest.assertTrue((String)"Missing sent date", (boolean)fetchedMails[i].containsSentDate());
                    MailMoveTest.assertTrue((String)"Missing received date", (boolean)fetchedMails[i].containsReceivedDate());
                    MailMoveTest.assertTrue((String)"Missing Cc", (boolean)fetchedMails[i].containsCc());
                    MailMoveTest.assertTrue((String)"Missing Bcc", (boolean)fetchedMails[i].containsBcc());
                    MailMoveTest.assertTrue((String)"Missing folder fullname", (boolean)fetchedMails[i].containsFolder());
                    if (fetchedMails[i].getContentType().isMimeType("multipart/*")) {
                        MailMoveTest.assertFalse((String)"Enclosed count returned -1", (fetchedMails[i].getEnclosedCount() == -1 ? 1 : 0) != 0);
                        continue;
                    }
                    MailMoveTest.assertFalse((String)"Content is null", (fetchedMails[i].getContent() == null ? 1 : 0) != 0);
                }
                for (i = 0; i < uids.length; ++i) {
                    Exception exc = null;
                    MailMessage tmp = null;
                    try {
                        tmp = this.mailAccess.getMessageStorage().getMessage("INBOX", uids[i], false);
                    }
                    catch (Exception e) {
                        exc = e;
                    }
                    MailMoveTest.assertTrue((String)"A moved message still exists in source folder", (exc != null || tmp == null ? 1 : 0) != 0);
                }
            }
            finally {
                this.mailAccess.getFolderStorage().deleteFolder(fullname, true);
            }
        }
        finally {
            this.mailAccess.getMessageStorage().deleteMessages("INBOX", uids, true);
        }
    }
}

