/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail;

import com.openexchange.configuration.MailConfig;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.StorageParameters;
import com.openexchange.folderstorage.internal.StorageParametersImpl;
import com.openexchange.folderstorage.mail.MailFolderStorage;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.api.IMailFolderStorageEnhanced;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;
import com.openexchange.sessiond.impl.SessionObjectWrapper;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import junit.framework.TestCase;

public abstract class AbstractMailTest
extends TestCase {
    private String server;
    private int port;
    private String login;
    private int secondUser;
    private String password;
    private int user;
    private int cid;
    private String testMailDir;
    private SessionObject session;
    private static final String STR_TRUE = "true";
    private static final String STR_FALSE = "false";
    private static Properties sessionProperties;

    public AbstractMailTest() {
    }

    public AbstractMailTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        Init.startServer();
        MailConfig.init();
        this.server = MailConfig.getProperty(MailConfig.Property.SERVER);
        this.port = Integer.parseInt(MailConfig.getProperty(MailConfig.Property.PORT));
        this.login = MailConfig.getProperty(MailConfig.Property.LOGIN);
        this.secondUser = Integer.parseInt(MailConfig.getProperty(MailConfig.Property.SECOND_USER));
        this.password = MailConfig.getProperty(MailConfig.Property.PASSWORD);
        this.user = Integer.parseInt(MailConfig.getProperty(MailConfig.Property.USER));
        this.cid = Integer.parseInt(MailConfig.getProperty(MailConfig.Property.CONTEXT));
        this.testMailDir = MailConfig.getProperty(MailConfig.Property.TEST_MAIL_DIR);
    }

    protected void tearDown() throws Exception {
        Init.stopServer();
    }

    protected int getMessageCount(MailAccess<?, ?> mailAccess, String fullName) throws OXException {
        if (mailAccess.getFolderStorage() instanceof IMailFolderStorageEnhanced) {
            return ((IMailFolderStorageEnhanced)mailAccess.getFolderStorage()).getTotalCounter(fullName);
        }
        return this.getMessageCount(mailAccess.getAccountId(), fullName);
    }

    protected int getMessageCount(int accountId, String fullName) throws OXException {
        MailFolderStorage folderStorage = new MailFolderStorage();
        StorageParametersImpl storageParameters = new StorageParametersImpl(ServerSessionAdapter.valueOf((Session)this.getSession()));
        boolean started = folderStorage.startTransaction((StorageParameters)storageParameters, false);
        try {
            Folder folder = folderStorage.getFolder(MailFolderStorage.REAL_TREE_ID, MailFolderUtility.prepareFullname((int)accountId, (String)fullName), (StorageParameters)storageParameters);
            int total = folder.getTotal();
            if (started) {
                folderStorage.commitTransaction((StorageParameters)storageParameters);
            }
            return total;
        }
        catch (OXException e) {
            if (started) {
                folderStorage.rollback((StorageParameters)storageParameters);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (started) {
                folderStorage.rollback((StorageParameters)storageParameters);
            }
            throw MailExceptionCode.UNEXPECTED_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    protected final String getLogin() {
        return this.login;
    }

    protected final String getLocalIP() {
        return "127.0.0.1";
    }

    protected final int getSecondUser() {
        return this.secondUser;
    }

    protected final String getPassword() {
        return this.password;
    }

    protected final int getPort() {
        return this.port;
    }

    protected final String getServer() {
        return this.server;
    }

    protected final int getCid() {
        return this.cid;
    }

    protected final int getUser() {
        return this.user;
    }

    protected final SessionObject getSession() {
        if (null == this.session) {
            this.session = SessionObjectWrapper.createSessionObject((int)this.getUser(), (Context)new ContextImpl(this.getCid()), (String)"mail-test-session");
            this.session.setPassword(this.getPassword());
            this.session.setLocalIp(this.getLocalIP());
        }
        return this.session;
    }

    protected final UserSettingMail getUserSettingMail() throws OXException {
        return UserSettingMailStorage.getInstance().getUserSettingMail(this.getUser(), this.getCid());
    }

    protected final String getTestMailDir() {
        return this.testMailDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final Properties getDefaultSessionProperties() {
        Class<AbstractMailTest> clazz = AbstractMailTest.class;
        synchronized (AbstractMailTest.class) {
            if (sessionProperties == null) {
                System.getProperties().put("mail.mime.base64.ignoreerrors", STR_TRUE);
                System.getProperties().put("mail.imap.allowreadonlyselect", STR_TRUE);
                System.getProperties().put("mail.mime.encodeeol.strict", STR_TRUE);
                System.getProperties().put("mail.mime.decodetext.strict", STR_FALSE);
                System.getProperties().put("mail.mime.charset", "UTF-8");
                sessionProperties = (Properties)System.getProperties().clone();
                sessionProperties.put("mail.imap.connectionpoolsize", "1");
                sessionProperties.put("mail.imap.connectionpooltimeout", "1000");
                // ** MonitorExit[var0] (shouldn't be in output)
                return sessionProperties;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sessionProperties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final MailMessage[] getMessages(String dir, int limit) throws MessagingException, IOException, OXException {
        File fdir = new File(dir);
        File[] messageFiles = fdir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return Pattern.compile("mail.*\\.eml").matcher(name).matches();
            }
        });
        int len = limit < 0 ? messageFiles.length : Math.min(messageFiles.length, limit);
        MimeMessage[] msgs = new MimeMessage[len];
        javax.mail.Session session = javax.mail.Session.getInstance((Properties)AbstractMailTest.getDefaultSessionProperties());
        for (int i = 0; i < msgs.length; ++i) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(messageFiles[i]);
                msgs[i] = new MimeMessage(session, (InputStream)in);
                continue;
            }
            finally {
                if (null != in) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        MailMessage[] retval = new MailMessage[msgs.length];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = MimeMessageConverter.convertMessage((MimeMessage)msgs[i]);
        }
        return retval;
    }
}

