/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.calendarsqltests;

import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.calendarsqltests.CalendarSqlTest;
import com.openexchange.groupware.container.Participant;

public class Bug13226Test
extends CalendarSqlTest {
    private CalendarDataObject appointment;
    private CalendarDataObject changeAppointment;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.appointment = this.appointments.buildAppointmentWithGroupParticipants(this.group);
        this.appointment.setTitle("Bug 13226 Test");
        this.appointments.save(this.appointment);
        this.clean.add(this.appointment);
        this.changeAppointment = this.appointments.createIdentifyingCopy(this.appointment);
        this.changeAppointment.setLastModified(this.appointment.getLastModified());
        this.changeAppointment.setTitle("Bug 13226 Test - CHANGED");
        this.changeAppointment.setParticipants(this.appointments.load(this.appointment.getObjectID(), this.appointment.getParentFolderID()).getParticipants());
        this.appointments.switchUser(this.secondUser);
        this.changeAppointment.setParentFolderID(this.appointments.getPrivateFolder());
    }

    public void testBug13226() throws Exception {
        this.appointments.save(this.changeAppointment);
        this.appointments.switchUser(this.user);
        CalendarDataObject loadedAppointment = this.appointments.load(this.appointment.getObjectID(), this.appointment.getParentFolderID());
        boolean found = false;
        for (Participant participant : loadedAppointment.getParticipants()) {
            if (participant.getIdentifier() != this.secondUserId) continue;
            found = true;
            break;
        }
        Bug13226Test.assertFalse((String)"Did not expect the change user as participant.", (boolean)found);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }
}

