/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware;

import com.openexchange.calendar.CalendarSql;
import com.openexchange.event.impl.EventConfigImpl;
import com.openexchange.groupware.CalendarTest;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.configuration.AbstractConfigWrapper;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.server.impl.DBPool;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;
import com.openexchange.sessiond.impl.SessionObjectWrapper;
import com.openexchange.test.AjaxInit;
import com.openexchange.tools.iterator.SearchIterator;
import java.sql.Connection;
import java.util.Date;
import java.util.Properties;
import junit.framework.TestCase;

public class AppointmentDeleteNoCommit
extends TestCase {
    int[] cols = new int[]{201, 202, 200, 206, 207, 1, 20, 221, 401};
    public static final long SUPER_END = 253402210800000L;
    public static final String TIMEZONE = "Europe/Berlin";
    private static int userid = 11;
    public static final int contextid = 1;
    private static boolean init = false;

    protected void setUp() throws Exception {
        super.setUp();
        EventConfigImpl event = new EventConfigImpl();
        event.setEventQueueEnabled(false);
        userid = AppointmentDeleteNoCommit.getUserId();
        ContextStorage.start();
    }

    protected void tearDown() throws Exception {
        if (init) {
            init = false;
            Init.stopServer();
        }
        super.tearDown();
    }

    private static Properties getAJAXProperties() {
        Properties properties = AjaxInit.getAJAXProperties();
        return properties;
    }

    private static int resolveUser(String u) throws Exception {
        UserStorage uStorage = UserStorage.getInstance();
        return uStorage.getUserId(u, AppointmentDeleteNoCommit.getContext());
    }

    public static int getUserId() throws Exception {
        if (!init) {
            Init.startServer();
            init = true;
        }
        String user = AbstractConfigWrapper.parseProperty((Properties)AppointmentDeleteNoCommit.getAJAXProperties(), (String)"user_participant3", (String)"");
        return AppointmentDeleteNoCommit.resolveUser(user);
    }

    public static Context getContext() {
        return new ContextImpl(1);
    }

    void deleteAllAppointments() throws Exception {
        Connection readcon = DBPool.pickup((Context)AppointmentDeleteNoCommit.getContext());
        ContextImpl context = new ContextImpl(1);
        SessionObject so = SessionObjectWrapper.createSessionObject((int)userid, (int)context.getContextId(), (String)"deleteAllApps");
        CalendarSql csql = new CalendarSql((Session)so);
        SearchIterator si = csql.getAppointmentsBetween(userid, new Date(0L), new Date(253402210800000L), this.cols, 0, null);
        while (si.hasNext()) {
            Appointment cdao = (Appointment)si.next();
            CalendarTest.testDelete(cdao);
        }
        si.close();
        DBPool.push((Context)context, (Connection)readcon);
    }

    public static int getPrivateFolder(int userid) throws Exception {
        int privatefolder = 0;
        Context context = AppointmentDeleteNoCommit.getContext();
        Connection readcon = DBPool.pickup((Context)context);
        privatefolder = CalendarTest.getCalendarDefaultFolderForUser(userid, context);
        DBPool.push((Context)context, (Connection)readcon);
        return privatefolder;
    }

    public void testDeleteAll() throws Exception {
        this.deleteAllAppointments();
    }
}

