/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.bugs;

import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.dav.carddav.VCardResource;
import com.openexchange.groupware.container.Contact;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class Bug23046Test
extends CardDAVTest {
    public Bug23046Test(String name) {
        super(name);
    }

    public void testCreateWithURLWithoutAuthority() throws Exception {
        String syncToken = super.fetchSyncToken();
        String uid = Bug23046Test.randomUID();
        String firstName = "test";
        String lastName = "jupp";
        String url = "http://";
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:" + lastName + ";" + firstName + ";;;" + "\r\n" + "FN:" + firstName + " " + lastName + "\r\n" + "URL:" + url + "\r\n" + "UID:" + uid + "\r\n" + "REV:" + CardDAVTest.formatAsUTC(new Date()) + "\r\n" + "PRODID:-//Apple Inc.//AddressBook 6.1//EN" + "\r\n" + "END:VCARD" + "\r\n";
        Bug23046Test.assertEquals((String)"response code wrong", (int)201, (int)super.putVCard(uid, vCard));
        Contact contact = super.getContact(uid);
        super.rememberForCleanUp(contact);
        Bug23046Test.assertEquals((String)"uid wrong", (String)uid, (String)contact.getUid());
        Bug23046Test.assertEquals((String)"url wrong", (String)url, (String)contact.getURL());
        Map<String, String> eTags = super.syncCollection(syncToken);
        Bug23046Test.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = Bug23046Test.assertContains(uid, addressData);
        Bug23046Test.assertEquals((String)"N wrong", (String)firstName, (String)card.getVCard().getName().getGivenName());
        Bug23046Test.assertEquals((String)"N wrong", (String)lastName, (String)card.getVCard().getName().getFamilyName());
        Bug23046Test.assertEquals((String)"FN wrong", (String)(firstName + " " + lastName), (String)card.getVCard().getFormattedName().getFormattedName());
        Bug23046Test.assertNotNull((String)"URL wrong", card.getVCard().getURLs().next());
    }
}

