/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.PropertyNames;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import java.util.Date;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;

public class Bug22094Test
extends CalDAVTest {
    public Bug22094Test(String name) {
        super(name);
    }

    public void testMoveAppointment() throws Exception {
        FolderObject subfolder = super.createFolder("move test");
        String subfolderID = Integer.toString(subfolder.getObjectID());
        String uid = Bug22094Test.randomUID();
        Date start = TimeTools.D("next thursday at 7:15");
        Date end = TimeTools.D("next thursday at 11:30");
        String title = "move test";
        String iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nPRODID:-//Apple Inc.//iCal 5.0.2//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nDTSTART:19810329T020000\r\nTZNAME:CEST\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nDTSTART:19961027T030000\r\nTZNAME:CET\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nCREATED:" + Bug22094Test.formatAsUTC(new Date()) + "\r\n" + "UID:" + uid + "\r\n" + "DTEND;TZID=Europe/Berlin:" + Bug22094Test.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE" + "\r\n" + "CLASS:PUBLIC" + "\r\n" + "SUMMARY:" + title + "\r\n" + "LAST-MODIFIED:" + Bug22094Test.formatAsUTC(new Date()) + "\r\n" + "DTSTAMP:" + Bug22094Test.formatAsUTC(new Date()) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + Bug22094Test.format(start, "Europe/Berlin") + "\r\n" + "SEQUENCE:1" + "\r\n" + "END:VEVENT" + "\r\n" + "END:VCALENDAR";
        Bug22094Test.assertEquals((String)"response code wrong", (int)201, (int)super.putICal(uid, iCal));
        Appointment appointment = super.getAppointment(uid);
        Bug22094Test.assertNotNull((String)"appointment not found on server", (Object)appointment);
        super.rememberForCleanUp(appointment);
        ICalResource iCalResource = super.get(uid, null);
        Bug22094Test.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Bug22094Test.assertEquals((String)"UID wrong", (String)uid, (String)iCalResource.getVEvent().getUID());
        Bug22094Test.assertEquals((String)"response code wrong", (int)201, (int)super.move(iCalResource, subfolderID));
        DavPropertyNameSet props = new DavPropertyNameSet();
        props.add(PropertyNames.GETETAG);
        PropFindMethod propFind = new PropFindMethod(this.getWebDAVClient().getBaseURI() + iCalResource.getHref(), 0, props, 0);
        MultiStatusResponse[] responses = this.getWebDAVClient().doPropFind(propFind);
        Bug22094Test.assertNotNull((String)"got no response", (Object)responses);
        Bug22094Test.assertTrue((String)"got no responses", (1 == responses.length ? 1 : 0) != 0);
        String eTag = this.extractTextContent(PropertyNames.GETETAG, responses[0]);
        Bug22094Test.assertNotNull((String)"got no ETag from response", (Object)eTag);
        iCalResource.setEtag(eTag);
        Bug22094Test.assertEquals((String)"response code wrong", (int)201, (int)super.putICalUpdate(iCalResource));
        iCalResource = super.get(subfolderID, uid, iCalResource.getETag());
        Bug22094Test.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Bug22094Test.assertEquals((String)"UID wrong", (String)uid, (String)iCalResource.getVEvent().getUID());
        Bug22094Test.assertNull((String)"appointment still in source folder on server", (Object)super.getAppointment(uid));
        appointment = super.getAppointment(subfolderID, uid);
        super.rememberForCleanUp(appointment);
        Bug22094Test.assertNotNull((String)"appointment not found in target folder on server", (Object)appointment);
        Bug22094Test.assertEquals((String)"folder ID wrong", (int)subfolder.getObjectID(), (int)appointment.getParentFolderID());
    }
}

