/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav;

import com.openexchange.dav.PropertyNames;
import com.openexchange.dav.SyncToken;
import com.openexchange.dav.WebDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.dav.caldav.ical.SimpleICal;
import com.openexchange.dav.caldav.reports.CalendarMultiGetReportInfo;
import com.openexchange.dav.reports.SyncCollectionResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.test.CalendarTestManager;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.MoveMethod;
import org.apache.jackrabbit.webdav.client.methods.PutMethod;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.json.JSONException;

public abstract class CalDAVTest
extends WebDAVTest {
    protected static final int TIMEOUT = 10000;
    private CalendarTestManager testManager = null;
    private int folderId;

    public CalDAVTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.folderId = this.getAJAXClient().getValues().getPrivateAppointmentFolder();
        this.testManager = new CalendarTestManager(this.getAJAXClient());
        this.testManager.setFailOnError(true);
    }

    @Override
    protected void tearDown() throws Exception {
        if (null != this.getManager()) {
            this.getManager().cleanUp();
        }
        super.tearDown();
    }

    protected String getDefaultFolderID() {
        return Integer.toString(this.folderId);
    }

    protected FolderObject createFolder(String folderName) throws OXException, IOException, JSONException {
        return this.createFolder(this.getFolder(this.folderId), folderName);
    }

    protected CalendarTestManager getManager() {
        return this.testManager;
    }

    @Override
    protected String getDefaultUserAgent() {
        return "CalendarStore/5.0.2 (1166); iCal/5.0.2 (1571); Mac OS X/10.7.3 (11D50d)";
    }

    protected void delete(Appointment appointment) {
        this.getManager().delete(appointment);
    }

    @Override
    protected String fetchSyncToken(String folderID) throws OXException, IOException, DavException {
        return super.fetchSyncToken("/caldav/" + folderID);
    }

    protected String fetchSyncToken() throws OXException, IOException, DavException {
        return this.fetchSyncToken(this.getDefaultFolderID());
    }

    @Override
    protected SyncCollectionResponse syncCollection(SyncToken syncToken, String folderID) throws OXException, IOException, DavException {
        return super.syncCollection(syncToken, "/caldav/" + folderID);
    }

    protected SyncCollectionResponse syncCollection(SyncToken syncToken) throws OXException, IOException, DavException {
        return this.syncCollection(syncToken, this.getDefaultFolderID());
    }

    protected List<ICalResource> calendarMultiget(Collection<String> hrefs) throws OXException, IOException, DavException, SimpleICal.SimpleICalException {
        return this.calendarMultiget(this.getDefaultFolderID(), hrefs);
    }

    protected List<ICalResource> calendarMultiget(String folderID, Collection<String> hrefs) throws OXException, IOException, DavException, SimpleICal.SimpleICalException {
        MultiStatusResponse[] responses;
        ArrayList<ICalResource> calendarData = new ArrayList<ICalResource>();
        DavPropertyNameSet props = new DavPropertyNameSet();
        props.add(PropertyNames.GETETAG);
        props.add(PropertyNames.CALENDAR_DATA);
        CalendarMultiGetReportInfo reportInfo = new CalendarMultiGetReportInfo(hrefs.toArray(new String[hrefs.size()]), props);
        for (MultiStatusResponse response : responses = this.getWebDAVClient().doReport(reportInfo, CalDAVTest.getBaseUri() + "/caldav/" + folderID + "/")) {
            if (!response.getProperties(200).contains(PropertyNames.GETETAG)) continue;
            String href = response.getHref();
            CalDAVTest.assertNotNull((String)"got no href from response", (Object)href);
            String data = this.extractTextContent(PropertyNames.CALENDAR_DATA, response);
            CalDAVTest.assertNotNull((String)"got no address data from response", (Object)data);
            String eTag = this.extractTextContent(PropertyNames.GETETAG, response);
            CalDAVTest.assertNotNull((String)"got no etag data from response", (Object)eTag);
            calendarData.add(new ICalResource(data, href, eTag));
        }
        return calendarData;
    }

    protected int putICal(String resourceName, String iCal) throws HttpException, IOException, OXException, URISyntaxException {
        return this.putICal(this.getDefaultFolderID(), resourceName, iCal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int putICal(String folderID, String resourceName, String iCal) throws HttpException, IOException, OXException, URISyntaxException {
        int n;
        PutMethod put = null;
        try {
            String href = "/caldav/" + folderID + "/" + CalDAVTest.urlEncode(resourceName) + ".ics";
            put = new PutMethod(CalDAVTest.getBaseUri() + href);
            put.addRequestHeader("If-None-Match", "*");
            put.setRequestEntity((RequestEntity)new StringRequestEntity(iCal, "text/calendar", null));
            n = this.getWebDAVClient().executeMethod((HttpMethod)put);
        }
        catch (Throwable throwable) {
            CalDAVTest.release(put);
            throw throwable;
        }
        CalDAVTest.release((HttpMethodBase)put);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int move(ICalResource iCalResource, String targetFolderID) throws OXException, HttpException, IOException {
        int n;
        MoveMethod move = null;
        try {
            int status;
            String targetHref = "/caldav/" + targetFolderID + "/" + iCalResource.getHref().substring(1 + iCalResource.getHref().lastIndexOf(47));
            move = new MoveMethod(CalDAVTest.getBaseUri() + iCalResource.getHref(), CalDAVTest.getBaseUri() + targetHref, false);
            if (null != iCalResource.getETag()) {
                move.addRequestHeader("If-Match", iCalResource.getETag());
            }
            if (201 == (status = this.getWebDAVClient().executeMethod((HttpMethod)move))) {
                iCalResource.setHref(targetHref);
            }
            n = status;
        }
        catch (Throwable throwable) {
            CalDAVTest.release(move);
            throw throwable;
        }
        CalDAVTest.release((HttpMethodBase)move);
        return n;
    }

    protected ICalResource get(String resourceName, String ifNoneMatchEtag) throws HttpException, IOException, OXException, URISyntaxException, SimpleICal.SimpleICalException {
        return this.get(this.getDefaultFolderID(), resourceName, ifNoneMatchEtag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ICalResource get(String folderID, String resourceName, String ifNoneMatchEtag) throws HttpException, IOException, OXException, URISyntaxException, SimpleICal.SimpleICalException {
        ICalResource iCalResource;
        GetMethod get = null;
        try {
            String href = "/caldav/" + folderID + "/" + CalDAVTest.urlEncode(resourceName) + ".ics";
            get = new GetMethod(CalDAVTest.getBaseUri() + href);
            get.addRequestHeader("If-None-Match", null != ifNoneMatchEtag ? ifNoneMatchEtag : "*");
            CalDAVTest.assertEquals((String)"response code wrong", (int)200, (int)this.getWebDAVClient().executeMethod((HttpMethod)get));
            String responseBody = get.getResponseBodyAsString();
            CalDAVTest.assertNotNull((String)"got no response body", (Object)responseBody);
            iCalResource = new ICalResource(responseBody, href, get.getResponseHeader("ETag").getValue());
        }
        catch (Throwable throwable) {
            CalDAVTest.release(get);
            throw throwable;
        }
        CalDAVTest.release((HttpMethodBase)get);
        return iCalResource;
    }

    private static String urlEncode(String name) throws URISyntaxException {
        return new URI(null, name, null).toString();
    }

    protected int putICalUpdate(String resourceName, String iCal, String ifMatchEtag) throws HttpException, IOException, OXException, URISyntaxException {
        return this.putICalUpdate(this.getDefaultFolderID(), resourceName, iCal, ifMatchEtag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int putICalUpdate(String folderID, String resourceName, String iCal, String ifMatchEtag) throws HttpException, IOException, OXException, URISyntaxException {
        int n;
        PutMethod put = null;
        try {
            String href = "/caldav/" + folderID + "/" + CalDAVTest.urlEncode(resourceName) + ".ics";
            put = new PutMethod(CalDAVTest.getBaseUri() + href);
            if (null != ifMatchEtag) {
                put.addRequestHeader("If-Match", ifMatchEtag);
            }
            put.setRequestEntity((RequestEntity)new StringRequestEntity(iCal, "text/calendar", null));
            n = this.getWebDAVClient().executeMethod((HttpMethod)put);
        }
        catch (Throwable throwable) {
            CalDAVTest.release(put);
            throw throwable;
        }
        CalDAVTest.release((HttpMethodBase)put);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int putICalUpdate(ICalResource iCalResource) throws HttpException, IOException, OXException {
        int n;
        PutMethod put = null;
        try {
            put = new PutMethod(CalDAVTest.getBaseUri() + iCalResource.getHref());
            if (null != iCalResource.getETag()) {
                put.addRequestHeader("If-Match", iCalResource.getETag());
            }
            put.setRequestEntity((RequestEntity)new StringRequestEntity(iCalResource.toString(), "text/calendar", null));
            n = this.getWebDAVClient().executeMethod((HttpMethod)put);
        }
        catch (Throwable throwable) {
            CalDAVTest.release(put);
            throw throwable;
        }
        CalDAVTest.release((HttpMethodBase)put);
        return n;
    }

    protected Appointment getAppointment(String folderID, String uid) throws OXException {
        Appointment[] appointments;
        for (Appointment appointment : appointments = this.testManager.all(CalDAVTest.parse(folderID), new Date(0L), new Date(100000000000000L), new int[]{1, 20, 223})) {
            if (!uid.equals(appointment.getUid())) continue;
            return this.testManager.get(appointment);
        }
        return null;
    }

    protected void rememberForCleanUp(Appointment appointment) {
        if (null != appointment) {
            this.getManager().getCreatedEntities().add(appointment);
        }
    }

    protected Appointment getAppointment(String uid) throws OXException {
        return this.getAppointment(this.getDefaultFolderID(), uid);
    }

    protected static int parse(String id) {
        return Integer.parseInt(id);
    }

    protected static String format(Date date, TimeZone timeZone) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmm'00'");
        dateFormat.setTimeZone(timeZone);
        return dateFormat.format(date);
    }

    protected static String format(Date date, String timeZoneID) {
        return CalDAVTest.format(date, TimeZone.getTimeZone(timeZoneID));
    }

    protected static Appointment generateAppointment(Date start, Date end, String uid, String summary, String location) {
        Appointment appointment = new Appointment();
        appointment.setTitle(summary);
        appointment.setLocation(location);
        appointment.setStartDate(start);
        appointment.setEndDate(end);
        appointment.setUid(uid);
        return appointment;
    }

    protected static String generateICal(Date start, Date end, String uid, String summary, String location) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("BEGIN:VCALENDAR").append("\r\n").append("VERSION:2.0").append("\r\n").append("PRODID:-//Apple Inc.//iCal 5.0.2//EN").append("\r\n").append("CALSCALE:GREGORIAN").append("\r\n").append("BEGIN:VTIMEZONE").append("\r\n").append("TZID:Europe/Amsterdam").append("\r\n").append("BEGIN:DAYLIGHT").append("\r\n").append("TZOFFSETFROM:+0100").append("\r\n").append("RRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU").append("\r\n").append("DTSTART:19810329T020000").append("\r\n").append("TZNAME:CEST").append("\r\n").append("TZOFFSETTO:+0200").append("\r\n").append("END:DAYLIGHT").append("\r\n").append("BEGIN:STANDARD").append("\r\n").append("TZOFFSETFROM:+0200").append("\r\n").append("RRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU").append("\r\n").append("DTSTART:19961027T030000").append("\r\n").append("TZNAME:CET").append("\r\n").append("TZOFFSETTO:+0100").append("\r\n").append("END:STANDARD").append("\r\n").append("END:VTIMEZONE").append("\r\n").append("BEGIN:VEVENT").append("\r\n").append("CREATED:").append(CalDAVTest.formatAsUTC(new Date())).append("\r\n");
        if (null != uid) {
            stringBuilder.append("UID:").append(uid).append("\r\n");
        }
        if (null != end) {
            stringBuilder.append("DTEND;TZID=Europe/Amsterdam:").append(CalDAVTest.format(end, "Europe/Amsterdam")).append("\r\n");
        }
        stringBuilder.append("TRANSP:OPAQUE").append("\r\n");
        if (null != summary) {
            stringBuilder.append("SUMMARY:").append(summary).append("\r\n");
        }
        if (null != location) {
            stringBuilder.append("LOCATION:").append(location).append("\r\n");
        }
        if (null != start) {
            stringBuilder.append("DTSTART;TZID=Europe/Amsterdam:").append(CalDAVTest.format(start, "Europe/Amsterdam")).append("\r\n");
        }
        stringBuilder.append("DTSTAMP:").append(CalDAVTest.formatAsUTC(new Date())).append("\r\n").append("SEQUENCE:0").append("\r\n").append("END:VEVENT").append("\r\n").append("END:VCALENDAR").append("\r\n");
        return stringBuilder.toString();
    }

    public static void assertEquals(Appointment appointment, Date expectedStart, Date expectedEnd, String expectedUid, String expectedTitle, String expectedLocation) {
        CalDAVTest.assertNotNull((String)"appointment is null", (Object)appointment);
        CalDAVTest.assertEquals((String)"start date wrong", (Object)expectedStart, (Object)appointment.getStartDate());
        CalDAVTest.assertEquals((String)"end date wrong", (Object)expectedEnd, (Object)appointment.getEndDate());
        CalDAVTest.assertEquals((String)"uid wrong", (String)expectedUid, (String)appointment.getUid());
        CalDAVTest.assertEquals((String)"title wrong", (String)expectedTitle, (String)appointment.getTitle());
        CalDAVTest.assertEquals((String)"location wrong", (String)expectedLocation, (String)appointment.getLocation());
    }

    public static ICalResource assertContains(String uid, Collection<ICalResource> iCalResources) {
        ICalResource match = null;
        for (ICalResource iCalResource : iCalResources) {
            if (!uid.equals(iCalResource.getVEvent().getUID())) continue;
            CalDAVTest.assertNull((String)("duplicate match for UID '" + uid + "'"), match);
            match = iCalResource;
        }
        CalDAVTest.assertNotNull((String)("no iCal resource with UID '" + uid + "' found"), match);
        return match;
    }

    protected Appointment create(Appointment appointment) {
        return this.create(this.getDefaultFolderID(), appointment);
    }

    protected Appointment create(String folderID, Appointment appointment) {
        appointment.setParentFolderID(CalDAVTest.parse(folderID));
        appointment.setIgnoreConflicts(true);
        return this.getManager().insert(appointment);
    }
}

