/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.framework.MultipleRequest;
import com.openexchange.ajax.framework.MultipleResponse;
import com.openexchange.ajax.task.AbstractTaskTest;
import com.openexchange.ajax.task.actions.AllRequest;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.ajax.task.actions.ListRequest;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.search.Order;
import com.openexchange.groupware.tasks.Task;
import java.util.ArrayList;
import java.util.Iterator;

public class ListTest
extends AbstractTaskTest {
    private static final int NUMBER = 10;
    private static final int DELETES = 2;
    private AJAXClient client;

    public ListTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
    }

    public void testTaskList() throws Throwable {
        InsertRequest[] inserts = new InsertRequest[10];
        for (int i = 0; i < inserts.length; ++i) {
            Task task = new Task();
            task.setTitle("Task " + (i + 1));
            task.setParentFolderID(this.getPrivateFolder());
            inserts[i] = new InsertRequest(task, this.getTimeZone());
        }
        MultipleResponse mInsert = (MultipleResponse)this.client.execute(MultipleRequest.create(inserts));
        int[][] tasks = new int[10][2];
        for (int i = 0; i < tasks.length; ++i) {
            InsertResponse insertR = (InsertResponse)((Object)mInsert.getResponse(i));
            tasks[i] = new int[]{insertR.getFolderId(), insertR.getId()};
        }
        int[] columns = new int[]{200, 1, 5};
        CommonListResponse listR = this.client.execute(new ListRequest(tasks, columns));
        DeleteRequest[] deletes = new DeleteRequest[inserts.length];
        for (int i = 0; i < inserts.length; ++i) {
            deletes[i] = new DeleteRequest(tasks[i][0], tasks[i][1], listR.getTimestamp());
        }
        this.client.execute(MultipleRequest.create(deletes));
    }

    public void oldRemovedObjectHandling() throws Throwable {
        int[] columns = new int[]{200, 1, 5};
        CommonListResponse listR = this.client.execute(new ListRequest((int[][])new int[][]{{this.getPrivateFolder(), Integer.MAX_VALUE}}, columns, false));
        ListTest.assertTrue((String)"No error when listing not existing object.", (boolean)listR.hasError());
    }

    public void testRemovedObjectHandling() throws Throwable {
        int folderA = this.client.getValues().getPrivateTaskFolder();
        AJAXClient clientB = new AJAXClient(AJAXClient.User.User2);
        int folderB = clientB.getValues().getPrivateTaskFolder();
        InsertRequest[] inserts = new InsertRequest[10];
        for (int i = 0; i < inserts.length; ++i) {
            Task task = new Task();
            task.setTitle("Task " + (i + 1));
            task.setParentFolderID(folderA);
            task.addParticipant((Participant)new UserParticipant(this.client.getValues().getUserId()));
            task.addParticipant((Participant)new UserParticipant(clientB.getValues().getUserId()));
            inserts[i] = new InsertRequest(task, this.getTimeZone());
        }
        MultipleResponse mInsert = (MultipleResponse)this.client.execute(MultipleRequest.create(inserts));
        ArrayList toDelete = new ArrayList(10);
        Iterator iter = mInsert.iterator();
        while (iter.hasNext()) {
            toDelete.add(iter.next());
        }
        int[] columns = new int[]{200, 1, 20};
        CommonAllResponse allR = this.client.execute(new AllRequest(folderA, columns, 200, Order.ASCENDING));
        DeleteRequest[] deletes1 = new DeleteRequest[2];
        for (int i = 0; i < deletes1.length; ++i) {
            InsertResponse insertR = (InsertResponse)((Object)toDelete.remove(4 + i));
            deletes1[i] = new DeleteRequest(folderB, insertR.getId(), insertR.getTimestamp());
        }
        clientB.execute(MultipleRequest.create(deletes1));
        CommonListResponse listR = this.client.execute(new ListRequest(allR.getListIDs(), columns, true));
        DeleteRequest[] deletes2 = new DeleteRequest[toDelete.size()];
        for (int i = 0; i < deletes2.length; ++i) {
            InsertResponse insertR = (InsertResponse)((Object)toDelete.get(i));
            deletes2[i] = new DeleteRequest(insertR.getFolderId(), insertR.getId(), listR.getTimestamp());
        }
        this.client.execute(MultipleRequest.create(deletes2));
    }
}

