/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.framework.MultipleRequest;
import com.openexchange.ajax.task.AbstractTaskTest;
import com.openexchange.ajax.task.TaskTools;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.GetResponse;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.groupware.tasks.Create;
import com.openexchange.groupware.tasks.Task;
import java.util.TimeZone;

public class InsertTest
extends AbstractTaskTest {
    public InsertTest(String name) {
        super(name);
    }

    public void testInsertPrivateTask() throws Throwable {
        AJAXClient client = this.getClient();
        int folderId = client.getValues().getPrivateTaskFolder();
        TimeZone timeZone = client.getValues().getTimeZone();
        Task task = Create.createTask();
        task.setParentFolderID(folderId);
        InsertResponse insertR = client.execute(new InsertRequest(task, timeZone));
        GetResponse getR = TaskTools.get(client, new GetRequest(insertR));
        Task reload = getR.getTask(timeZone);
        TaskTools.compareAttributes(task, reload);
        client.execute(new DeleteRequest(reload));
    }

    public void _testInsertTonnenTasks() throws Throwable {
        AJAXClient client = this.getClient();
        int folderId = client.getValues().getPrivateTaskFolder();
        TimeZone timeZone = client.getValues().getTimeZone();
        InsertRequest[] inserts = new InsertRequest[1000];
        for (int i = 0; i < inserts.length; ++i) {
            Task task = Create.createTask();
            task.setParentFolderID(folderId);
            inserts[i] = new InsertRequest(task, timeZone);
        }
        Executor.execute(client, MultipleRequest.create(inserts));
    }
}

