/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.task.AbstractTaskTest;
import com.openexchange.ajax.task.actions.ConfirmResponse;
import com.openexchange.ajax.task.actions.ConfirmWith2IdsRequest;
import com.openexchange.ajax.task.actions.ConfirmWithTaskInBodyRequest;
import com.openexchange.ajax.task.actions.ConfirmWithTaskInParametersRequest;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.GetResponse;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.tasks.Create;
import com.openexchange.groupware.tasks.Task;

public class Bug15897Test
extends AbstractTaskTest {
    private AJAXClient client;
    private AJAXClient client2;
    private Task task;
    private int participantId;

    public Bug15897Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        this.task = Create.createWithDefaults(this.getPrivateFolder(), "Task to test bug 15897");
        this.participantId = this.client2.getValues().getUserId();
        this.task.addParticipant((Participant)new UserParticipant(this.participantId));
        InsertRequest request = new InsertRequest(this.task, this.getTimeZone());
        InsertResponse response = this.client.execute(request);
        response.fillTask(this.task);
    }

    @Override
    protected void tearDown() throws Exception {
        DeleteRequest request = new DeleteRequest(this.task);
        this.client.execute(request);
        super.tearDown();
    }

    public void testConfirmWithIdOnlyInBody() throws Throwable {
        String message = "Task identifier in body of confirm request.";
        ConfirmWithTaskInBodyRequest request = new ConfirmWithTaskInBodyRequest(this.task, 3, message);
        ConfirmResponse response = this.client2.execute(request);
        this.task.setLastModified(response.getTimestamp());
        this.checkConfirmation(message, 3);
    }

    public void testConfirmWithIdOnlyInURL() throws Throwable {
        String message = "Task identifier in URL parameters of confirm request.";
        ConfirmWithTaskInParametersRequest request = new ConfirmWithTaskInParametersRequest(this.task, 2, message);
        ConfirmResponse response = this.client2.execute(request);
        this.task.setLastModified(response.getTimestamp());
        this.checkConfirmation(message, 2);
    }

    public void testConfirmWithIdInBodyAndURL() throws Throwable {
        String message = "Task identifier in URL parameters and body contains nonsense identifier.";
        ConfirmWith2IdsRequest request = new ConfirmWith2IdsRequest(this.task, Integer.MIN_VALUE, 1, message);
        ConfirmResponse response = this.client2.execute(request);
        this.task.setLastModified(response.getTimestamp());
        this.checkConfirmation(message, 1);
    }

    private void checkConfirmation(String confirmMessage, int confirmStatus) throws Throwable {
        GetRequest request = new GetRequest(this.task);
        GetResponse response = this.client.execute(request);
        Task test = response.getTask(this.getTimeZone());
        UserParticipant[] participants = test.getUsers();
        Bug15897Test.assertEquals((String)"Number of participants does not match.", (int)1, (int)participants.length);
        UserParticipant participant = participants[0];
        Bug15897Test.assertEquals((String)"Participant does not match.", (int)this.participantId, (int)participant.getIdentifier());
        Bug15897Test.assertEquals((String)"Confirmation message does not match.", (String)confirmMessage, (String)participant.getConfirmMessage());
        Bug15897Test.assertEquals((String)"Confirmation status does not match.", (int)confirmStatus, (int)participant.getConfirm());
    }
}

