/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.UserValues;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskAsserts;
import com.openexchange.groupware.tasks.TestTask;
import com.openexchange.java.Autoboxing;
import com.openexchange.test.TaskTestManager;
import java.util.HashSet;

public abstract class AbstractTaskTestForAJAXClient
extends AbstractAJAXSession {
    protected AbstractTaskTestForAJAXClient(String name) {
        super(name);
    }

    public TestTask getNewTask() {
        return this.getNewTask("Default task, created by " + ((Object)((Object)this)).getClass().getName());
    }

    public TestTask getNewTask(String title) {
        TestTask task = new TestTask();
        task.setTitle(title);
        UserValues values = this.getClient().getValues();
        try {
            task.setTimezone(values.getTimeZone());
            task.setParentFolderID(values.getPrivateTaskFolder());
            task.setCreatedBy(values.getUserId());
            task.setModifiedBy(values.getUserId());
        }
        catch (Exception e) {
            AbstractTaskTestForAJAXClient.fail((String)"Setup failed, could not get necessary values for timezone or private folder");
        }
        return task;
    }

    public void runSimpleInsertTest(Task task) {
        TaskTestManager testManager = null;
        try {
            testManager = new TaskTestManager(this.getClient());
        }
        catch (Exception e) {
            AbstractTaskTestForAJAXClient.fail((String)"Setup failed, TestManager could not be instantiated");
        }
        testManager.insertTaskOnServer(task);
        Task resultingTask = testManager.getTaskFromServer(task);
        HashSet<Integer> ignore = new HashSet<Integer>();
        ignore.add(Autoboxing.I((int)223));
        TaskAsserts.assertAllTaskFieldsMatchExcept(task, resultingTask, ignore);
        testManager.cleanUp();
    }

    public void runInsertAndUpdateTest(Task insertTask, Task updateTask, int ... fieldsThatChange) {
        HashSet<Integer> changingFields = new HashSet<Integer>();
        for (int field : fieldsThatChange) {
            changingFields.add(field);
        }
        changingFields.add(Autoboxing.I((int)4));
        changingFields.add(Autoboxing.I((int)5));
        changingFields.add(Autoboxing.I((int)223));
        TaskTestManager testManager = new TaskTestManager(this.getClient());
        testManager.insertTaskOnServer(insertTask);
        updateTask.setLastModified(insertTask.getLastModified());
        updateTask.setParentFolderID(insertTask.getParentFolderID());
        updateTask.setObjectID(insertTask.getObjectID());
        testManager.updateTaskOnServer(updateTask);
        Task getResult = testManager.getTaskFromServer(insertTask);
        TaskAsserts.assertAllTaskFieldsMatchExcept(insertTask, getResult, changingFields);
        TaskAsserts.assertTaskFieldsDiffer(insertTask, getResult, changingFields);
        Task[] allResults = testManager.getAllTasksOnServer(insertTask.getParentFolderID());
        Task allResult = testManager.findTaskByID(insertTask.getObjectID(), allResults);
        TaskAsserts.assertAllTaskFieldsMatchExcept(insertTask, allResult, changingFields);
        TaskAsserts.assertTaskFieldsDiffer(insertTask, getResult, changingFields);
        testManager.cleanUp();
    }
}

