/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.reminder;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.reminder.ReminderTools;
import com.openexchange.ajax.reminder.actions.DeleteRequest;
import com.openexchange.ajax.reminder.actions.RangeRequest;
import com.openexchange.ajax.reminder.actions.RangeResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.reminder.ReminderObject;
import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class Bug14111Test
extends AbstractAJAXSession {
    private AJAXClient client;
    private TimeZone tz;
    private Calendar calendar;
    private Appointment appointment;
    private Appointment exception;

    public Bug14111Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.tz = this.client.getValues().getTimeZone();
        this.calendar = GregorianCalendar.getInstance(this.tz);
        this.appointment = this.createAppointment();
        this.exception = this.createException();
    }

    public void testReminders() throws Exception {
        Calendar cal = (Calendar)this.calendar.clone();
        cal.setTime(this.appointment.getEndDate());
        for (int i = 0; i < 10; ++i) {
            ReminderObject reminder;
            RangeResponse rangeResp;
            RangeRequest rangeReq;
            if (i == 0) {
                rangeReq = new RangeRequest(cal.getTime());
                rangeResp = this.client.execute(rangeReq);
                reminder = ReminderTools.searchByTarget(rangeResp.getReminder(this.tz), this.appointment.getObjectID());
                ReminderObject exceptionReminder = ReminderTools.searchByTarget(rangeResp.getReminder(this.tz), this.exception.getObjectID());
                Bug14111Test.assertNull((String)"A reminder of the series was created on the exception appointment.", (Object)reminder);
                Bug14111Test.assertNotNull((String)"No reminder was created for the exception.", (Object)exceptionReminder);
                this.client.execute(new DeleteRequest(exceptionReminder, false));
                cal.add(5, 1);
                continue;
            }
            rangeReq = new RangeRequest(cal.getTime());
            rangeResp = this.client.execute(rangeReq);
            ReminderObject[] reminders = rangeResp.getReminder(this.tz);
            reminder = ReminderTools.searchByTarget(reminders, this.appointment.getObjectID());
            cal.add(5, 1);
            if (reminder == null) {
                Bug14111Test.fail((String)"No reminder found.");
                continue;
            }
            this.client.execute(new DeleteRequest(reminder, false));
        }
    }

    @Override
    public void tearDown() throws Exception {
        com.openexchange.ajax.appointment.action.DeleteRequest delReq1 = new com.openexchange.ajax.appointment.action.DeleteRequest(this.exception, false);
        this.client.execute(delReq1);
        GetRequest getApp = new GetRequest(this.appointment, false);
        GetResponse getAppResp = this.client.execute(getApp);
        Appointment toDelete = getAppResp.getAppointment(this.tz);
        com.openexchange.ajax.appointment.action.DeleteRequest delReq2 = new com.openexchange.ajax.appointment.action.DeleteRequest(toDelete, false);
        this.client.execute(delReq2);
        super.tearDown();
    }

    private Appointment createAppointment() throws OXException, IOException, SAXException, JSONException {
        Calendar cal = (Calendar)this.calendar.clone();
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testBug14111");
        cal.add(12, 10);
        appointmentObj.setStartDate(cal.getTime());
        cal.add(10, 1);
        appointmentObj.setEndDate(cal.getTime());
        appointmentObj.setAlarm(15);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        appointmentObj.setIgnoreConflicts(true);
        appointmentObj.setNote("");
        appointmentObj.setNotification(true);
        appointmentObj.setPrivateFlag(false);
        appointmentObj.setFullTime(false);
        appointmentObj.setRecurrenceType(1);
        appointmentObj.setInterval(1);
        appointmentObj.setOccurrence(10);
        UserParticipant newParticipant = new UserParticipant(this.client.getValues().getUserId());
        appointmentObj.addParticipant((Participant)newParticipant);
        InsertRequest insReq = new InsertRequest(appointmentObj, this.tz, false);
        AppointmentInsertResponse insResp = this.client.execute(insReq);
        insResp.fillAppointment(appointmentObj);
        return appointmentObj;
    }

    private Appointment createException() throws Exception {
        boolean recurrencePosition = true;
        Calendar cal = (Calendar)this.calendar.clone();
        cal.setTime(this.appointment.getStartDate());
        cal.add(5, 0);
        Appointment exception = new Appointment();
        exception.setTitle(this.appointment.getTitle() + " exception");
        exception.setIgnoreConflicts(true);
        exception.setParentFolderID(this.appointment.getParentFolderID());
        exception.setObjectID(this.appointment.getObjectID());
        exception.setRecurrencePosition(1);
        exception.setRecurrenceType(0);
        exception.setStartDate(cal.getTime());
        cal.add(10, 1);
        exception.setEndDate(cal.getTime());
        exception.setLastModified(this.appointment.getLastModified());
        exception.setAlarm(15);
        UpdateRequest insReq = new UpdateRequest(exception, this.tz, false);
        UpdateResponse insResp = this.client.execute(insReq);
        exception.setObjectID(insResp.getId());
        exception.setLastModified(insResp.getTimestamp());
        return exception;
    }
}

