/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.mail.TestMails;
import com.openexchange.ajax.mail.actions.AttachmentRequest;
import com.openexchange.ajax.mail.actions.DeleteRequest;
import com.openexchange.ajax.mail.actions.GetRequest;
import com.openexchange.ajax.mail.actions.GetResponse;
import com.openexchange.ajax.mail.actions.ImportMailRequest;
import com.openexchange.ajax.mail.actions.ImportMailResponse;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.MailListField;
import java.io.ByteArrayInputStream;
import org.json.JSONArray;
import org.json.JSONObject;

public class Bug15901Test
extends AbstractAJAXSession {
    private AJAXClient client;
    private String folder;
    private String address;
    private String[][] ids;

    public Bug15901Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.folder = this.client.getValues().getInboxFolder();
        this.address = this.client.getValues().getSendAddress();
        String testmail = TestMails.replaceAddresses("From: #ADDR#\nTo: #ADDR#\nSubject: Test for bug 15901\nMime-Version: 1.0\nContent-Type: text/html; charset=\"UTF-8\"\nContent-Transfer-Encoding: 8bit\n\nSome plain text... <br> blah <a href=\"www.xyz.de\">blubb</a><dl><dt>AA</dt><dd>Auto Answer (Modem)</dd><dt>AAE</dt><dd>Allgemeine Anschalte-Erlaubnis</dd><dt>AARP</dt><dd>Appletalk Address Resolution Protocol</dd></dl>", this.address);
        byte[] buf = testmail.getBytes();
        ByteArrayInputStream mail = new ByteArrayInputStream(buf);
        ImportMailRequest request = new ImportMailRequest(this.folder, 32, mail);
        ImportMailResponse response = this.client.execute(request);
        this.ids = response.getIds();
    }

    @Override
    protected void tearDown() throws Exception {
        DeleteRequest del = new DeleteRequest(this.ids);
        this.client.execute(del);
        super.tearDown();
    }

    public void testBug15901() throws Throwable {
        GetRequest request = new GetRequest(this.folder, this.ids[0][1], false);
        GetResponse response = this.client.execute(request);
        JSONArray attachmentArray = response.getAttachments();
        Bug15901Test.assertNotNull((String)"Attachments not present in JSON mail object.", (Object)attachmentArray);
        int len = attachmentArray.length();
        Bug15901Test.assertTrue((String)"Unexpected number of attachments: ", (len > 0 ? 1 : 0) != 0);
        String sequenceId = null;
        for (int i = 0; i < len && sequenceId == null; ++i) {
            JSONObject attachmentObject = attachmentArray.getJSONObject(i);
            String contentType = attachmentObject.getString(MailJSONField.CONTENT_TYPE.getKey());
            if (!contentType.regionMatches(true, 0, "text/htm", 0, 8)) continue;
            sequenceId = attachmentObject.getString(MailListField.ID.getKey());
        }
        Bug15901Test.assertTrue((String)"No HTML part found", (sequenceId != null ? 1 : 0) != 0);
        AttachmentRequest attachmentRequest = new AttachmentRequest(this.folder, this.ids[0][1], sequenceId);
        attachmentRequest.setSaveToDisk(false);
        attachmentRequest.setFilter(true);
        WebResponse webResponse = Executor.execute4Download(this.getSession(), attachmentRequest, AJAXConfig.getProperty(AJAXConfig.Property.PROTOCOL), AJAXConfig.getProperty(AJAXConfig.Property.HOSTNAME));
        String mailSourceCode = webResponse.getText();
        Bug15901Test.assertTrue((String)"Could not detect expected tags.", (mailSourceCode.contains("<dl>") && mailSourceCode.contains("<dt>") && mailSourceCode.contains("<dd>") ? 1 : 0) != 0);
    }
}

