/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.kata.tasks;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.kata.AbstractStep;
import com.openexchange.ajax.kata.IdentitySource;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.test.TaskTestManager;

public class TaskCreateStep
extends AbstractStep
implements IdentitySource<Task> {
    private final Task entry;
    private boolean inserted;
    private TaskTestManager manager;

    public TaskCreateStep(Task entry, String name, String expectedError) {
        super(name, expectedError);
        this.entry = entry;
    }

    @Override
    public void assumeIdentity(Task task) {
        task.setObjectID(this.entry.getObjectID());
        task.setParentFolderID(this.entry.getParentFolderID());
        task.setLastModified(this.entry.getLastModified());
    }

    @Override
    public void rememberIdentityValues(Task task) {
        this.entry.setLastModified(task.getLastModified());
        if (task.containsParentFolderID()) {
            this.entry.setParentFolderID(task.getParentFolderID());
        }
    }

    @Override
    public void forgetIdentity(Task entry) {
        this.inserted = false;
    }

    @Override
    public void cleanUp() throws Exception {
        if (!this.inserted) {
            return;
        }
        this.manager.deleteTaskOnServer(this.entry, false);
    }

    @Override
    public void perform(AJAXClient client) throws Exception {
        this.client = client;
        this.manager = new TaskTestManager(client);
        InsertRequest insertRequest = new InsertRequest(this.entry, this.getTimeZone(), false);
        InsertResponse insertResponse = this.execute(insertRequest);
        insertResponse.fillTask(this.entry);
        this.inserted = !insertResponse.hasError();
        this.checkError(insertResponse);
    }

    @Override
    public Class<Task> getType() {
        return Task.class;
    }
}

