/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.kata.folders;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.ajax.kata.AbstractStep;
import com.openexchange.ajax.kata.IdentitySource;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.test.FolderTestManager;
import java.util.Date;

public class FolderCreateStep
extends AbstractStep
implements IdentitySource<FolderObject> {
    private final FolderObject entry;
    private boolean inserted;
    private FolderTestManager manager;

    public FolderCreateStep(FolderObject entry, String name, String expectedError) {
        super(name, expectedError);
        this.entry = entry;
    }

    @Override
    public void cleanUp() throws Exception {
        if (this.inserted) {
            this.entry.setLastModified(new Date(Long.MAX_VALUE));
            this.manager.deleteFolderOnServer(this.entry);
            this.inserted = false;
        }
    }

    @Override
    public void perform(AJAXClient myClient) throws Exception {
        this.client = myClient;
        this.manager = new FolderTestManager(myClient);
        InsertRequest insertRequest = new InsertRequest(EnumAPI.OX_OLD, this.entry, false);
        CommonInsertResponse insertResponse = this.execute(insertRequest);
        insertResponse.fillObject((DataObject)this.entry);
        this.inserted = !insertResponse.hasError();
        this.checkError(insertResponse);
    }

    @Override
    public void assumeIdentity(FolderObject folder) {
        folder.setObjectID(this.entry.getObjectID());
        folder.setParentFolderID(this.entry.getParentFolderID());
        folder.setLastModified(this.entry.getLastModified());
        folder.setPermissions(this.entry.getPermissions());
    }

    @Override
    public void rememberIdentityValues(FolderObject folder) {
        folder.setLastModified(this.entry.getLastModified());
    }

    @Override
    public void forgetIdentity(FolderObject myEntry) {
        this.inserted = false;
    }

    @Override
    public Class<FolderObject> getType() {
        return FolderObject.class;
    }
}

