/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AbstractUploadParser;
import com.openexchange.ajax.importexport.actions.ICalImportResponse;
import com.openexchange.ajax.importexport.actions.ImportExportParser;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.importexport.ImportResult;
import org.json.JSONArray;
import org.json.JSONException;

public final class ICalImportParser
extends AbstractUploadParser<ICalImportResponse> {
    private final boolean failOnError;

    public ICalImportParser(boolean failOnError) {
        super(failOnError);
        this.failOnError = failOnError;
    }

    @Override
    protected ICalImportResponse createResponse(Response response) throws JSONException {
        ICalImportResponse retval = new ICalImportResponse(response);
        Object data = response.getData();
        if (data instanceof JSONArray) {
            JSONArray array = (JSONArray)data;
            ImportResult[] results = new ImportResult[array.length()];
            for (int i = 0; i < array.length(); ++i) {
                results[i] = ImportExportParser.parse(array.getString(i));
            }
            retval.setImports(results);
            for (ImportResult result : results) {
                String msg;
                OXException e = result.getException();
                String string = msg = e == null ? null : e.getMessage();
                if (!this.failOnError) continue;
                ICalImportParser.assertFalse((String)msg, (boolean)result.hasError());
            }
        } else if (this.failOnError) {
            ICalImportParser.fail((String)"Wrong data in response.");
        }
        return retval;
    }
}

