/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.openexchange.ajax.contact.AbstractManagedContactTest;
import com.openexchange.ajax.importexport.actions.VCardImportRequest;
import com.openexchange.ajax.importexport.actions.VCardImportResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Bug20360Test_UmlautBreaksImport
extends AbstractManagedContactTest {
    private final String vcard = "BEGIN:VCARD\nVERSION:3.0\nN;CHARSET=UTF-8:T\u00e4st;\u00dcser\nFN;CHARSET=UTF-8:Str\u00e4to\nEMAIL;TYPE=PREF,INTERNET:schneider@str\u00e4to.de\nEMAIL:schneider@strato.de\nEND:VCARD\n";

    public Bug20360Test_UmlautBreaksImport(String name) {
        super(name);
    }

    public void testUmlaut() throws IOException, JSONException, OXException {
        VCardImportRequest importRequest = new VCardImportRequest(this.folderID, new ByteArrayInputStream("BEGIN:VCARD\nVERSION:3.0\nN;CHARSET=UTF-8:T\u00e4st;\u00dcser\nFN;CHARSET=UTF-8:Str\u00e4to\nEMAIL;TYPE=PREF,INTERNET:schneider@str\u00e4to.de\nEMAIL:schneider@strato.de\nEND:VCARD\n".getBytes("UTF-8")));
        VCardImportResponse importResponse = this.getClient().execute(importRequest);
        JSONArray data = (JSONArray)importResponse.getData();
        JSONObject jsonObject = data.getJSONObject(0);
        int objID = jsonObject.getInt("id");
        Contact actual = this.manager.getAction(this.folderID, objID);
        Bug20360Test_UmlautBreaksImport.assertTrue((boolean)actual.containsEmail1());
        Bug20360Test_UmlautBreaksImport.assertTrue((boolean)actual.containsEmail2());
        Bug20360Test_UmlautBreaksImport.assertEquals((String)"schneider@str\u00e4to.de", (String)actual.getEmail1());
        Bug20360Test_UmlautBreaksImport.assertEquals((String)"schneider@strato.de", (String)actual.getEmail2());
    }
}

