/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact.action;

import com.openexchange.ajax.contact.action.AbstractContactRequest;
import com.openexchange.ajax.contact.action.SearchParser;
import com.openexchange.ajax.contact.action.SearchResponse;
import com.openexchange.ajax.fields.OrderFields;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.groupware.search.ContactSearchObject;
import com.openexchange.groupware.search.Order;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class SearchRequest
extends AbstractContactRequest<SearchResponse> {
    private final JSONObject body = new JSONObject();
    private final SearchParser searchParser;
    private final List<AJAXRequest.Parameter> params = new ArrayList<AJAXRequest.Parameter>();

    public SearchRequest(String pattern, int inFolder, int[] columns, boolean failOnError) {
        this(pattern, inFolder, columns, -1, null, failOnError);
    }

    public SearchRequest(String pattern, boolean firstLetterOnly, int inFolder, int[] columns, int orderBy, String orderDir, boolean failOnError) {
        this(pattern, firstLetterOnly, inFolder, columns, orderBy, orderDir, null, failOnError);
    }

    public SearchRequest(String pattern, boolean firstLetterOnly, int inFolder, int[] columns, int orderBy, String orderDir, String collation, boolean failOnError) {
        this.searchParser = new SearchParser(failOnError, columns);
        this.param("action", "search");
        this.param("columns", this.join(columns));
        if (orderBy != -1) {
            this.param("sort", String.valueOf(orderBy));
        }
        if (orderDir != null) {
            this.param("order", orderDir);
        }
        if (collation != null) {
            this.param("collation", collation);
        }
        try {
            if (firstLetterOnly) {
                this.body.put("startletter", true);
                this.body.put("pattern", (Object)pattern);
                this.body.put("folder", inFolder);
            }
            if (inFolder != -1) {
                this.body.put("folder", inFolder);
            }
            if (pattern != null) {
                this.body.put("pattern", (Object)pattern);
            }
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
    }

    public SearchRequest(String pattern, int inFolder, int[] columns, int orderBy, String orderDir, boolean failOnError) {
        this(pattern, false, inFolder, columns, orderBy, orderDir, failOnError);
    }

    public SearchRequest(ContactSearchObject cso, int[] columns, boolean failOnError) {
        this(cso, columns, -1, null, failOnError);
    }

    public SearchRequest(ContactSearchObject cso, int[] columns, int orderBy, Order order) {
        this(cso, columns, orderBy, order, true);
    }

    public SearchRequest(ContactSearchObject cso, int[] columns, int orderBy, Order order, boolean failOnError) {
        this(cso, columns, orderBy, order, null, failOnError);
    }

    public SearchRequest(ContactSearchObject cso, int[] columns, int orderBy, Order order, String collation, boolean failOnError) {
        this.searchParser = new SearchParser(failOnError, columns);
        this.param("action", "search");
        this.param("columns", this.join(columns));
        if (orderBy != -1) {
            this.param("sort", Integer.toString(orderBy));
        }
        if (null != order) {
            this.param("order", OrderFields.write((Order)order));
        }
        if (null != collation) {
            this.param("collation", collation);
        }
        try {
            int singleFolderId;
            this.body.put("last_name", (Object)cso.getSurname());
            this.body.put("first_name", (Object)cso.getGivenName());
            this.body.put("display_name", (Object)cso.getDisplayName());
            this.body.put("yomiCompany", (Object)cso.getYomiCompany());
            this.body.put("yomiFirstName", (Object)cso.getYomiFirstName());
            this.body.put("yomiLastName", (Object)cso.getYomiLastName());
            this.body.put("email1", (Object)cso.getEmail1());
            this.body.put("email2", (Object)cso.getEmail2());
            this.body.put("email3", (Object)cso.getEmail3());
            if (cso.isEmailAutoComplete()) {
                this.body.put("emailAutoComplete", (Object)"true");
            }
            if (cso.isOrSearch()) {
                this.body.put("orSearch", (Object)"true");
            }
            if ((singleFolderId = cso.getFolder()) != -1) {
                this.body.put("folder", singleFolderId);
            }
            if (cso.getPattern() != null) {
                this.body.put("pattern", (Object)cso.getPattern());
            }
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
    }

    private void param(String key, String value) {
        if (value != null) {
            this.params.add(new AJAXRequest.Parameter(key, value));
        }
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        return this.params.toArray(new AJAXRequest.Parameter[this.params.size()]);
    }

    @Override
    public AbstractAJAXParser<SearchResponse> getParser() {
        return this.searchParser;
    }

    @Override
    public Object getBody() {
        return this.body;
    }

    private String join(int[] values) {
        StringBuilder b = new StringBuilder();
        for (int v : values) {
            b.append(v).append(", ");
        }
        b.setLength(b.length() - 2);
        return b.toString();
    }
}

