/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import java.util.Calendar;
import java.util.TimeZone;

public class Bug15986Test
extends AbstractAJAXSession {
    private AJAXClient client;
    private Appointment appointment;
    private TimeZone timeZone;

    public Bug15986Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.timeZone = this.getClient().getValues().getTimeZone();
        this.appointment = new Appointment();
        this.appointment.setTitle("Appointment for bug 15986");
        this.appointment.setIgnoreConflicts(true);
        this.appointment.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        Calendar calendar = TimeTools.createCalendar(this.timeZone);
        this.appointment.setStartDate(calendar.getTime());
        calendar.add(10, 1);
        this.appointment.setEndDate(calendar.getTime());
        InsertRequest request = new InsertRequest(this.appointment, this.timeZone);
        AppointmentInsertResponse response = this.client.execute(request);
        response.fillAppointment(this.appointment);
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.appointment));
        super.tearDown();
    }

    public void testForNullPointerException() throws Throwable {
        Appointment changed = new Appointment();
        changed.setObjectID(this.appointment.getObjectID());
        changed.setParentFolderID(this.appointment.getParentFolderID());
        changed.setLastModified(this.appointment.getLastModified());
        changed.setNote("Beschreibung");
        changed.setShownAs(2);
        UpdateRequest request = new UpdateRequest(changed, this.timeZone);
        UpdateResponse response = this.client.execute(request);
        Bug15986Test.assertFalse((boolean)response.hasError());
        response.fillObject((DataObject)this.appointment);
    }
}

