/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.OXCalendarExceptionCodes;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class Bug13214Test
extends AbstractAJAXSession {
    public Bug13214Test(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBugAsWritten() throws Exception {
        block8: {
            DeleteRequest deleteRequest;
            AJAXClient client = this.getClient();
            int folderId = client.getValues().getPrivateAppointmentFolder();
            TimeZone tz = client.getValues().getTimeZone();
            Appointment appointment = new Appointment();
            int objectId = 0;
            Date lastModified = null;
            try {
                appointment.setTitle("Bug 13214 Test");
                appointment.setParentFolderID(folderId);
                appointment.setIgnoreConflicts(true);
                Calendar calendar = TimeTools.createCalendar(tz);
                calendar.set(11, 8);
                calendar.set(12, 30);
                appointment.setStartDate(calendar.getTime());
                calendar.set(11, 10);
                appointment.setEndDate(calendar.getTime());
                InsertRequest insertRequest = new InsertRequest(appointment, tz, false);
                AppointmentInsertResponse insertResponse = client.execute(insertRequest);
                appointment.setObjectID(insertResponse.getId());
                appointment.setLastModified(insertResponse.getTimestamp());
                objectId = appointment.getObjectID();
                appointment.setObjectID(objectId);
                lastModified = appointment.getLastModified();
                Appointment updateAppointment = new Appointment();
                updateAppointment.setObjectID(objectId);
                updateAppointment.setParentFolderID(folderId);
                updateAppointment.setIgnoreConflicts(true);
                updateAppointment.setLastModified(lastModified);
                calendar.set(11, 11);
                updateAppointment.setStartDate(calendar.getTime());
                UpdateRequest updateRequest = new UpdateRequest(updateAppointment, tz, false);
                UpdateResponse updateResponse = client.execute(updateRequest);
                try {
                    Bug13214Test.assertTrue((String)"No Exception occurred.", (boolean)updateResponse.hasError());
                    OXException e = updateResponse.getException();
                    Bug13214Test.assertTrue((String)"Wrong Exception", (boolean)(e instanceof OXException));
                    Bug13214Test.assertTrue((String)"Wrong Exception", (boolean)e.similarTo(OXCalendarExceptionCodes.END_DATE_BEFORE_START_DATE.create()));
                }
                finally {
                    if (!updateResponse.hasError()) {
                        updateAppointment.setLastModified(updateResponse.getTimestamp());
                        lastModified = updateAppointment.getLastModified();
                    }
                }
                if (objectId == 0 || lastModified == null) break block8;
                deleteRequest = new DeleteRequest(objectId, folderId, lastModified);
            }
            catch (Throwable throwable) {
                if (objectId != 0 && lastModified != null) {
                    DeleteRequest deleteRequest2 = new DeleteRequest(objectId, folderId, lastModified);
                    client.execute(deleteRequest2);
                }
                throw throwable;
            }
            client.execute(deleteRequest);
        }
    }
}

