/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Calendar;
import java.util.TimeZone;

public class Bug12610Test
extends AbstractAJAXSession {
    public Bug12610Test(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBugAsWritten() throws Throwable {
        AJAXClient client = null;
        Appointment appointment = new Appointment();
        try {
            client = this.getClient();
            int folderId = client.getValues().getPrivateAppointmentFolder();
            TimeZone tz = client.getValues().getTimeZone();
            appointment.setTitle("Bug12610Test");
            appointment.setParentFolderID(folderId);
            appointment.setIgnoreConflicts(true);
            Calendar calendar = TimeTools.createCalendar(tz);
            calendar.set(5, 15);
            calendar.set(2, 5);
            calendar.set(1, 2009);
            calendar.set(11, 8);
            appointment.setStartDate(calendar.getTime());
            calendar.set(11, 9);
            appointment.setEndDate(calendar.getTime());
            appointment.setRecurrenceType(4);
            appointment.setInterval(1);
            appointment.setDayInMonth(15);
            appointment.setMonth(5);
            Calendar until = TimeTools.createCalendar(TimeZone.getTimeZone("UTC"));
            until.set(5, 12);
            until.set(2, 11);
            until.set(1, 2012);
            until.set(11, 0);
            until.set(12, 0);
            until.set(13, 0);
            until.set(14, 0);
            appointment.setUntil(until.getTime());
            InsertRequest request = new InsertRequest(appointment, tz);
            CommonInsertResponse response = client.execute(request);
            appointment.setObjectID(response.getId());
            appointment.setLastModified(response.getTimestamp());
            until.set(5, 18);
            until.set(2, 6);
            until.set(1, 2014);
            appointment.setUntil(until.getTime());
            UpdateRequest updateRequest = new UpdateRequest(appointment, tz);
            UpdateResponse updateResponse = client.execute(updateRequest);
            appointment.setLastModified(updateResponse.getTimestamp());
        }
        finally {
            if (client != null && appointment.getObjectID() != 0 && appointment.getLastModified() != null) {
                DeleteRequest deleteRequest = new DeleteRequest(appointment.getObjectID(), client.getValues().getPrivateAppointmentFolder(), appointment.getLastModified());
                client.execute(deleteRequest);
            }
        }
    }
}

