/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.action;

import com.openexchange.ajax.appointment.action.AbstractAppointmentRequest;
import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.InsertParser;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.groupware.container.Appointment;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class InsertRequest
extends AbstractAppointmentRequest<AppointmentInsertResponse> {
    final Appointment appointmentObj;
    final TimeZone timeZone;
    final boolean failOnError;

    public InsertRequest(Appointment appointmentObj, TimeZone timeZone, boolean failOnError) {
        this.appointmentObj = appointmentObj;
        this.timeZone = timeZone;
        this.failOnError = failOnError;
    }

    public InsertRequest(Appointment appointment, TimeZone timeZone) {
        this(appointment, timeZone, true);
    }

    public JSONObject getBody() throws JSONException {
        return this.convert(this.appointmentObj, this.timeZone);
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        return new AJAXRequest.Parameter[]{new AJAXRequest.Parameter("action", "new"), new AJAXRequest.Parameter("folder", String.valueOf(this.appointmentObj.getParentFolderID()))};
    }

    @Override
    public AbstractAJAXParser<AppointmentInsertResponse> getParser() {
        return new InsertParser(this.failOnError);
    }
}

