/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.AppointmentTest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.groupware.configuration.AbstractConfigWrapper;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.webdav.xml.FolderTest;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoveTest
extends AppointmentTest {
    private static final Log LOG = LogFactory.getLog(MoveTest.class);

    public MoveTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testMove2PrivateFolder() throws Exception {
        Appointment appointmentObj = new Appointment();
        String date = String.valueOf(System.currentTimeMillis());
        appointmentObj.setTitle("testMove2PrivateFolder" + date);
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setOrganizer(AJAXClient.User.User1.name());
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        appointmentObj.setShownAs(1);
        int objectId = MoveTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        String login = AbstractConfigWrapper.parseProperty((Properties)this.getAJAXProperties(), (String)"login", (String)"");
        String context = AbstractConfigWrapper.parseProperty((Properties)this.getAJAXProperties(), (String)"contextName", (String)"defaultcontext");
        String password = AbstractConfigWrapper.parseProperty((Properties)this.getAJAXProperties(), (String)"password", (String)"");
        FolderObject folderObj = FolderTest.createFolderObject(this.userId, "testMove2PrivateFolder" + System.currentTimeMillis(), 2, false);
        int targetFolder = FolderTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), login, password, context);
        appointmentObj.setParentFolderID(targetFolder);
        MoveTest.updateAppointment(this.getWebConversation(), appointmentObj, objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        Appointment loadAppointment = MoveTest.loadAppointment(this.getWebConversation(), objectId, targetFolder, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        this.compareObject(appointmentObj, loadAppointment, appointmentObj.getStartDate().getTime(), appointmentObj.getEndDate().getTime());
        MoveTest.deleteAppointment(this.getWebConversation(), objectId, targetFolder, "http://" + this.getHostName(), this.getSessionId(), false);
        FolderTest.deleteFolder(this.getWebConversation(), new int[]{targetFolder}, "http://" + this.getHostName(), login, password, context);
    }

    public void testMove2PublicFolder() throws Exception {
        Appointment appointmentObj = new Appointment();
        String date = String.valueOf(System.currentTimeMillis());
        appointmentObj.setTitle("testMove2PublicFolder" + date);
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setOrganizer(AJAXClient.User.User1.name());
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        appointmentObj.setShownAs(1);
        int objectId = MoveTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        String login = AbstractConfigWrapper.parseProperty((Properties)this.getAJAXProperties(), (String)"login", (String)"");
        String context = AbstractConfigWrapper.parseProperty((Properties)this.getAJAXProperties(), (String)"contextName", (String)"defaultcontext");
        String password = AbstractConfigWrapper.parseProperty((Properties)this.getAJAXProperties(), (String)"password", (String)"");
        FolderObject folderObj = FolderTest.createFolderObject(this.userId, "testMove2PublicFolder" + System.currentTimeMillis(), 2, true);
        int targetFolder = FolderTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), login, password, context);
        appointmentObj.setParentFolderID(targetFolder);
        MoveTest.updateAppointment(this.getWebConversation(), appointmentObj, objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        Appointment loadAppointment = MoveTest.loadAppointment(this.getWebConversation(), objectId, targetFolder, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        this.compareObject(appointmentObj, loadAppointment, appointmentObj.getStartDate().getTime(), appointmentObj.getEndDate().getTime());
        MoveTest.deleteAppointment(this.getWebConversation(), objectId, targetFolder, "http://" + this.getHostName(), this.getSessionId(), false);
        FolderTest.deleteFolder(this.getWebConversation(), new int[]{targetFolder}, "http://" + this.getHostName(), login, password, context);
    }
}

