/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.LoginTest;
import com.openexchange.java.Charsets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.xml.sax.SAXException;

public class TestFolder
extends TestCase {
    private String sessionId = null;
    private WebConversation wc = null;
    private WebRequest req = null;
    private WebResponse resp = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.wc = new WebConversation();
        this.sessionId = LoginTest.getSessionId(this.wc, "127.0.0.1", "marcus", "netline");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetRootFolders() throws IOException, SAXException {
        this.req = new GetMethodWebRequest("http://127.0.0.1/ajax/folders?session=" + this.sessionId);
        this.resp = this.wc.getResponse(this.req);
        TestFolder.assertFalse((this.resp.getText().indexOf("error") > -1 ? 1 : 0) != 0);
    }

    public void testGetSubfolders() throws IOException, SAXException {
        this.req = new GetMethodWebRequest("http://127.0.0.1/ajax/folders?session=" + this.sessionId + "&gparent=127");
        this.resp = this.wc.getResponse(this.req);
        TestFolder.assertFalse((this.resp.getText().indexOf("error") > -1 ? 1 : 0) != 0);
        this.req = new GetMethodWebRequest("http://127.0.0.1/ajax/folders?session=" + this.sessionId + "&gparent=INBOX");
        this.resp = this.wc.getResponse(this.req);
        TestFolder.assertFalse((this.resp.getText().indexOf("error") > -1 ? 1 : 0) != 0);
    }

    public void testGetFolder() throws IOException, SAXException {
        this.req = new GetMethodWebRequest("http://127.0.0.1/ajax/folders?session=" + this.sessionId + "&id=290");
        this.resp = this.wc.getResponse(this.req);
        TestFolder.assertFalse((this.resp.getText().indexOf("error") > -1 ? 1 : 0) != 0);
        this.req = new GetMethodWebRequest("http://127.0.0.1/ajax/folders?session=" + this.sessionId + "&id=INBOX");
        this.resp = this.wc.getResponse(this.req);
        TestFolder.assertFalse((this.resp.getText().indexOf("error") > -1 ? 1 : 0) != 0);
    }

    public void testCreateUpdateDeleteFolder() throws IOException, SAXException {
        String oxFolderName = "CalendarFolder07";
        String mailFolderName = "MyMailFolder25";
        String newOXFolderObj = "{\"folder_id\":65,\"permissions\":[{\"group\":false,\"bits\":403710016,\"entity\":140}],\"title\":\"CalendarFolder07\",\"module\":2}";
        String newMailFolderObj = "{\"folder_id\":\"INBOX\",\"permissions\":[{\"group\":false,\"bits\":\"lrswipcda\",\"entity\":140}],\"title\":\"MyMailFolder25\",\"module\":7}";
        String expectedInsertPrefix = "{OK: Folder successfully inserted";
        int oxFolderId = -1;
        String mailFolderFullName = null;
        byte[] bytes = "{\"folder_id\":65,\"permissions\":[{\"group\":false,\"bits\":403710016,\"entity\":140}],\"title\":\"CalendarFolder07\",\"module\":2}".getBytes(Charsets.UTF_8);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        this.req = new PutMethodWebRequest("http://127.0.0.1/ajax/folders?session=" + this.sessionId + "&folder=65", (InputStream)bais, "text/javascript; charset=UTF-8");
        this.resp = this.wc.getResponse(this.req);
        if (this.resp.getText().indexOf(40) > -1) {
            oxFolderId = Integer.parseInt(this.resp.getText().substring(this.resp.getText().indexOf(40) + 1, this.resp.getText().indexOf(41)));
        }
        TestFolder.assertTrue((boolean)this.resp.getText().startsWith("{OK: Folder successfully inserted"));
        bytes = "{\"folder_id\":\"INBOX\",\"permissions\":[{\"group\":false,\"bits\":\"lrswipcda\",\"entity\":140}],\"title\":\"MyMailFolder25\",\"module\":7}".getBytes(Charsets.UTF_8);
        bais = new ByteArrayInputStream(bytes);
        this.req = new PutMethodWebRequest("http://127.0.0.1/ajax/folders?session=" + this.sessionId + "&folder=INBOX", (InputStream)bais, "text/javascript; charset=UTF-8");
        this.resp = this.wc.getResponse(this.req);
        if (this.resp.getText().indexOf(40) > -1) {
            mailFolderFullName = this.resp.getText().substring(this.resp.getText().indexOf(40) + 1, this.resp.getText().indexOf(41));
        }
        TestFolder.assertTrue((boolean)this.resp.getText().startsWith("{OK: Folder successfully inserted"));
        String updateOXFolderObj = "{\"folder_id\":65,\"permissions\":[{\"group\":false,\"bits\":403710016,\"entity\":140}],\"title\":\"CalendarFolder07_Changed\",\"module\":2}";
        String updateMailFolderObj = "{\"folder_id\":\"INBOX\",\"permissions\":[{\"group\":false,\"bits\":\"lrswipcda\",\"entity\":140}],\"title\":\"MyMailFolder25Changed\",\"module\":7}";
        String expectedUpdatePrefix = "{OK: Folder successfully updated";
        bytes = "{\"folder_id\":65,\"permissions\":[{\"group\":false,\"bits\":403710016,\"entity\":140}],\"title\":\"CalendarFolder07_Changed\",\"module\":2}".getBytes(Charsets.UTF_8);
        bais = new ByteArrayInputStream(bytes);
        this.req = new PutMethodWebRequest("http://127.0.0.1/ajax/folders?session=" + this.sessionId + "&id=" + oxFolderId, (InputStream)bais, "text/javascript; charset=UTF-8");
        this.resp = this.wc.getResponse(this.req);
        TestFolder.assertTrue((boolean)this.resp.getText().startsWith("{OK: Folder successfully updated"));
        bytes = "{\"folder_id\":\"INBOX\",\"permissions\":[{\"group\":false,\"bits\":\"lrswipcda\",\"entity\":140}],\"title\":\"MyMailFolder25Changed\",\"module\":7}".getBytes(Charsets.UTF_8);
        bais = new ByteArrayInputStream(bytes);
        this.req = new PutMethodWebRequest("http://127.0.0.1/ajax/folders?session=" + this.sessionId + "&id=" + mailFolderFullName, (InputStream)bais, "text/javascript; charset=UTF-8");
        this.resp = this.wc.getResponse(this.req);
        TestFolder.assertTrue((boolean)this.resp.getText().startsWith("{OK: Folder successfully updated"));
        String expectedDeletePrefix = "{OK: Folder successfully deleted";
        bytes = "".getBytes(Charsets.UTF_8);
        bais = new ByteArrayInputStream(bytes);
        this.req = new PostMethodWebRequest("http://127.0.0.1/ajax/folders?session=" + this.sessionId + "&delete=" + oxFolderId, (InputStream)bais, "text/javascript; charset=UTF-8");
        this.resp = this.wc.getResponse(this.req);
        TestFolder.assertTrue((boolean)this.resp.getText().startsWith("{OK: Folder successfully deleted"));
        mailFolderFullName = mailFolderFullName + "Changed";
        bytes = "".getBytes(Charsets.UTF_8);
        bais = new ByteArrayInputStream(bytes);
        this.req = new PostMethodWebRequest("http://127.0.0.1/ajax/folders?session=" + this.sessionId + "&delete=" + mailFolderFullName, (InputStream)bais, "text/javascript; charset=UTF-8");
        this.resp = this.wc.getResponse(this.req);
        TestFolder.assertTrue((boolean)this.resp.getText().startsWith("{OK: Folder successfully deleted"));
    }
}

