/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.AbstractJSONValue;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.json.helpers.CharArrayWriter;
import org.json.helpers.StringAllocator;
import org.json.helpers.UnsynchronizedStringReader;
import org.json.helpers.UnsynchronizedStringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONArray
extends AbstractJSONValue {
    private final List<Object> myArrayList;
    private static final String STR_ERR01 = "JSONArray[";
    private static final String EMPTY = "[]".intern();

    public JSONArray() {
        this.myArrayList = new ArrayList<Object>();
    }

    public JSONArray(int initialCapacity) {
        this.myArrayList = new ArrayList<Object>(initialCapacity);
    }

    public JSONArray(JSONTokener x) throws JSONException {
        this();
        if (x.nextClean() != '[') {
            throw x.syntaxError("A JSONArray text must start with '['");
        }
        if (x.nextClean() == ']') {
            return;
        }
        x.back();
        block4: while (true) {
            if (x.nextClean() == ',') {
                x.back();
                this.myArrayList.add(null);
            } else {
                x.back();
                this.myArrayList.add(x.nextValue());
            }
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == ']') {
                        return;
                    }
                    x.back();
                    continue block4;
                }
                case ']': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or ']'");
    }

    public JSONArray(Reader reader) throws JSONException {
        this();
        JSONArray.parse(reader, this);
    }

    public JSONArray(String string) throws JSONException {
        this();
        JSONArray.parse(new UnsynchronizedStringReader(string), this);
    }

    private static String checkString(String string) throws JSONException {
        if (string == null) {
            throw new JSONException("String must not be null.");
        }
        if (JSONArray.isEmpty(string)) {
            throw new JSONException("A JSONArray text must start with '['");
        }
        if (string.indexOf(93) <= 0) {
            throw new JSONException("A JSONArray text must start with '[' and must end with ']'");
        }
        return string;
    }

    private static boolean isEmpty(String string) {
        int len = string.length();
        boolean isWhitespace = true;
        int i = 0;
        while (isWhitespace && i < len) {
            isWhitespace = Character.isWhitespace(string.charAt(i));
            ++i;
        }
        return isWhitespace;
    }

    public JSONArray(Collection<? extends Object> collection) {
        this.myArrayList = collection == null ? new ArrayList<Object>() : new ArrayList<Object>(collection);
    }

    @Override
    public void reset() {
        this.myArrayList.clear();
    }

    public Object get(int index) throws JSONException {
        Object o = this.opt(index);
        if (o == null) {
            throw new JSONException(STR_ERR01 + index + "] not found.");
        }
        return o;
    }

    public boolean getBoolean(int index) throws JSONException {
        Object o = this.get(index);
        if (o.equals(Boolean.FALSE) || o instanceof String && "false".equalsIgnoreCase((String)o)) {
            return false;
        }
        if (o.equals(Boolean.TRUE) || o instanceof String && "true".equalsIgnoreCase((String)o)) {
            return true;
        }
        throw new JSONException(STR_ERR01 + index + "] is not a Boolean.");
    }

    public double getDouble(int index) throws JSONException {
        Object o = this.get(index);
        try {
            return o instanceof Number ? ((Number)o).doubleValue() : Double.parseDouble((String)o);
        }
        catch (Exception e) {
            throw new JSONException(STR_ERR01 + index + "] is not a number.", e);
        }
    }

    public int getInt(int index) throws JSONException {
        Object o = this.get(index);
        return o instanceof Number ? ((Number)o).intValue() : (int)this.getDouble(index);
    }

    public JSONArray getJSONArray(int index) throws JSONException {
        Object o = this.get(index);
        if (o instanceof JSONArray) {
            return (JSONArray)o;
        }
        throw new JSONException(STR_ERR01 + index + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(int index) throws JSONException {
        Object o = this.get(index);
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        throw new JSONException(STR_ERR01 + index + "] is not a JSONObject.");
    }

    public long getLong(int index) throws JSONException {
        Object o = this.get(index);
        return o instanceof Number ? ((Number)o).longValue() : (long)this.getDouble(index);
    }

    public String getString(int index) throws JSONException {
        return this.get(index).toString();
    }

    public boolean isNull(int index) {
        return JSONObject.NULL.equals(this.opt(index));
    }

    public String join(String separator) throws JSONException {
        int len = this.length();
        StringAllocator sb = new StringAllocator(len << 4);
        int i = 0;
        while (i < len) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(JSONObject.valueToString(this.myArrayList.get(i)));
            ++i;
        }
        return sb.toString();
    }

    @Override
    public int length() {
        return this.myArrayList.size();
    }

    public Object opt(int index) {
        return index < 0 || index >= this.length() ? null : this.myArrayList.get(index);
    }

    public boolean optBoolean(int index) {
        return this.optBoolean(index, false);
    }

    public boolean optBoolean(int index, boolean defaultValue) {
        try {
            return this.getBoolean(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double optDouble(int index) {
        return this.optDouble(index, Double.NaN);
    }

    public double optDouble(int index, double defaultValue) {
        try {
            return this.getDouble(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int optInt(int index) {
        return this.optInt(index, 0);
    }

    public int optInt(int index, int defaultValue) {
        try {
            return this.getInt(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public JSONArray optJSONArray(int index) {
        Object o = this.opt(index);
        return o instanceof JSONArray ? (JSONArray)o : null;
    }

    public JSONObject optJSONObject(int index) {
        Object o = this.opt(index);
        return o instanceof JSONObject ? (JSONObject)o : null;
    }

    public long optLong(int index) {
        return this.optLong(index, 0L);
    }

    public long optLong(int index, long defaultValue) {
        try {
            return this.getLong(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String optString(int index) {
        return this.optString(index, "");
    }

    public String optString(int index, String defaultValue) {
        Object o = this.opt(index);
        return o != null ? o.toString() : defaultValue;
    }

    public JSONArray put(boolean value) {
        this.put(value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONArray put(Collection<? extends Object> value) {
        this.put(new JSONArray(value));
        return this;
    }

    public JSONArray put(double value) throws JSONException {
        Double d = value;
        this.put(d);
        return this;
    }

    public JSONArray put(int value) {
        this.put((Object)value);
        return this;
    }

    public JSONArray put(long value) {
        this.put((Object)value);
        return this;
    }

    public JSONArray put(Map<String, ? extends Object> value) {
        this.put(new JSONObject(value));
        return this;
    }

    public JSONArray put(Object value) {
        this.myArrayList.add(value);
        return this;
    }

    public JSONArray put(int index, boolean value) throws JSONException {
        this.put(index, value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONArray put(int index, Collection<? extends Object> value) throws JSONException {
        this.put(index, new JSONArray(value));
        return this;
    }

    public JSONArray put(int index, double value) throws JSONException {
        this.put(index, (Object)value);
        return this;
    }

    public JSONArray put(int index, int value) throws JSONException {
        this.put(index, (Object)value);
        return this;
    }

    public JSONArray put(int index, long value) throws JSONException {
        this.put(index, (Object)value);
        return this;
    }

    public JSONArray put(int index, Map<String, ? extends Object> value) throws JSONException {
        this.put(index, new JSONObject(value));
        return this;
    }

    /*
     * Unable to fully structure code
     */
    public JSONArray put(int index, Object value) throws JSONException {
        block2: {
            if (index < 0) {
                throw new JSONException("JSONArray[" + index + "] not found.");
            }
            if (index >= this.length()) ** GOTO lbl9
            this.myArrayList.set(index, value);
            break block2;
lbl-1000:
            // 1 sources

            {
                this.put(JSONObject.NULL);
lbl9:
                // 2 sources

                ** while (index != this.length())
            }
lbl10:
            // 1 sources

            this.put(value);
        }
        return this;
    }

    public JSONObject toJSONObject(JSONArray names) throws JSONException {
        if (names == null || names.length() == 0 || this.length() == 0) {
            return null;
        }
        JSONObject jo = new JSONObject();
        int i = 0;
        while (i < names.length()) {
            jo.put(names.getString(i), this.opt(i));
            ++i;
        }
        return jo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString() {
        try {
            int n = this.length();
            if (n <= 0) {
                return EMPTY;
            }
            if (!JSONObject.USE_CHAR_POOL.get()) {
                UnsynchronizedStringWriter writer = new UnsynchronizedStringWriter(n << 4);
                this.write(writer);
                return writer.toString();
            }
            CharArrayWriter writer = new CharArrayWriter(n << 4);
            try {
                this.write(writer);
                String string = writer.toString();
                return string;
            }
            finally {
                writer.resetCharArray();
            }
        }
        catch (Exception e) {
            Logger logger = JSONObject.LOGGER.get();
            if (logger == null) return null;
            logger.logp(Level.SEVERE, JSONArray.class.getName(), "toString()", e.getMessage(), e);
            return null;
        }
    }

    public String toString(int indentFactor) throws JSONException {
        int n = this.length();
        if (n <= 0) {
            return EMPTY;
        }
        if (JSONObject.USE_CHAR_POOL.get()) {
            CharArrayWriter writer = new CharArrayWriter(n << 4);
            JsonGenerator jGenerator = null;
            try {
                jGenerator = JSON_FACTORY.createGenerator(writer);
                jGenerator.setPrettyPrinter(STANDARD_DEFAULT_PRETTY_PRINTER);
                JSONArray.write(this, jGenerator);
                String string = writer.toString();
                return string;
            }
            catch (IOException e) {
                throw new JSONException(e);
            }
            finally {
                JSONArray.close(jGenerator);
                writer.resetCharArray();
            }
        }
        return this.toString(indentFactor, 0);
    }

    @Override
    public String toString(int indentFactor, int indent) throws JSONException {
        String string;
        int len = this.length();
        if (len == 0) {
            return EMPTY;
        }
        if (JSONObject.USE_CHAR_POOL.get()) {
            CharArrayWriter writer = new CharArrayWriter(len << 4);
            JsonGenerator jGenerator = null;
            try {
                jGenerator = JSON_FACTORY.createGenerator(writer);
                jGenerator.setPrettyPrinter(STANDARD_DEFAULT_PRETTY_PRINTER);
                JSONArray.write(this, jGenerator);
                String string2 = writer.toString();
                return string2;
            }
            catch (IOException e) {
                throw new JSONException(e);
            }
            finally {
                JSONArray.close(jGenerator);
                writer.resetCharArray();
            }
        }
        JsonGenerator jGenerator = null;
        try {
            UnsynchronizedStringWriter writer = new UnsynchronizedStringWriter(len << 4);
            jGenerator = JSON_FACTORY.createGenerator(writer);
            jGenerator.setPrettyPrinter(STANDARD_DEFAULT_PRETTY_PRINTER);
            JSONArray.write(this, jGenerator);
            string = writer.toString();
        }
        catch (IOException e) {
            try {
                throw new JSONException(e);
            }
            catch (Throwable throwable) {
                JSONArray.close(jGenerator);
                throw throwable;
            }
        }
        JSONArray.close(jGenerator);
        return string;
    }

    @Override
    public Writer write(Writer writer) throws JSONException {
        JsonGenerator jGenerator = null;
        try {
            jGenerator = JSON_FACTORY.createGenerator(writer);
            jGenerator.setPrettyPrinter(STANDARD_MINIMAL_PRETTY_PRINTER);
            JSONArray.write(this, jGenerator);
            Writer writer2 = writer;
            return writer2;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
        finally {
            JSONArray.close(jGenerator);
        }
    }

    @Override
    protected void writeTo(JsonGenerator jGenerator) throws IOException, JSONException {
        JSONArray.write(this, jGenerator);
    }

    protected static void write(JSONArray ja, JsonGenerator jGenerator) throws IOException, JSONException {
        jGenerator.writeStartArray();
        try {
            List<Object> myArrayList = ja.myArrayList;
            int len = myArrayList.size();
            if (len > 0) {
                int i = 0;
                while (i < len) {
                    JSONArray.write(myArrayList.get(i), jGenerator);
                    ++i;
                }
            }
        }
        finally {
            JSONArray.writeEndAndFlush(jGenerator, false);
        }
    }

    protected static JSONArray parse(Reader reader, JSONArray optArray) throws JSONException {
        JsonParser jParser = null;
        try {
            jParser = JSONArray.createParser(reader);
            if (jParser.nextToken() != JsonToken.START_ARRAY) {
                throw new JSONException("A JSONArray text must begin with '['");
            }
            JSONArray jSONArray = JSONArray.parse(jParser, optArray);
            return jSONArray;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
        finally {
            JSONArray.close(jParser);
        }
    }

    protected static JSONArray parse(JsonParser jParser, JSONArray optArray) throws JSONException {
        try {
            JSONArray ja = optArray == null ? new JSONArray() : optArray;
            JsonToken current = jParser.nextToken();
            while (current != JsonToken.END_ARRAY) {
                if (current == JsonToken.FIELD_NAME) {
                    throw new JSONException("JSON parse error: Got a field name inside a JSONArray.");
                }
                switch (current) {
                    case START_OBJECT: {
                        ja.put(JSONObject.parse(jParser, null));
                        break;
                    }
                    case START_ARRAY: {
                        ja.put(JSONArray.parse(jParser, null));
                        break;
                    }
                    case VALUE_FALSE: {
                        ja.put(false);
                        break;
                    }
                    case VALUE_NULL: {
                        ja.put(JSONObject.NULL);
                        break;
                    }
                    case VALUE_NUMBER_FLOAT: {
                        try {
                            ja.put(jParser.getFloatValue());
                        }
                        catch (JsonParseException e) {
                            ja.put(jParser.getDoubleValue());
                        }
                        break;
                    }
                    case VALUE_NUMBER_INT: {
                        try {
                            ja.put(jParser.getIntValue());
                        }
                        catch (JsonParseException e) {
                            ja.put(jParser.getLongValue());
                        }
                        break;
                    }
                    case VALUE_TRUE: {
                        ja.put(true);
                        break;
                    }
                    case VALUE_STRING: {
                        ja.put(jParser.getText());
                        break;
                    }
                }
                current = jParser.nextToken();
            }
            return ja;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public boolean isObject() {
        return false;
    }
}

